/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.core.document;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TypeLabel implements Enumerator
{
    LAZY(0, "LAZY", "LAZY"),
    EXPLICIT(1, "EXPLICIT", "EXPLICIT");

    public static final int LAZY_VALUE = 0;
    public static final int EXPLICIT_VALUE = 1;
    private static final TypeLabel[] VALUES_ARRAY;
    public static final List<TypeLabel> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TypeLabel[]{LAZY, EXPLICIT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TypeLabel get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TypeLabel result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TypeLabel getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TypeLabel result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TypeLabel get(int value) {
        switch (value) {
            case 0: {
                return LAZY;
            }
            case 1: {
                return EXPLICIT;
            }
        }
        return null;
    }

    private TypeLabel(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

