/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import com.ibm.jbatch.tck.artifacts.common.StatusConstants;
import javax.batch.api.BatchProperty;
import javax.batch.api.Decider;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.StepExecution;
import javax.batch.runtime.context.JobContext;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class DeciderTestsDecider
implements Decider,
StatusConstants {
    public static final String SPECIAL_EXIT_STATUS = "SpecialExitStatus";
    @Inject
    JobContext jobCtx;
    @Inject
    @BatchProperty(name="SpecialExitStatus")
    String specialExitStatus;

    public String decide(StepExecution[] stepExecutions) throws Exception {
        if (stepExecutions.length != 1) {
            throw new IllegalStateException("Expecting stepExecutions array of size 1, found one of size = " + stepExecutions.length);
        }
        for (StepExecution stepExec : stepExecutions) {
            if (stepExec == null) {
                throw new Exception("Null StepExecution from split.");
            }
            if (stepExec.getBatchStatus().equals((Object)BatchStatus.COMPLETED)) continue;
            throw new Exception("All step executions must be compelete before transitioning to a decider.");
        }
        StepExecution stepExec = stepExecutions[0];
        String coreExitStatus = this.coreExitStatus(stepExec);
        Integer count = (Integer)this.jobCtx.getTransientUserData();
        String retVal = count.toString() + ":" + coreExitStatus;
        return retVal;
    }

    private String coreExitStatus(StepExecution stepExec) {
        String action = (String)((Object)stepExec.getPersistentUserData());
        String currentExitStatus = stepExec.getExitStatus();
        if (currentExitStatus.equals("STEP:ES:Good")) {
            return action;
        }
        return this.specialExitStatus;
    }
}

