/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import com.ibm.jbatch.tck.artifacts.chunktypes.ReadRecord;
import java.util.logging.Logger;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.listener.AbstractItemReadListener;
import javax.batch.runtime.context.JobContext;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="myItemReadListenerImpl")
public class MyItemReadListenerImpl
extends AbstractItemReadListener {
    private static final String sourceClass = MyItemReadListenerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    int beforecounter = 1;
    int aftercounter = 1;
    public static final String GOOD_EXIT_STATUS = "MyItemReadListenerImpl: GOOD STATUS";
    public static final String BAD_EXIT_STATUS = "MyItemReadListenerImpl: BAD STATUS";
    @Inject
    JobContext jobCtx;
    @Inject
    @BatchProperty(name="app.listenertest")
    String applistenerTest;

    public void beforeRead() {
        logger.finer("In beforeRead()");
        ++this.beforecounter;
    }

    public void afterRead(Object item) throws Exception {
        if (item != null && "READ".equals(this.applistenerTest)) {
            logger.finer("In afterRead(), item = " + ((ReadRecord)item).getCount());
            ++this.aftercounter;
            if (this.beforecounter == this.aftercounter) {
                this.jobCtx.setExitStatus(GOOD_EXIT_STATUS);
            } else {
                this.jobCtx.setExitStatus(BAD_EXIT_STATUS);
            }
        }
    }

    public void onReadError(Exception e) throws Exception {
        logger.finer("In onReadRerror() " + e);
        this.jobCtx.setExitStatus("MyItemReadListenerImpl.onReadError");
    }
}

