/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import com.ibm.jbatch.tck.artifacts.chunktypes.ArrayIndexCheckpointData;
import com.ibm.jbatch.tck.artifacts.chunktypes.ReadRecord;
import com.ibm.jbatch.tck.artifacts.reusable.MyChildException;
import com.ibm.jbatch.tck.artifacts.reusable.MyParentException;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.AbstractItemReader;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="skipReader")
public class SkipReader
extends AbstractItemReader {
    private static final Logger logger = Logger.getLogger(SkipReader.class.getName());
    private int count = 0;
    private int[] readerDataArray;
    private int idx;
    private boolean threwSkipException = false;
    boolean throwChildEx = false;
    ArrayIndexCheckpointData _cpd = new ArrayIndexCheckpointData();
    @Inject
    @BatchProperty(name="readrecord.fail")
    String readrecordfailNumberString = null;
    @Inject
    @BatchProperty(name="execution.number")
    String executionNumberString;
    @Inject
    @BatchProperty(name="app.arraysize")
    String appArraySizeString;
    int[] failnum;
    int execnum;
    int arraysize;

    public void open(Serializable cpd) {
        if (this.readrecordfailNumberString != null) {
            String[] readFailPointsStrArr = this.readrecordfailNumberString.split(",");
            this.failnum = new int[readFailPointsStrArr.length];
            for (int i = 0; i < readFailPointsStrArr.length; ++i) {
                this.failnum[i] = Integer.parseInt(readFailPointsStrArr[i]);
            }
        } else {
            this.failnum = new int[1];
            this.failnum[0] = -1;
        }
        this.execnum = Integer.parseInt(this.executionNumberString);
        this.arraysize = Integer.parseInt(this.appArraySizeString);
        this.readerDataArray = new int[this.arraysize];
        for (int i = 0; i < this.arraysize; ++i) {
            this.readerDataArray[i] = i;
        }
        this.idx = cpd == null ? 0 : ((ArrayIndexCheckpointData)cpd).getCurrentIndex() + 1;
        logger.fine("READ: starting at index: " + this.idx);
    }

    public ReadRecord readItem() throws Exception {
        int i;
        if (this.threwSkipException) {
            ++this.count;
            ++this.idx;
            this.threwSkipException = false;
            this.throwChildEx = true;
        }
        if ((i = this.idx) == this.arraysize) {
            return null;
        }
        if (this.execnum == 2) {
            this.failnum[0] = -1;
        }
        if (this.isFailnum(this.idx)) {
            logger.fine("READ: got the fail num..." + this.failnum);
            this.threwSkipException = true;
            if (!this.throwChildEx) {
                throw new MyParentException("fail on purpose with MyParentException");
            }
            this.throwChildEx = false;
            throw new MyChildException("fail on purpose with MyChildException");
        }
        ++this.count;
        ++this.idx;
        this._cpd.setCurrentIndex(i);
        return new ReadRecord(this.readerDataArray[i]);
    }

    public ArrayIndexCheckpointData checkpointInfo() {
        logger.fine("READ: in getCPD cpd index from store: " + this._cpd.getCurrentIndex());
        logger.fine("READ: in getCPD idx : " + this.idx);
        return this._cpd;
    }

    private boolean isFailnum(int idxIn) {
        boolean ans = false;
        for (int i = 0; i < this.failnum.length; ++i) {
            if (idxIn != this.failnum[i]) continue;
            ans = true;
        }
        return ans;
    }
}

