/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.BaseJUnit5Test;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import ee.jakarta.tck.batch.util.Reporter;
import jakarta.batch.runtime.BatchStatus;
import java.io.File;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class PropertySubstitutionTests
extends BaseJUnit5Test {
    private static JobOperatorBridge jobOp;

    @BeforeEach
    public void setUp() throws Exception {
        jobOp = new JobOperatorBridge();
    }

    @AfterEach
    public void cleanUp() throws Exception {
        System.clearProperty("property.junit.result");
    }

    @Test
    public void testBatchArtifactPropertyInjection() throws Exception {
        String METHOD = "testBatchArtifactPropertyInjection";
        try {
            Reporter.log((String)"Locate job XML file: job_properties2.xml<p>");
            Reporter.log((String)"Set system property: property.junit.propName=myProperty1<p>");
            System.setProperty("property.junit.propName", "myProperty1");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_properties2");
            String result = System.getProperty("property.junit.result");
            Reporter.log((String)("Test result: " + result + "<p>"));
            AssertionUtils.assertObjEquals("value1", result);
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testInitializedPropertyIsOverwritten() throws Exception {
        String METHOD = "testInitializedPropertyIsOverwritten";
        try {
            Reporter.log((String)"Locate job XML file: job_properties2.xml<p>");
            Reporter.log((String)"Set system property: property.junit.propName=myProperty2<p>");
            System.setProperty("property.junit.propName", "myProperty2");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_properties2");
            String result = System.getProperty("property.junit.result");
            Reporter.log((String)("Test result: " + result + "<p>"));
            AssertionUtils.assertObjEquals("value2", result);
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testPropertyWithJobParameter() throws Exception {
        String METHOD = "testPropertyWithJobParameter";
        try {
            Reporter.log((String)"Locate job XML file: job_properties2.xml<p>");
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParameters = new Properties();
            String expectedResult = "mySubmittedValue";
            Reporter.log((String)("mySubmittedPropr=" + expectedResult + "<p>"));
            jobParameters.setProperty("mySubmittedProp", expectedResult);
            Reporter.log((String)"Set system property: property.junit.propName=mySubmittedProp<p>");
            System.setProperty("property.junit.propName", "mySubmittedProp");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_properties2", jobParameters);
            String result = System.getProperty("property.junit.result");
            Reporter.log((String)("Test result: " + result + "<p>"));
            AssertionUtils.assertObjEquals(expectedResult, result);
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testDefaultPropertyName() throws Exception {
        String METHOD = "testDefaultPropertyName";
        try {
            Reporter.log((String)"Locate job XML file: job_properties2.xml<p>");
            Reporter.log((String)"Set system property:property.junit.propName=property4<p>");
            System.setProperty("property.junit.propName", "property4");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_properties2");
            String result = System.getProperty("property.junit.result");
            Reporter.log((String)("Test result: " + result + "<p>"));
            AssertionUtils.assertObjEquals("value4", result);
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testGivenPropertyName() throws Exception {
        String METHOD = "testGivenPropertyName";
        try {
            Reporter.log((String)"Locate job XML file: job_properties2.xml<p>");
            Reporter.log((String)"Set system property:property.junit.propName=myProperty4<p>");
            System.setProperty("property.junit.propName", "myProperty4");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_properties2");
            String result = System.getProperty("property.junit.result");
            Reporter.log((String)("Test result: " + result + "<p>"));
            AssertionUtils.assertObjEquals("value4", result);
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testPropertyInnerScopePrecedence() throws Exception {
        String METHOD = "testPropertyInnerScopePrecedence";
        try {
            Reporter.log((String)"Locate job XML file: job_properties2.xml<p>");
            Reporter.log((String)"Set system property:property.junit.propName=batchletProp<p>");
            System.setProperty("property.junit.propName", "batchletProp");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_properties2");
            String result = System.getProperty("property.junit.result");
            Reporter.log((String)("Test result: " + result + "<p>"));
            AssertionUtils.assertObjEquals("batchletPropValue", result);
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testPropertyQuestionMarkSimple() throws Exception {
        String METHOD = "testPropertyQuestionMarkSimple";
        try {
            Reporter.log((String)"Locate job XML file: job_properties2.xml<p>");
            Reporter.log((String)"Set system property:property.junit.propName=defaultPropName1<p>");
            System.setProperty("property.junit.propName", "defaultPropName1");
            Reporter.log((String)"Set system property:file.name.junit=myfile1.txt<p>");
            System.setProperty("file.name.junit", "myfile1.txt");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_properties2");
            String result = System.getProperty("property.junit.result");
            Reporter.log((String)("Test result: " + result + "<p>"));
            AssertionUtils.assertObjEquals("myfile1.txt", result);
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testPropertyQuestionMarkComplex() throws Exception {
        String METHOD = "testPropertyQuestionMarkComplex";
        try {
            Reporter.log((String)"Locate job XML file: job_properties2.xml<p>");
            Reporter.log((String)"Set system property:property.junit.propName=defaultPropName2<p>");
            System.setProperty("property.junit.propName", "defaultPropName2");
            Reporter.log((String)"Set system property:file.name.junit=myfile2.txt<p>");
            System.setProperty("file.name.junit", "myfile2");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_properties2");
            String result = System.getProperty("property.junit.result");
            Reporter.log((String)("Test result: " + result + "<p>"));
            AssertionUtils.assertObjEquals(File.separator + "myfile2.txt", result);
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testPropertyWithConcatenation() throws Exception {
        String METHOD = "testPropertyWithConcatenation";
        try {
            Reporter.log((String)"Locate job XML file: job_properties2.xml<p>");
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParameters = new Properties();
            Reporter.log((String)"myFilename=testfile1<p>");
            jobParameters.setProperty("myFilename", "testfile1");
            Reporter.log((String)"Set system property:file.name.junit=myConcatProp<p>");
            System.setProperty("property.junit.propName", "myConcatProp");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_properties2", jobParameters);
            String result = System.getProperty("property.junit.result");
            Reporter.log((String)("Test result: " + result + "<p>"));
            AssertionUtils.assertObjEquals("testfile1.txt", result);
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testJavaSystemProperty() throws Exception {
        String METHOD = "testJavaSystemProperty";
        try {
            Reporter.log((String)"Locate job XML file: job_properties2.xml<p>");
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParameters = new Properties();
            Reporter.log((String)"myFilename=testfile2<p>");
            jobParameters.setProperty("myFilename", "testfile2");
            Reporter.log((String)"Set system property:file.name.junit=myJavaSystemProp<p>");
            System.setProperty("property.junit.propName", "myJavaSystemProp");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_properties2", jobParameters);
            String result = System.getProperty("property.junit.result");
            String pathSep = System.getProperty("file.separator");
            Reporter.log((String)("Test result: " + pathSep + "test" + pathSep + "testfile2.txt<p>"));
            AssertionUtils.assertObjEquals(pathSep + "test" + pathSep + "testfile2.txt", result);
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"CDIDependentScopedBatchletPropsNonString", "dependentScopedBatchletPropsNonString", "com.ibm.jbatch.tck.artifacts.cdi.DependentScopedBatchletPropsNonString"})
    public void testCDIBatchPropsNonString(String refName) throws Exception {
        String METHOD = "testCDIBatchPropsNonString";
        try {
            Properties jobParams = new Properties();
            jobParams.setProperty("refName", refName);
            jobParams.setProperty("stringProp", "HappyBatchProperties");
            jobParams.setProperty("booleanProp1", "true");
            jobParams.setProperty("booleanProp2", "Nope");
            jobParams.setProperty("doubleProp1", "234.432");
            jobParams.setProperty("doubleProp2", "123.321");
            jobParams.setProperty("floatProp1", Float.toString(11234.432f));
            jobParams.setProperty("floatProp2", Float.toString(11123.321f));
            jobParams.setProperty("intProp1", "7777");
            jobParams.setProperty("intProp2", "8888");
            jobParams.setProperty("longProp1", Long.toString(1234567890123L));
            jobParams.setProperty("longProp2", Long.toString(12345678901234L));
            jobParams.setProperty("shortProp1", "333");
            jobParams.setProperty("shortProp2", "444");
            Reporter.log((String)("starting job with refName = " + refName));
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("batch_props_non_string", jobParams);
            Reporter.log((String)("Job Status = " + String.valueOf(jobExec.getBatchStatus())));
            Reporter.log((String)("job ended with exit status = " + jobExec.getExitStatus()));
            Assertions.assertEquals((Object)BatchStatus.COMPLETED, (Object)jobExec.getBatchStatus(), (String)"Job didn't complete successfully");
            Reporter.log((String)"GOOD result");
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }
}

