/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.BaseJUnit5Test;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import ee.jakarta.tck.batch.util.Reporter;
import jakarta.batch.operations.JobExecutionNotMostRecentException;
import java.util.Properties;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class RestartNotMostRecentTests
extends BaseJUnit5Test {
    private static JobOperatorBridge jobOp = null;

    @Test
    public void testRestartNotMostRecentException() throws Exception {
        String METHOD = "testRestartNotMostRecentException";
        try {
            Reporter.log((String)"starting job");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            jobParams.put("execution.number", "1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_attributes_restart_true_test", jobParams);
            Properties restartParams = new Properties();
            Reporter.log((String)"execution.number=2<p>");
            restartParams.put("execution.number", "2");
            jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartParams);
            try {
                Reporter.log((String)"Trying to execute the first job execution again.");
                jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartParams);
                AssertionUtils.assertWithMessage("It should have thrown JobExecutionNotMostRecentException", false);
            }
            catch (JobExecutionNotMostRecentException e) {
                AssertionUtils.assertWithMessage("JobExecutionNotMostRecentException thrown", true);
            }
            Reporter.log((String)("Job Status = " + String.valueOf(jobExec.getBatchStatus())));
            Reporter.log((String)"job completed");
        }
        catch (Exception e) {
            RestartNotMostRecentTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }

    @BeforeAll
    public static void beforeTest() throws ClassNotFoundException {
        jobOp = new JobOperatorBridge();
    }

    @AfterAll
    public static void afterTest() {
        jobOp = null;
    }
}

