/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class JCOVGrabber {
    private static final String FILE_EXT = ".jcov";
    private int counter = 1;
    private int port;
    private File coverageFile;
    private File resultDir;
    private String fileName;
    private boolean prependTestData;
    private Project project;
    private String jcovClasspath;

    public JCOVGrabber(String fileName, String data, File resultDir, boolean prependTestdata, Project project, String jcovClasspath) throws Exception {
        this.project = project;
        this.jcovClasspath = jcovClasspath;
        this.resultDir = resultDir;
        this.fileName = fileName;
        this.prependTestData = prependTestdata;
        StringTokenizer datum = new StringTokenizer(data, " \t\n\r\f:");
        if (datum.countTokens() == 1) {
            this.port = Integer.parseInt(datum.nextToken());
        } else if (datum.countTokens() == 2) {
            this.coverageFile = new File(datum.nextToken());
            this.port = Integer.parseInt(datum.nextToken());
        } else {
            throw new Exception("Badly formed data \"" + data + "\"");
        }
        project.log("JCOVGrabber created [" + this.coverageFile + ", " + this.port + "]");
    }

    private String normalizeData(String data) {
        return data.replace(File.separatorChar, '-');
    }

    public void grab(String testArea) throws Exception {
        File resultFile = null;
        resultFile = this.prependTestData ? new File(this.resultDir, this.fileName + "-" + this.normalizeData(testArea) + "-" + this.counter++ + FILE_EXT) : new File(this.resultDir, this.fileName + "-" + this.counter++ + FILE_EXT);
        if (this.coverageFile != null) {
            if (this.coverageFile.isFile()) {
                this.copy(this.coverageFile, resultFile);
                this.project.log("Coverage results written to \"" + resultFile.getPath() + "\"");
            } else {
                this.project.log("Coverage file not found \"" + resultFile.getPath() + "\"");
            }
        } else {
            this.grabData(resultFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(File source, File destination) throws FileNotFoundException, IOException {
        int MAX_BUFFER_SIZE = 1024;
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        if (destination.isFile()) {
            throw new FileNotFoundException("Destination file \"" + destination + "\"exists");
        }
        BufferedInputStream sourceStream = new BufferedInputStream(new FileInputStream(source));
        BufferedOutputStream destinationStream = new BufferedOutputStream(new FileOutputStream(destination));
        try {
            while ((bytesRead = sourceStream.read(buffer, 0, buffer.length)) > 0) {
                destinationStream.write(buffer, 0, bytesRead);
            }
        }
        finally {
            sourceStream.close();
            destinationStream.close();
        }
    }

    private void grabData(File resultFile) {
        String outputFile = resultFile.getPath();
        Java command = (Java)this.project.createTask("java");
        command.setTaskName("Coverage_Grabber");
        command.setClasspath(new Path(this.project, this.jcovClasspath));
        command.setClassname("com.sun.tdk.jcov.grabber.Main");
        command.setFork(true);
        Commandline.Argument args = command.createArg();
        args.setLine("-port=" + this.port + " -once -verbose -output=" + outputFile);
        command.execute();
        this.project.log("Coverage results written to \"" + resultFile.getPath() + "\" from port " + this.port);
    }
}

