/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.ee;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.BaseJUnit5Test;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import ee.jakarta.tck.batch.util.Reporter;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.StepExecution;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="ee")
public class TransactionTests
extends BaseJUnit5Test {
    private static final Logger logger = Logger.getLogger(TransactionTests.class.getName());
    private static JobOperatorBridge jobOp;

    @BeforeEach
    public void setUp() throws Exception {
        jobOp = new JobOperatorBridge();
    }

    private void begin(String str) {
        Reporter.log((String)("Begin test method: " + str + "<p>"));
    }

    @Test
    public void testTranRollbackRetryReadSkipRead() throws Exception {
        String METHOD = "testTranRollbackRetryReadSkipRead";
        this.begin(METHOD);
        try {
            Integer initNumbers = 10;
            Integer forcedFailCountRead = 8;
            Integer forcedFailCountProcess = 0;
            Integer forcedFailCountWrite = 0;
            Integer dummyDelay = 0;
            Boolean rollback = true;
            Boolean autoCommit = false;
            Properties jobParams = new Properties();
            jobParams.put("jakarta.transaction.global.mode", "true");
            jobParams.put("jakarta.transaction.global.timeout", "20");
            jobParams.put("init.numbers.quantity", initNumbers.toString());
            jobParams.put("forced.fail.count.read", forcedFailCountRead.toString());
            jobParams.put("forced.fail.count.write", forcedFailCountWrite.toString());
            jobParams.put("forced.fail.count.process", forcedFailCountProcess.toString());
            jobParams.put("dummy.delay.seconds", dummyDelay.toString());
            jobParams.put("rollback", rollback.toString());
            jobParams.put("auto.commit", autoCommit.toString());
            Reporter.log((String)"Locate job XML file: job_chunk_retryskip_rollback.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_retryskip_rollback", jobParams);
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            TransactionTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testTranRollbackRetryProcessSkipProcess() throws Exception {
        String METHOD = "testTranRollbackRetryProcessSkipProcess";
        this.begin(METHOD);
        try {
            Integer initNumbers = 10;
            Integer forcedFailCountRead = 0;
            Integer forcedFailCountProcess = 8;
            Integer forcedFailCountWrite = 0;
            Integer dummyDelay = 0;
            Boolean rollback = true;
            Boolean autoCommit = false;
            Properties jobParams = new Properties();
            jobParams.put("jakarta.transaction.global.mode", "true");
            jobParams.put("jakarta.transaction.global.timeout", "20");
            jobParams.put("init.numbers.quantity", initNumbers.toString());
            jobParams.put("forced.fail.count.read", forcedFailCountRead.toString());
            jobParams.put("forced.fail.count.write", forcedFailCountWrite.toString());
            jobParams.put("forced.fail.count.process", forcedFailCountProcess.toString());
            jobParams.put("dummy.delay.seconds", dummyDelay.toString());
            jobParams.put("rollback", rollback.toString());
            jobParams.put("auto.commit", autoCommit.toString());
            Reporter.log((String)"Locate job XML file: job_chunk_retryskip_rollback.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_retryskip_rollback", jobParams);
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            TransactionTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testTranRollbackRetryWriteSkipWrite() throws Exception {
        String METHOD = "testTranRollbackRetryWriteSkipWrite";
        this.begin(METHOD);
        try {
            Integer initNumbers = 10;
            Integer forcedFailCountRead = 0;
            Integer forcedFailCountProcess = 0;
            Integer forcedFailCountWrite = 8;
            Integer dummyDelay = 0;
            Boolean rollback = true;
            Boolean autoCommit = false;
            Properties jobParams = new Properties();
            jobParams.put("jakarta.transaction.global.mode", "true");
            jobParams.put("jakarta.transaction.global.timeout", "20");
            jobParams.put("init.numbers.quantity", initNumbers.toString());
            jobParams.put("forced.fail.count.read", forcedFailCountRead.toString());
            jobParams.put("forced.fail.count.write", forcedFailCountWrite.toString());
            jobParams.put("forced.fail.count.process", forcedFailCountProcess.toString());
            jobParams.put("dummy.delay.seconds", dummyDelay.toString());
            jobParams.put("rollback", rollback.toString());
            jobParams.put("auto.commit", autoCommit.toString());
            Reporter.log((String)"Locate job XML file: job_chunk_retryskip_rollback.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_retryskip_rollback", jobParams);
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            TransactionTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testGlobalTranNoExceptions() throws Exception {
        String METHOD = "testGlobalTranNoExceptions";
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "0";
        try {
            Integer initInventory = 99;
            Integer forcedFailCount = 0;
            Integer itemCount = 5;
            Integer dummyDelay = Integer.parseInt(System.getProperty("TransactionTests.testGlobalTranNoExceptions.sleep", DEFAULT_SLEEP_TIME));
            Integer expectedInventory = TransactionTests.calculateGlobalTranExpectedInventory(initInventory, forcedFailCount, itemCount);
            Integer expectedCompletedOrders = TransactionTests.calculateExpectedCompleteOrders(initInventory, forcedFailCount, itemCount);
            Properties jobParams = new Properties();
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Reporter.log((String)"jakarta.transaction.global.timeout=300<p>");
            Reporter.log((String)("commit.interval=" + itemCount.toString() + "<p>"));
            Reporter.log((String)("init.inventory.quantity=" + initInventory.toString() + "<p>"));
            Reporter.log((String)("forced.fail.count=" + forcedFailCount.toString() + "<p>"));
            Reporter.log((String)("dummy.delay.seconds=" + dummyDelay.toString() + "<p>"));
            Reporter.log((String)("expected.inventory=" + expectedInventory.toString() + "<p>"));
            jobParams.put("jakarta.transaction.global.timeout", "300");
            jobParams.put("commit.interval", itemCount.toString());
            jobParams.put("init.inventory.quantity", initInventory.toString());
            jobParams.put("forced.fail.count", forcedFailCount.toString());
            jobParams.put("dummy.delay.seconds", dummyDelay.toString());
            jobParams.put("expected.inventory", expectedInventory.toString());
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_globaltran", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(jobExec.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            AssertionUtils.assertObjEquals("Inventory=" + expectedInventory + " InitialCheckpoint=null OrderCount=" + expectedCompletedOrders, jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            TransactionTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testGlobalTranForcedExceptionWithRollback() throws Exception {
        String METHOD = "testGlobalTranForcedExceptionWithRollback";
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "0";
        try {
            Integer initInventory = 99;
            Integer forcedFailCount = 20;
            Integer itemCount = 9;
            Integer dummyDelay = Integer.parseInt(System.getProperty("TransactionTests.testGlobalTranForcedExceptionWithRollback.sleep", DEFAULT_SLEEP_TIME));
            Integer expectedInventory = TransactionTests.calculateGlobalTranExpectedInventory(initInventory, forcedFailCount, itemCount);
            Integer expectedCompletedOrders = TransactionTests.calculateExpectedCompleteOrders(initInventory, forcedFailCount, itemCount);
            Properties jobParams = new Properties();
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Reporter.log((String)"jakarta.transaction.global.timeout=300<p>");
            Reporter.log((String)("commit.interval=" + itemCount.toString() + "<p>"));
            Reporter.log((String)("init.inventory.quantity=" + initInventory.toString() + "<p>"));
            Reporter.log((String)("forced.fail.count=" + forcedFailCount.toString() + "<p>"));
            Reporter.log((String)("dummy.delay.seconds=" + dummyDelay.toString() + "<p>"));
            Reporter.log((String)("expected.inventory=" + expectedInventory.toString() + "<p>"));
            jobParams.put("jakarta.transaction.global.timeout", "300");
            jobParams.put("commit.interval", itemCount.toString());
            jobParams.put("init.inventory.quantity", initInventory.toString());
            jobParams.put("forced.fail.count", forcedFailCount.toString());
            jobParams.put("dummy.delay.seconds", dummyDelay.toString());
            jobParams.put("expected.inventory", expectedInventory.toString());
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_globaltran", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(jobExec.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            AssertionUtils.assertObjEquals("Inventory=" + expectedInventory + " InitialCheckpoint=null OrderCount=" + expectedCompletedOrders, jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            TransactionTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testGlobalTranForcedExceptionCheckpointRestart() throws Exception {
        String METHOD = "testGlobalTranForcedExceptionCheckpointRestart";
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "0";
        try {
            Integer initInventory = 99;
            Integer forcedFailCount = 20;
            Integer itemCount = 9;
            Integer dummyDelay = Integer.parseInt(System.getProperty("TransactionTests.testGlobalTranForcedExceptionCheckpointRestart.sleep", DEFAULT_SLEEP_TIME));
            Integer expectedInventory = TransactionTests.calculateGlobalTranExpectedInventory(initInventory, forcedFailCount, itemCount);
            Integer expectedCompletedOrders = TransactionTests.calculateExpectedCompleteOrders(initInventory, forcedFailCount, itemCount);
            Properties jobParams = new Properties();
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Reporter.log((String)"jakarta.transaction.global.timeout=300<p>");
            Reporter.log((String)("commit.interval=" + itemCount.toString() + "<p>"));
            Reporter.log((String)("init.inventory.quantity=" + initInventory.toString() + "<p>"));
            Reporter.log((String)("forced.fail.count=" + forcedFailCount.toString() + "<p>"));
            Reporter.log((String)("dummy.delay.seconds=" + dummyDelay.toString() + "<p>"));
            Reporter.log((String)("expected.inventory=" + expectedInventory.toString() + "<p>"));
            jobParams.put("jakarta.transaction.global.timeout", "300");
            jobParams.put("commit.interval", itemCount.toString());
            jobParams.put("init.inventory.quantity", initInventory.toString());
            jobParams.put("forced.fail.count", forcedFailCount.toString());
            jobParams.put("dummy.delay.seconds", dummyDelay.toString());
            jobParams.put("expected.inventory", expectedInventory.toString());
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_globaltran", jobParams);
            long jobInstanceId = jobExec.getInstanceId();
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(jobExec.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("Inventory=" + expectedInventory + " InitialCheckpoint=null OrderCount=" + expectedCompletedOrders, jobExec.getExitStatus());
            forcedFailCount = 0;
            jobParams.put("forced.fail.count", forcedFailCount.toString());
            expectedInventory = TransactionTests.calculateGlobalTranExpectedInventory(expectedInventory, forcedFailCount, itemCount);
            Integer expectedCompletedOrders2 = TransactionTests.calculateExpectedCompleteOrders(initInventory, forcedFailCount, itemCount);
            Reporter.log((String)("Invoke restartJobAndWaitForResult with id: " + jobInstanceId + "<p>"));
            TCKJobExecutionWrapper restartedJobExec = jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), jobParams);
            Reporter.log((String)("restarted job JobExecution getBatchStatus()=" + String.valueOf(restartedJobExec.getBatchStatus()) + "<p>"));
            Reporter.log((String)("restarted job JobExecution getExitStatus()=" + restartedJobExec.getExitStatus() + "<p>"));
            AssertionUtils.assertObjEquals("Inventory=" + expectedInventory + " InitialCheckpoint=" + expectedCompletedOrders + " OrderCount=" + expectedCompletedOrders2, restartedJobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, restartedJobExec.getBatchStatus());
        }
        catch (Exception e) {
            TransactionTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testGlobalTranNoDelayLongTimeout() throws Exception {
        String METHOD = "testGlobalTranNoDelayLongTimeout";
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "0";
        try {
            Integer initInventory = 99;
            Integer forcedFailCount = 0;
            Integer itemCount = 9;
            Integer dummyDelay = Integer.parseInt(System.getProperty("TransactionTests.testGlobalTranNoDelayLongTimeout.sleep", DEFAULT_SLEEP_TIME));
            Integer expectedInventory = TransactionTests.calculateGlobalTranExpectedInventory(initInventory, forcedFailCount, itemCount);
            Integer expectedCompletedOrders = TransactionTests.calculateExpectedCompleteOrders(initInventory, forcedFailCount, itemCount);
            Properties jobParams = new Properties();
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Reporter.log((String)("commit.interval=" + itemCount.toString() + "<p>"));
            Reporter.log((String)("init.inventory.quantity=" + initInventory.toString() + "<p>"));
            Reporter.log((String)("forced.fail.count=" + forcedFailCount.toString() + "<p>"));
            Reporter.log((String)("dummy.delay.seconds=" + dummyDelay.toString() + "<p>"));
            Reporter.log((String)("expected.inventory=" + expectedInventory.toString() + "<p>"));
            jobParams.put("commit.interval", itemCount.toString());
            jobParams.put("init.inventory.quantity", initInventory.toString());
            jobParams.put("forced.fail.count", forcedFailCount.toString());
            jobParams.put("dummy.delay.seconds", dummyDelay.toString());
            jobParams.put("expected.inventory", expectedInventory.toString());
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_globaltran_default", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(jobExec.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            AssertionUtils.assertObjEquals("Inventory=" + expectedInventory + " InitialCheckpoint=null OrderCount=" + expectedCompletedOrders, jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            TransactionTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testGlobalTranLongDelayMixOfLongTimeoutStepsAndShortTimeoutSteps() throws Exception {
        String METHOD = "testGlobalTranLongDelayMixOfLongTimeoutStepsAndShortTimeoutSteps";
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "10000";
        try {
            Integer initInventory = 99;
            Integer forcedFailCount = 15;
            Integer itemCount = 9;
            Integer dummyDelay = Integer.parseInt(System.getProperty("TransactionTests.testGlobalTranLongDelayMixOfLongTimeoutStepsAndShortTimeoutSteps.sleep", DEFAULT_SLEEP_TIME));
            Properties jobParams = new Properties();
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Reporter.log((String)("commit.interval=" + itemCount.toString() + "<p>"));
            Reporter.log((String)("init.inventory.quantity=" + initInventory.toString() + "<p>"));
            Reporter.log((String)("forced.fail.count=" + forcedFailCount.toString() + "<p>"));
            Reporter.log((String)("dummy.delay.seconds=" + dummyDelay.toString() + "<p>"));
            jobParams.put("commit.interval", itemCount.toString());
            jobParams.put("init.inventory.quantity", initInventory.toString());
            jobParams.put("forced.fail.count", forcedFailCount.toString());
            jobParams.put("dummy.delay.seconds", dummyDelay.toString());
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_globaltran_multiple_steps", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(jobExec.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("Inventory=0 InitialCheckpoint=null OrderCount=" + initInventory, jobExec.getExitStatus());
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(jobExec.getExecutionId());
            boolean seen2 = false;
            boolean seen3 = false;
            for (StepExecution s : stepExecutions) {
                if (s.getStepName().equals("step2")) {
                    AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, s.getBatchStatus());
                    seen2 = true;
                    continue;
                }
                if (!s.getStepName().equals("step3")) continue;
                AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, s.getBatchStatus());
                seen3 = true;
            }
            AssertionUtils.assertWithMessage("Step2 execution seen", true, seen2);
            AssertionUtils.assertWithMessage("Step3 execution seen", true, seen3);
        }
        catch (Exception e) {
            TransactionTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testGlobalTranLongDelayMixOfLongTimeoutStepsAndShortTimeoutStepsCustomCheckpointAlgorithm() throws Exception {
        String METHOD = "testGlobalTranLongDelayMixOfLongTimeoutStepsAndShortTimeoutStepsCustomCheckpointAlgorithm";
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "10000";
        try {
            Integer initInventory = 99;
            Integer forcedFailCount = 15;
            Integer itemCount = 9;
            Integer dummyDelay = Integer.parseInt(System.getProperty("TransactionTests.testGlobalTranLongDelayMixOfLongTimeoutStepsAndShortTimeoutStepsCustomCheckpointAlgorithm.sleep", DEFAULT_SLEEP_TIME));
            Properties jobParams = new Properties();
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Reporter.log((String)("commit.interval=" + itemCount.toString() + "<p>"));
            Reporter.log((String)("init.inventory.quantity=" + initInventory.toString() + "<p>"));
            Reporter.log((String)("forced.fail.count=" + forcedFailCount.toString() + "<p>"));
            Reporter.log((String)("dummy.delay.seconds=" + dummyDelay.toString() + "<p>"));
            jobParams.put("commit.interval", itemCount.toString());
            jobParams.put("init.inventory.quantity", initInventory.toString());
            jobParams.put("forced.fail.count", forcedFailCount.toString());
            jobParams.put("dummy.delay.seconds", dummyDelay.toString());
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_globaltran_multiple_steps-customCA", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + String.valueOf(jobExec.getBatchStatus()) + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("Inventory=0 InitialCheckpoint=null OrderCount=" + initInventory, jobExec.getExitStatus());
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(jobExec.getExecutionId());
            boolean seen2 = false;
            boolean seen3 = false;
            for (StepExecution s : stepExecutions) {
                if (s.getStepName().equals("step2")) {
                    AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, s.getBatchStatus());
                    seen2 = true;
                    continue;
                }
                if (!s.getStepName().equals("step3")) continue;
                AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, s.getBatchStatus());
                seen3 = true;
            }
            AssertionUtils.assertWithMessage("Step2 execution seen", true, seen2);
            AssertionUtils.assertWithMessage("Step3 execution seen", true, seen3);
        }
        catch (Exception e) {
            TransactionTests.handleException(METHOD, e);
        }
    }

    private static int calculateGlobalTranExpectedInventory(int initInventory, int forcedFailCount, int commitInterval) {
        int expectedResult = forcedFailCount <= 0 ? 0 : initInventory - forcedFailCount + forcedFailCount % commitInterval;
        return expectedResult;
    }

    private static int calculateExpectedCompleteOrders(int initInventory, int forcedFailCount, int commitInterval) {
        int expectedResult = forcedFailCount <= 0 ? initInventory : forcedFailCount / commitInterval * commitInterval;
        return expectedResult;
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }
}

