/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration;

import java.util.Set;
import javax.validation.Configuration;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.ConfigurationDefinedMessageInterpolator;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.CreditCard;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.Optional;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.User;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.XmlDefinedMessageInterpolator;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class MessageInterpolatorSpecifiedInValidationXmlTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)MessageInterpolatorSpecifiedInValidationXmlTest.webArchiveBuilder().withTestClass(MessageInterpolatorSpecifiedInValidationXmlTest.class)).withClasses(User.class, Optional.class, CreditCard.class, ConfigurationDefinedMessageInterpolator.class, XmlDefinedMessageInterpolator.class)).withValidationXml("validation-MessageInterpolatorSpecifiedInValidationXmlTest.xml")).build();
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="f")
    public void testMessageInterpolatorSpecifiedInValidationXml() {
        Validator validator = TestUtil.getValidatorUnderTest();
        User user = new User();
        Set constraintViolations = validator.validate((Object)user, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 1);
        ConstraintViolationAssert.assertCorrectConstraintViolationMessages(constraintViolations, "Interpolator defined in xml was used.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="d"), @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="f")})
    public void testMessageInterpolatorSpecifiedInValidationXmlCanBeOverridden() {
        Configuration configuration = Validation.byDefaultProvider().configure();
        configuration = configuration.messageInterpolator((MessageInterpolator)new ConfigurationDefinedMessageInterpolator());
        Validator validator = configuration.buildValidatorFactory().getValidator();
        User user = new User();
        Set constraintViolations = validator.validate((Object)user, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 1);
        ConstraintViolationAssert.assertCorrectConstraintViolationMessages(constraintViolations, "Interpolator defined in Configuration was used.");
    }
}

