/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RunModeUtils {
    private static Logger log = Logger.getLogger(RunModeUtils.class.getName());

    private RunModeUtils() {
    }

    public static boolean isRunAsClient(Deployment deployment, Class<?> testClass, Method testMethod) {
        boolean runMethodAsClient = testMethod.isAnnotationPresent(RunAsClient.class);
        boolean runClassAsClient = testClass.isAnnotationPresent(RunAsClient.class);
        boolean runAsClient = true;
        if (deployment != null) {
            runAsClient = !deployment.getDescription().testable();
            boolean bl = runAsClient = deployment.isDeployed() ? runAsClient : true;
            if (runMethodAsClient) {
                runAsClient = true;
            } else if (runClassAsClient) {
                runAsClient = true;
            }
        } else if (!runMethodAsClient && !runClassAsClient) {
            log.warning("The test method \"" + testClass.getCanonicalName() + " " + testMethod.getName() + "\" will run on the client side - there is no running deployment yet. Please use the " + "annotation @RunAsClient");
        }
        return runAsClient;
    }

    public static boolean isLocalContainer(Container container) {
        if (container == null || container.getDeployableContainer() == null || container.getDeployableContainer().getDefaultProtocol() == null) {
            return false;
        }
        return "Local".equals(container.getDeployableContainer().getDefaultProtocol().getName());
    }
}

