/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.bootstrap;

import jakarta.validation.BootstrapConfiguration;
import jakarta.validation.executable.ExecutableType;
import java.util.EnumSet;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class BootstrapConfigurationWithoutValidationXmlTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)BootstrapConfigurationWithoutValidationXmlTest.webArchiveBuilder().withTestClass(BootstrapConfigurationWithoutValidationXmlTest.class)).build();
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-configuration", id="f")
    public void testGetBootstrapConfigurationNoValidationXml() {
        BootstrapConfiguration bootstrapConfiguration = TestUtil.getConfigurationUnderTest().getBootstrapConfiguration();
        Assert.assertNotNull((Object)bootstrapConfiguration);
        Assert.assertNotNull((Object)bootstrapConfiguration.getConstraintMappingResourcePaths());
        Assert.assertTrue((boolean)bootstrapConfiguration.getConstraintMappingResourcePaths().isEmpty());
        Assert.assertNull((Object)bootstrapConfiguration.getConstraintValidatorFactoryClassName());
        Assert.assertNull((Object)bootstrapConfiguration.getDefaultProviderClassName());
        Assert.assertNull((Object)bootstrapConfiguration.getMessageInterpolatorClassName());
        Assert.assertNull((Object)bootstrapConfiguration.getParameterNameProviderClassName());
        Assert.assertNotNull((Object)bootstrapConfiguration.getDefaultValidatedExecutableTypes());
        Assert.assertEquals((Set)bootstrapConfiguration.getDefaultValidatedExecutableTypes(), EnumSet.of(ExecutableType.CONSTRUCTORS, ExecutableType.NON_GETTER_METHODS));
        Assert.assertNotNull((Object)bootstrapConfiguration.getProperties());
        Assert.assertTrue((boolean)bootstrapConfiguration.getProperties().isEmpty());
        Assert.assertNull((Object)bootstrapConfiguration.getTraversableResolverClassName());
    }
}

