/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution;

import jakarta.validation.ConstraintDefinitionException;
import jakarta.validation.ConstraintTarget;
import jakarta.validation.UnexpectedTypeException;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Size;
import jakarta.validation.valueextraction.UnwrapByDefault;
import jakarta.validation.valueextraction.Unwrapping;
import jakarta.validation.valueextraction.ValueExtractor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.Bar;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.BaseClass;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.ConstraintWithTwoValidatorsForTheSameType;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.Coordinate;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.CrossParameterConstraintWithObjectArrayValidator;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.CrossParameterConstraintWithObjectValidator;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.CrossParameterConstraintWithSeveralValidators;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.CrossParameterConstraintWithoutValidator;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.CustomConstraint;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.Foo;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.GenericAndCrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.MinMax;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.SerializableBarSubclass;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.SubClassA;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.SubClassB;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.SubClassC;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.SubClassD;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.SubClassE;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.SubClassF;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.SubClassG;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.SubClassH;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.SubClassI;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.Suburb;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.ValidInteger;
import org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution.ValidLong;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ValidatorResolutionTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ValidatorResolutionTest.webArchiveBuilder().withTestClassPackage(ValidatorResolutionTest.class)).build();
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="b")
    public void testTargetTypeIsInterface() {
        Assert.assertEquals((int)CustomConstraint.ValidatorForCustomInterface.callCounter, (int)0, (String)"The validate method of ValidatorForCustomInterface should not have been called yet.");
        this.getValidator().validate((Object)new CustomInterfaceImpl(), new Class[0]);
        Assert.assertTrue((CustomConstraint.ValidatorForCustomInterface.callCounter > 0 ? 1 : 0) != 0, (String)"The validate method of ValidatorForCustomInterface should have been called.");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="b")
    public void testTargetTypeIsClass() {
        Assert.assertEquals((int)CustomConstraint.ValidatorForCustomClass.callCounter, (int)0, (String)"The validate method of ValidatorForCustomClass should not have been called yet.");
        this.getValidator().validate((Object)new CustomClass(), new Class[0]);
        Assert.assertTrue((CustomConstraint.ValidatorForCustomClass.callCounter > 0 ? 1 : 0) != 0, (String)"The validate method of ValidatorForCustomClass should have been called.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="m")})
    public void testTargetedTypeIsField() {
        Assert.assertEquals((int)CustomConstraint.ValidatorForSubClassA.callCounter, (int)0, (String)"The validate method of ValidatorForSubClassA should not have been called yet.");
        this.getValidator().validate((Object)new SubClassAHolder(new SubClassA()), new Class[0]);
        Assert.assertTrue((CustomConstraint.ValidatorForSubClassA.callCounter > 0 ? 1 : 0) != 0, (String)"The validate method of ValidatorForSubClassA should have been called.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="d"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="m")})
    public void testTargetedTypeIsGetter() {
        Assert.assertEquals((int)CustomConstraint.ValidatorForSubClassB.callCounter, (int)0, (String)"The validate method of ValidatorForSubClassB should not have been called yet.");
        this.getValidator().validate((Object)new SubClassBHolder(new SubClassB()), new Class[0]);
        Assert.assertTrue((CustomConstraint.ValidatorForSubClassB.callCounter > 0 ? 1 : 0) != 0, (String)"The validate method of ValidatorForSubClassB should have been called.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="d"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="m")})
    public void testTargetedTypeIsConstructor() throws NoSuchMethodException, SecurityException {
        Assert.assertEquals((int)CustomConstraint.ValidatorForSubClassC.callCounter, (int)0, (String)"The validate method of ValidatorForSubClassC should not have been called yet.");
        this.getExecutableValidator().validateConstructorReturnValue(SubClassC.class.getConstructor(new Class[0]), (Object)new SubClassC(), new Class[0]);
        Assert.assertTrue((CustomConstraint.ValidatorForSubClassC.callCounter > 0 ? 1 : 0) != 0, (String)"The validate method of ValidatorForSubClassC should have been called.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="d"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="m")})
    public void testTargetedTypeIsMethod() throws NoSuchMethodException, SecurityException {
        Assert.assertEquals((int)CustomConstraint.ValidatorForSubClassD.callCounter, (int)0, (String)"The validate method of ValidatorForSubClassD should not have been called yet.");
        this.getExecutableValidator().validateReturnValue((Object)new SubClassDService(), SubClassDService.class.getMethod("retrieveSubClassD", new Class[0]), (Object)new SubClassD(), new Class[0]);
        Assert.assertTrue((CustomConstraint.ValidatorForSubClassD.callCounter > 0 ? 1 : 0) != 0, (String)"The validate method of ValidatorForSubClassD should have been called.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="e"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="m")})
    public void testTargetedTypeIsMethodParameter() throws NoSuchMethodException, SecurityException {
        Assert.assertEquals((int)CustomConstraint.ValidatorForSubClassE.callCounter, (int)0, (String)"The validate method of ValidatorForSubClassE should not have been called yet.");
        this.getExecutableValidator().validateParameters((Object)new SubClassEService(), SubClassEService.class.getMethod("retrieveSubClassE", SubClassE.class), new Object[]{new SubClassE()}, new Class[0]);
        Assert.assertTrue((CustomConstraint.ValidatorForSubClassE.callCounter > 0 ? 1 : 0) != 0, (String)"The validate method of ValidatorForSubClassE should have been called.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="e"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="m")})
    public void testTargetedTypeIsConstructorParameter() throws NoSuchMethodException, SecurityException {
        Assert.assertEquals((int)CustomConstraint.ValidatorForSubClassF.callCounter, (int)0, (String)"The validate method of ValidatorForSubClassF should not have been called yet.");
        this.getExecutableValidator().validateConstructorParameters(SubClassFService.class.getConstructor(SubClassF.class), new Object[]{new SubClassF()}, new Class[0]);
        Assert.assertTrue((CustomConstraint.ValidatorForSubClassF.callCounter > 0 ? 1 : 0) != 0, (String)"The validate method of ValidatorForSubClassF should have been called.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="f"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="m")})
    public void testTargetedTypeIsTypeArgument() {
        Assert.assertEquals((int)CustomConstraint.ValidatorForSubClassG.callCounter, (int)0, (String)"The validate method of ValidatorForSubClassG should not have been called yet.");
        this.getValidator().validate((Object)new SubClassGHolder(), new Class[0]);
        Assert.assertTrue((CustomConstraint.ValidatorForSubClassG.callCounter > 0 ? 1 : 0) != 0, (String)"The validate method of ValidatorForSubClassG should have been called.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="g"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="m")})
    public void testTargetedTypeIsTypeArgumentForNonGenericContainerInheritingFromGenericTypeWithValueExtractor() {
        Assert.assertEquals((int)CustomConstraint.ValidatorForSubClassH.callCounter, (int)0, (String)"The validate method of ValidatorForSubClassH should not have been called yet.");
        this.getValidator().validate((Object)new SubClassHHolder(), new Class[0]);
        Assert.assertTrue((CustomConstraint.ValidatorForSubClassH.callCounter > 0 ? 1 : 0) != 0, (String)"The validate method of ValidatorForSubClassH should have been called.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="h"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="m")})
    public void testTargetedTypeIsTypeArgumentForNonGenericContainerWithValueExtractorWithExtractedType() {
        Assert.assertEquals((int)CustomConstraint.ValidatorForSubClassI.callCounter, (int)0, (String)"The validate method of ValidatorForSubClassI should not have been called yet.");
        TestUtil.getConfigurationUnderTest().addValueExtractor((ValueExtractor)new SubClassIContainerValueExtractor()).buildValidatorFactory().getValidator().validate((Object)new SubClassIHolder(), new Class[0]);
        Assert.assertTrue((CustomConstraint.ValidatorForSubClassI.callCounter > 0 ? 1 : 0) != 0, (String)"The validate method of ValidatorForSubClassI should have been called.");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="m")
    public void testClassLevelValidatorForSubTypeHasPredenceOverValidatorForSuperClass() {
        Assert.assertEquals((int)CustomConstraint.ValidatorForAnotherSubClass.callCounter, (int)0, (String)"The validate method of ValidatorForAnotherSubClass should not have been called yet.");
        this.getValidator().validate((Object)new AnotherSubClass(), new Class[0]);
        Assert.assertTrue((CustomConstraint.ValidatorForAnotherSubClass.callCounter > 0 ? 1 : 0) != 0, (String)"The validate method of ValidatorForAnotherSubClass should have been called.");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="i")
    public void testResolutionOfMultipleSizeValidators() {
        Suburb suburb = new Suburb();
        Set constraintViolations = this.getValidator().validate((Object)suburb, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        suburb.setName("");
        constraintViolations = this.getValidator().validate((Object)suburb, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("name").withInvalidValue("").withRootBeanClass(Suburb.class));
        suburb.setName("Hoegsbo");
        constraintViolations = this.getValidator().validate((Object)suburb, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        suburb.addFacility(Suburb.Facility.SHOPPING_MALL, false);
        constraintViolations = this.getValidator().validate((Object)suburb, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("facilities").withInvalidValue(suburb.getFacilities()).withRootBeanClass(Suburb.class));
        suburb.addFacility(Suburb.Facility.BUS_TERMINAL, true);
        constraintViolations = this.getValidator().validate((Object)suburb, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        suburb.addStreetName("Sikelsgatan");
        constraintViolations = this.getValidator().validate((Object)suburb, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("streetNames").withInvalidValue(suburb.getStreetNames()).withRootBeanClass(Suburb.class));
        suburb.addStreetName("Marklandsgatan");
        constraintViolations = this.getValidator().validate((Object)suburb, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        Coordinate[] boundingBox = new Coordinate[]{new Coordinate(0L, 0L), new Coordinate(0L, 1L), new Coordinate(1L, 0L)};
        suburb.setBoundingBox(boundingBox);
        constraintViolations = this.getValidator().validate((Object)suburb, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("boundingBox").withInvalidValue(suburb.getBoundingBox()).withRootBeanClass(Suburb.class));
        boundingBox = new Coordinate[]{new Coordinate(0L, 0L), new Coordinate(0L, 1L), new Coordinate(1L, 0L), new Coordinate(1L, 1L)};
        suburb.setBoundingBox(boundingBox);
        constraintViolations = this.getValidator().validate((Object)suburb, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="i")
    public void testResolutionOfMinMaxForDifferentTypes() {
        MinMax minMax = new MinMax("5", 5);
        Set constraintViolations = this.getValidator().validate((Object)minMax, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withProperty("number"), ConstraintViolationAssert.violationOf(Min.class).withProperty("numberAsString"));
    }

    @Test(expectedExceptions={UnexpectedTypeException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="l"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition", id="e"), @SpecAssertion(section="constraintsdefinitionimplementation-validationimplementation", id="m")})
    public void testUnexpectedTypeInValidatorResolution() {
        Bar bar = new Bar();
        this.getValidator().validate((Object)bar, new Class[0]);
    }

    @Test(expectedExceptions={UnexpectedTypeException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="n"), @SpecAssertion(section="exception-constraintdeclaration", id="b")})
    public void testAmbiguousValidatorResolution() {
        Foo foo = new Foo(new SerializableBarSubclass());
        this.getValidator().validate((Object)foo, new Class[0]);
        Assert.fail((String)"The test should have failed due to ambiguous validator resolution.");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="k")
    public void testValidatorForWrapperTypeIsAppliedForPrimitiveType() {
        PrimitiveHolder primitiveHolder = new PrimitiveHolder();
        Set constraintViolations = this.getValidator().validate((Object)primitiveHolder, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidInteger.class), ConstraintViolationAssert.violationOf(ValidLong.class));
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="a")
    public void testSeveralCrossParameterValidatorsCauseConstraintDefinitionException() throws Exception {
        CalendarService object = new CalendarService();
        Method method = CalendarService.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="a")
    public void testCrossParameterConstraintWithoutValidatorCausesConstraintDefinitionException() throws Exception {
        OnlineCalendarService object = new OnlineCalendarService();
        Method method = OnlineCalendarService.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="a")
    public void testCrossParameterValidatorIsUsedForConstraintImplicitlyTargetingParameters() throws Exception {
        OfflineCalendarService object = new OfflineCalendarService();
        Method method = OfflineCalendarService.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        Set constraintViolations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(GenericAndCrossParameterConstraint.class).withMessage("violation created by cross-parameter validator"));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="a")
    public void testCrossParameterValidatorIsUsedForConstraintExplicitlyTargetingParameters() throws Exception {
        AdvancedCalendarService object = new AdvancedCalendarService();
        Method method = AdvancedCalendarService.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(GenericAndCrossParameterConstraint.class).withMessage("violation created by cross-parameter validator"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-validationimplementation", id="g"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="a")})
    public void testCrossParameterValidatorValidatingObjectArray() throws Exception {
        YetAnotherCalendarService object = new YetAnotherCalendarService();
        Method method = YetAnotherCalendarService.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(CrossParameterConstraintWithObjectArrayValidator.class).withMessage("violation created by validator for Object[]"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-validationimplementation", id="g"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="a")})
    public void testCrossParameterValidatorValidatingObject() throws Exception {
        EvenYetAnotherCalendarService object = new EvenYetAnotherCalendarService();
        Method method = EvenYetAnotherCalendarService.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(CrossParameterConstraintWithObjectValidator.class).withMessage("violation created by validator for Object"));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="j")
    public void testGenericValidatorIsUsedForConstraintTargetingMethodReturnValue() throws Exception {
        AnotherCalendarService object = new AnotherCalendarService();
        Method method = AnotherCalendarService.class.getMethod("createEvent", Date.class, Date.class);
        Object returnValue = null;
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(GenericAndCrossParameterConstraint.class).withMessage("violation created by generic validator"));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="j")
    public void testGenericValidatorIsUsedForConstraintTargetingField() {
        Set violations = this.getValidator().validate((Object)new TestBean(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(GenericAndCrossParameterConstraint.class).withMessage("violation created by generic validator"));
    }

    @Test(expectedExceptions={UnexpectedTypeException.class})
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-typevalidatorresolution", id="n")
    public void testTwoValidatorsForSameTypeCauseUnexpectedTypeException() {
        this.getValidator().validate((Object)new AnotherBean(), new Class[0]);
    }

    @ConstraintWithTwoValidatorsForTheSameType
    private static class AnotherBean {
        private AnotherBean() {
        }
    }

    private static class TestBean {
        @GenericAndCrossParameterConstraint
        public String foo;

        private TestBean() {
        }
    }

    private static class EvenYetAnotherCalendarService {
        private EvenYetAnotherCalendarService() {
        }

        @CrossParameterConstraintWithObjectValidator
        public void createEvent(Date startDate, Date endDate) {
        }
    }

    private static class YetAnotherCalendarService {
        private YetAnotherCalendarService() {
        }

        @CrossParameterConstraintWithObjectArrayValidator
        public void createEvent(Date startDate, Date endDate) {
        }
    }

    private static class AnotherCalendarService {
        private AnotherCalendarService() {
        }

        @GenericAndCrossParameterConstraint(validationAppliesTo=ConstraintTarget.RETURN_VALUE)
        public Object createEvent(Date startDate, Date endDate) {
            return null;
        }
    }

    private static class AdvancedCalendarService {
        private AdvancedCalendarService() {
        }

        @GenericAndCrossParameterConstraint(validationAppliesTo=ConstraintTarget.PARAMETERS)
        public Object createEvent(Date startDate, Date endDate) {
            return null;
        }
    }

    private static class OfflineCalendarService {
        private OfflineCalendarService() {
        }

        @GenericAndCrossParameterConstraint
        public void createEvent(Date startDate, Date endDate) {
        }
    }

    private static class OnlineCalendarService {
        private OnlineCalendarService() {
        }

        @CrossParameterConstraintWithoutValidator(validationAppliesTo=ConstraintTarget.PARAMETERS)
        public void createEvent(Date startDate, Date endDate) {
        }
    }

    private static class CalendarService {
        private CalendarService() {
        }

        @CrossParameterConstraintWithSeveralValidators
        public void createEvent(Date startDate, Date endDate) {
        }
    }

    private static class PrimitiveHolder {
        @ValidInteger
        private int intValue;
        @ValidLong
        private long longValue;

        private PrimitiveHolder() {
        }
    }

    @CustomConstraint
    static class AnotherSubClass
    extends AnotherBaseClass {
        AnotherSubClass() {
        }
    }

    static class AnotherBaseClass {
        AnotherBaseClass() {
        }
    }

    private static class CustomInterfaceImpl
    implements CustomInterface {
        private CustomInterfaceImpl() {
        }
    }

    @CustomConstraint
    static interface CustomInterface {
    }

    @CustomConstraint
    static class CustomClass {
        CustomClass() {
        }
    }

    private static class SubClassIHolder {
        @CustomConstraint
        private SubClassIContainer property = new SubClassIContainer();

        private SubClassIHolder() {
        }
    }

    @UnwrapByDefault
    private static class SubClassIContainerValueExtractor
    implements ValueExtractor<SubClassIContainer> {
        private SubClassIContainerValueExtractor() {
        }

        public void extractValues(SubClassIContainer originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value(null, (Object)originalValue.getValue());
        }
    }

    private static class SubClassIContainer {
        private SubClassI value = new SubClassI();

        private SubClassIContainer() {
        }

        private SubClassI getValue() {
            return this.value;
        }
    }

    private static class SubClassHHolder {
        @CustomConstraint(payload={Unwrapping.Unwrap.class})
        private SubClassHContainer property = new SubClassHContainer();

        private SubClassHHolder() {
        }
    }

    private static class SubClassHContainer
    extends ArrayList<SubClassH> {
        private SubClassHContainer() {
            this.add(new SubClassH());
        }
    }

    private static class SubClassGHolder {
        private Optional<@CustomConstraint SubClassG> property = Optional.of(new SubClassG());

        private SubClassGHolder() {
        }
    }

    private static class SubClassFService {
        public SubClassFService(@CustomConstraint SubClassF parameter) {
        }
    }

    private static class SubClassEService {
        private SubClassEService() {
        }

        public void retrieveSubClassE(@CustomConstraint SubClassE parameter) {
        }
    }

    private static class SubClassDService {
        private SubClassDService() {
        }

        @CustomConstraint
        public SubClassD retrieveSubClassD() {
            return null;
        }
    }

    private static class SubClassBHolder {
        private final BaseClass baseClass;

        public SubClassBHolder(SubClassB subClass) {
            this.baseClass = subClass;
        }

        @CustomConstraint
        public SubClassB getBaseClass() {
            return (SubClassB)this.baseClass;
        }
    }

    private static class SubClassAHolder {
        @CustomConstraint
        private final SubClassA subClass;

        SubClassAHolder(SubClassA subClass) {
            this.subClass = subClass;
        }
    }
}

