/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.condition;

import org.assertj.core.api.Condition;
import org.assertj.core.condition.Join;

public class AllOf<T>
extends Join<T> {
    @SafeVarargs
    public static <T> Condition<T> allOf(Condition<? super T> ... conditions) {
        return new AllOf<T>(conditions);
    }

    public static <T> Condition<T> allOf(Iterable<? extends Condition<? super T>> conditions) {
        return new AllOf<T>(conditions);
    }

    @SafeVarargs
    private AllOf(Condition<? super T> ... conditions) {
        super(conditions);
    }

    private AllOf(Iterable<? extends Condition<? super T>> conditions) {
        super(conditions);
    }

    @Override
    public boolean matches(T value) {
        for (Condition condition : this.conditions) {
            if (condition.matches(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return String.format("all of:<%s>", this.conditions);
    }
}

