/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.valueextraction.builtin;

import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class MapValueExtractorTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)MapValueExtractorTest.webArchiveBuilder().withTestClass(MapValueExtractorTest.class)).build();
    }

    @Test
    @SpecAssertion(section="valueextractordefinition-builtinvalueextractors", id="c")
    public void mapValueExtractor() {
        Validator validator = this.getValidator();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("valid1", "valid2");
        map.put(null, "valid3");
        map.put("valid4", null);
        Set violations = validator.validate((Object)new MapHolder(map), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("map").containerElement("<map value>", true, "valid4", null, Map.class, 1), ConstraintViolationAssert.pathWith().property("map").containerElement("<map key>", true, null, null, Map.class, 0));
    }

    private static class MapHolder {
        private final Map<@NotNull String, @NotNull String> map;

        private MapHolder(Map<String, String> map) {
            this.map = map;
        }
    }
}

