/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.session;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.cdi.tck.tests.context.session.SimpleSessionBean;
import org.jboss.cdi.tck.util.ActionSequence;

@WebServlet(name="IntrospectServlet", urlPatterns={"/introspect"})
public class IntrospectServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String MODE_INVALIDATE = "invalidate";
    public static final String MODE_VERIFY = "verify";
    public static final String MODE_TIMEOUT = "timeout";
    @Inject
    SimpleSessionBean simpleBean;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/text");
        String mode = req.getParameter("mode");
        if (mode == null) {
            resp.getWriter().append(this.simpleBean.getId());
        } else if (MODE_INVALIDATE.equals(mode)) {
            ActionSequence.reset();
            ActionSequence.addAction(IntrospectServlet.class.getName());
            req.getSession().invalidate();
        } else if (MODE_VERIFY.equals(mode)) {
            resp.setStatus(200);
            resp.setContentType("text/plain");
            resp.getWriter().write(ActionSequence.getSequence().toString());
        } else if (MODE_TIMEOUT.equals(mode)) {
            ActionSequence.reset();
            req.getSession().setMaxInactiveInterval(1);
        } else {
            throw new ServletException("Unknown mode");
        }
    }
}

