/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.metadata.injectionpoint;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.EventMetadata;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Set;
import org.jboss.cdi.tck.tests.event.metadata.injectionpoint.Info;

@RequestScoped
public class InfoObserver {
    private Bean<?> lastBean = null;
    private boolean lastIsTransient = false;
    private Type lastType = null;
    private Set<Annotation> lastQualifiers = null;
    private Member lastMember = null;
    private Annotated lastAnnotated = null;

    public void observeInfo(@Observes @Any Info info, EventMetadata metadata) {
        InjectionPoint injectionPoint = metadata.getInjectionPoint();
        this.lastBean = injectionPoint.getBean();
        this.lastIsTransient = injectionPoint.isTransient();
        this.lastType = injectionPoint.getType();
        this.lastQualifiers = injectionPoint.getQualifiers();
        this.lastMember = injectionPoint.getMember();
        this.lastAnnotated = injectionPoint.getAnnotated();
    }

    public Bean<?> getLastBean() {
        return this.lastBean;
    }

    public boolean isLastIsTransient() {
        return this.lastIsTransient;
    }

    public Type getLastType() {
        return this.lastType;
    }

    public Set<Annotation> getLastQualifiers() {
        return this.lastQualifiers;
    }

    public Member getLastMember() {
        return this.lastMember;
    }

    public Annotated getLastAnnotated() {
        return this.lastAnnotated;
    }

    public void reset() {
        this.lastBean = null;
        this.lastIsTransient = false;
        this.lastType = null;
        this.lastQualifiers = null;
        this.lastMember = null;
        this.lastAnnotated = null;
    }
}

