/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.framework.arquillian.extensions;

import ee.jakarta.tck.concurrent.common.signature.ConcurrencySignatureTestRunner;
import ee.jakarta.tck.concurrent.framework.TestProperty;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.Signature;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;

public class TCKArchiveProcessor
implements ApplicationArchiveProcessor {
    private static final Logger log = Logger.getLogger(TCKArchiveProcessor.class.getCanonicalName());

    public void process(Archive<?> applicationArchive, TestClass testClass) {
        String applicationName = applicationArchive.getName() == null ? applicationArchive.getId() : applicationArchive.getName();
        TCKArchiveProcessor.appendCommonPackages(applicationArchive, testClass, applicationName);
        TCKArchiveProcessor.appendSignaturePackages(applicationArchive, testClass, applicationName);
    }

    private static void appendCommonPackages(Archive<?> applicationArchive, TestClass testClass, String applicationName) {
        if (!testClass.isAnnotationPresent(Common.class)) {
            return;
        }
        List packages = Stream.of(((Common)testClass.getAnnotation(Common.class)).value()).map(pkg -> pkg.getPackageName()).collect(Collectors.toList());
        if (packages.isEmpty()) {
            return;
        }
        if (applicationArchive instanceof EnterpriseArchive) {
            throw new RuntimeException("Cannot append packages to Enterprise Archives since modules are immutable");
        }
        if (applicationArchive instanceof WebArchive || applicationArchive instanceof JavaArchive) {
            log.info("Application Archive [" + applicationName + "] is being appended with packages " + packages);
            packages.stream().forEach(pkg -> ((ClassContainer)applicationArchive).addPackage(pkg));
        }
    }

    private static void appendSignaturePackages(Archive<?> applicationArchive, TestClass testClass, String applicationName) {
        String signatureFileName;
        if (!testClass.isAnnotationPresent(Signature.class)) {
            return;
        }
        String jdkVersion = TestProperty.javaSpecVer.getValue();
        Package signaturePackage = ConcurrencySignatureTestRunner.class.getPackage();
        if (!TCKArchiveProcessor.signatureFileExists(signaturePackage, signatureFileName = "jakarta.enterprise.concurrent.sig_" + jdkVersion)) {
            throw new RuntimeException("No signature file exists for name: " + signatureFileName);
        }
        if (applicationArchive instanceof ClassContainer) {
            log.info("Application Archive [" + applicationName + "] is being appended with packages [" + signaturePackage + "]");
            ((ClassContainer)applicationArchive).addPackage(signaturePackage);
            File sigTestDep = ((MavenFormatStage)((MavenStrategyStage)Maven.resolver().resolve("jakarta.tck:sigtest-maven-plugin:2.3")).withoutTransitivity()).asSingleFile();
            log.info("Application Archive [" + applicationName + "] is being appended with library " + sigTestDep.getName());
            ((LibraryContainer)applicationArchive).addAsLibrary(sigTestDep);
            log.info("Application Archive [" + applicationName + "] is being appended with resources " + Arrays.asList(ConcurrencySignatureTestRunner.SIG_RESOURCES));
            ((ResourceContainer)applicationArchive).addAsResources(signaturePackage, new String[]{"sig-test.map", "sig-test-pkg-list.txt"});
            ((ResourceContainer)applicationArchive).addAsResource(signaturePackage, signatureFileName, signaturePackage.getName().replace(".", "/") + "/jakarta.enterprise.concurrent.sig");
        }
    }

    private static boolean signatureFileExists(Package pkg, String fileName) {
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName((Package)pkg, (String)fileName);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl.getResource(classloaderResourceName) != null;
    }
}

