/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLEngine;
import jdk.incubator.http.AsyncConnection;
import jdk.incubator.http.AsyncSSLDelegate;
import jdk.incubator.http.ConnectionPool;
import jdk.incubator.http.HttpClientImpl;
import jdk.incubator.http.HttpConnection;
import jdk.incubator.http.PlainHttpConnection;
import jdk.incubator.http.internal.common.ByteBufferReference;
import jdk.incubator.http.internal.common.ExceptionallyCloseable;
import jdk.incubator.http.internal.common.Utils;

class AsyncSSLConnection
extends HttpConnection
implements AsyncConnection,
ExceptionallyCloseable {
    final AsyncSSLDelegate sslDelegate;
    final PlainHttpConnection plainConnection;
    final String serverName;

    AsyncSSLConnection(InetSocketAddress inetSocketAddress, HttpClientImpl httpClientImpl, String[] stringArray) {
        super(inetSocketAddress, httpClientImpl);
        this.plainConnection = new PlainHttpConnection(inetSocketAddress, httpClientImpl);
        this.serverName = Utils.getServerName(inetSocketAddress);
        this.sslDelegate = new AsyncSSLDelegate(this.plainConnection, httpClientImpl, stringArray, this.serverName);
    }

    @Override
    synchronized void configureMode(HttpConnection.Mode mode) throws IOException {
        super.configureMode(mode);
        this.plainConnection.configureMode(mode);
    }

    private CompletableFuture<Void> configureModeAsync(Void void_) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        try {
            this.configureMode(HttpConnection.Mode.ASYNC);
            completableFuture.complete(null);
        }
        catch (Throwable throwable) {
            completableFuture.completeExceptionally(throwable);
        }
        return completableFuture;
    }

    @Override
    public void connect() throws IOException, InterruptedException {
        this.plainConnection.connect();
        this.configureMode(HttpConnection.Mode.ASYNC);
        this.startReading();
        this.sslDelegate.connect();
    }

    @Override
    public CompletableFuture<Void> connectAsync() {
        throw new InternalError();
    }

    @Override
    boolean connected() {
        return this.plainConnection.connected() && this.sslDelegate.connected();
    }

    @Override
    boolean isSecure() {
        return true;
    }

    @Override
    boolean isProxied() {
        return false;
    }

    @Override
    SocketChannel channel() {
        return this.plainConnection.channel();
    }

    @Override
    public void enableCallback() {
        this.sslDelegate.enableCallback();
    }

    @Override
    ConnectionPool.CacheKey cacheKey() {
        return ConnectionPool.cacheKey(this.address, null);
    }

    @Override
    long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        ByteBuffer[] byteBufferArray2 = Utils.reduce(byteBufferArray, n, n2);
        long l = Utils.remaining(byteBufferArray2);
        this.sslDelegate.writeAsync(ByteBufferReference.toReferences(byteBufferArray2));
        this.sslDelegate.flushAsync();
        return l;
    }

    @Override
    long write(ByteBuffer byteBuffer) throws IOException {
        long l = byteBuffer.remaining();
        this.sslDelegate.writeAsync(ByteBufferReference.toReferences(byteBuffer));
        this.sslDelegate.flushAsync();
        return l;
    }

    @Override
    public void writeAsyncUnordered(ByteBufferReference[] byteBufferReferenceArray) throws IOException {
        assert (this.getMode() == HttpConnection.Mode.ASYNC);
        this.sslDelegate.writeAsyncUnordered(byteBufferReferenceArray);
    }

    @Override
    public void writeAsync(ByteBufferReference[] byteBufferReferenceArray) throws IOException {
        assert (this.getMode() == HttpConnection.Mode.ASYNC);
        this.sslDelegate.writeAsync(byteBufferReferenceArray);
    }

    @Override
    public void flushAsync() throws IOException {
        this.sslDelegate.flushAsync();
    }

    @Override
    public void closeExceptionally(Throwable throwable) {
        Utils.close(throwable, this.sslDelegate, this.plainConnection.channel());
    }

    @Override
    public void close() {
        Utils.close(this.sslDelegate, this.plainConnection.channel());
    }

    @Override
    void shutdownInput() throws IOException {
        this.plainConnection.channel().shutdownInput();
    }

    @Override
    void shutdownOutput() throws IOException {
        this.plainConnection.channel().shutdownOutput();
    }

    SSLEngine getEngine() {
        return this.sslDelegate.getEngine();
    }

    @Override
    public void setAsyncCallbacks(Consumer<ByteBufferReference> consumer, Consumer<Throwable> consumer2, Supplier<ByteBufferReference> supplier) {
        this.sslDelegate.setAsyncCallbacks(consumer, consumer2, supplier);
        this.plainConnection.setAsyncCallbacks(this.sslDelegate::asyncReceive, consumer2, this.sslDelegate::getNetBuffer);
    }

    @Override
    protected ByteBuffer readImpl() throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    CompletableFuture<Void> whenReceivingResponse() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void startReading() {
        this.plainConnection.startReading();
        this.sslDelegate.startReading();
    }

    @Override
    public void stopAsyncReading() {
        this.plainConnection.stopAsyncReading();
    }
}

