/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.compositeelresolver;

import com.sun.ts.tests.el.common.api.resolver.ResolverTest;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.SimpleBean;
import jakarta.el.ArrayELResolver;
import jakarta.el.BeanELResolver;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELManager;
import jakarta.el.ELResolver;
import jakarta.el.StandardELContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());
    private static final String[] names = new String[]{"doug", "nick", "roger", "ryan", "ed"};

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void compositeELResolverTest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        try {
            BareBonesELContext compContext = new BareBonesELContext();
            ELContext context = compContext.getELContext();
            CompositeELResolver compResolver = (CompositeELResolver)context.getELResolver();
            pass = ResolverTest.testCompositeELResolver(context, compResolver, buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void compositeELResolverInvokeTest() throws Exception {
        SimpleBean sb = new SimpleBean();
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        try {
            BeanELResolver beanResolver = new BeanELResolver();
            ELManager elm = new ELManager();
            StandardELContext context = elm.getELContext();
            CompositeELResolver compResolver = (CompositeELResolver)context.getELResolver();
            compResolver.add((ELResolver)beanResolver);
            Class[] types = new Class[]{String.class, String.class};
            Object[] values = new String[]{"Doug", "Donahue"};
            pass = ResolverTest.testELResolverInvoke((ELContext)context, (ELResolver)compResolver, sb, "isName", types, values, false, buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void compositeELResolverAddNPETest() throws Exception {
        boolean pass = true;
        StringBuffer buf = new StringBuffer();
        try {
            BareBonesELContext compContext = new BareBonesELContext();
            ELContext context = compContext.getELContext();
            CompositeELResolver compResolver = (CompositeELResolver)context.getELResolver();
            compResolver.add(null);
            buf.append(ELTestUtil.NL + "Tested Failed, CompositeResolver.add(), should have thrown NullPointerException!");
            pass = false;
        }
        catch (NullPointerException npe) {
            logger.log(System.Logger.Level.INFO, "Expected Exception thrown, when providing a null resolver to Composite.add()");
        }
        catch (Exception e) {
            buf.append("test failed with: " + ELTestUtil.NL + "EXPECTED: NullPointerException to be thrown " + ELTestUtil.NL + "RECEIVED: " + e.toString() + ELTestUtil.NL);
            pass = false;
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void compositeELResolverNPETest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        try {
            BareBonesELContext compContext = new BareBonesELContext();
            ELContext context = compContext.getELContext();
            ArrayELResolver aResolver = new ArrayELResolver();
            BeanELResolver bResolver = new BeanELResolver();
            CompositeELResolver compResolver = (CompositeELResolver)context.getELResolver();
            compResolver.add((ELResolver)aResolver);
            compResolver.add((ELResolver)bResolver);
            pass = ResolverTest.testELResolverNPE((ELResolver)compResolver, names, 2, "steve", buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void compositeELResolverPNFETest() throws Exception {
        boolean pass = true;
        StringBuffer buf = new StringBuffer();
        try {
            BareBonesELContext compContext = new BareBonesELContext();
            ELContext context = compContext.getELContext();
            ArrayELResolver aResolver = new ArrayELResolver();
            CompositeELResolver compResolver = (CompositeELResolver)context.getELResolver();
            compResolver.add((ELResolver)aResolver);
            pass = ResolverTest.testELResolverPNFE(context, (ELResolver)compResolver, names, 10, buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void compositeELResolverPNWETest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        SimpleBean sb = new SimpleBean();
        BareBonesELContext compContext = new BareBonesELContext();
        ELContext context = compContext.getELContext();
        BeanELResolver resolver = new BeanELResolver(true);
        CompositeELResolver compResolver = (CompositeELResolver)context.getELResolver();
        compResolver.add((ELResolver)resolver);
        try {
            pass = ResolverTest.testELResolverPNWE(context, (ELResolver)resolver, sb, "intention", "billy", buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }
}

