/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.customizedmapping.binarydata;

import ee.jakarta.tck.json.bind.customizedmapping.binarydata.model.BinaryDataContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class BinaryDataCustomizationTest {
    @Test
    public void testByteBinaryDataEncoding() {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withBinaryDataStrategy("BYTE"));
        String validationPattern = "\\{\\s*\"data\"\\s*:\\s*\\[\\s*84\\s*,\\s*101\\s*,\\s*115\\s*,\\s*116\\s*,\\s*32\\s*,\\s*83\\s*,\\s*116\\s*,\\s*114\\s*,\\s*105\\s*,\\s*110\\s*,\\s*103\\s*]\\s*}";
        String jsonString = jsonb.toJson((Object)new BinaryDataContainer());
        MatcherAssert.assertThat((String)"Failed to correctly marshal binary data using BYTE binary data encoding.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)validationPattern));
        BinaryDataContainer container = (BinaryDataContainer)jsonb.fromJson("{ \"data\" : [ 84, 101, 115, 116, 32, 83, 116, 114, 105, 110, 103 ] }", BinaryDataContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly unmarshal binary data using BYTE binary data encoding.", (Object)new String(container.getData()), (Matcher)Matchers.is((Object)"Test String"));
    }

    @Test
    public void testBase64BinaryDataEncoding() {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withBinaryDataStrategy("BASE_64"));
        String jsonString = jsonb.toJson((Object)new BinaryDataContainer());
        MatcherAssert.assertThat((String)"Failed to correctly marshal binary data using BASE_64 binary data encoding.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"data\"\\s*:\\s*\"VGVzdCBTdHJpbmc=\"\\s*}"));
        BinaryDataContainer unmarshalledObject = (BinaryDataContainer)jsonb.fromJson("{ \"data\" : \"VGVzdCBTdHJpbmc\" }", BinaryDataContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly unmarshal binary data using BASE_64 binary data encoding.", (Object)new String(unmarshalledObject.getData()), (Matcher)Matchers.is((Object)"Test String"));
    }

    @Test
    public void testBase64UrlBinaryDataEncoding() {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withBinaryDataStrategy("BASE_64_URL"));
        String jsonString = jsonb.toJson((Object)new BinaryDataContainer());
        MatcherAssert.assertThat((String)"Failed to correctly marshal binary data using BASE_64_URL binary data encoding.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"data\"\\s*:\\s*\"VGVzdCBTdHJpbmc=\"\\s*}"));
        BinaryDataContainer unmarshalledObject = (BinaryDataContainer)jsonb.fromJson("{ \"data\" : \"VGVzdCBTdHJpbmc=\" }", BinaryDataContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly unmarshal binary data using BASE_64_URL binary data encoding.", (Object)new String(unmarshalledObject.getData()), (Matcher)Matchers.is((Object)"Test String"));
    }
}

