/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.defaultmapping.polymorphictypes;

import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbException;
import jakarta.json.bind.annotation.JsonbSubtype;
import jakarta.json.bind.annotation.JsonbTypeInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TypeInfoExceptionsTest {
    private final Jsonb jsonb = JsonbBuilder.create();

    @Test
    public void testSerializeTypeInfoMultiInheritance() {
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.toJson((Object)new Dog()), (String)"Serialization of @JsonbTypeInfo multi inheritance is not supported.");
    }

    @Test
    public void testDeserializeTypeInfoMultiInheritance() {
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.fromJson("{\"@animal\":\"dog\",\"@livingThing\":\"dog\"}", Dog.class), (String)"Deserialization of @JsonbTypeInfo multi inheritance is not supported.");
    }

    @Test
    public void testInvalidAlias() {
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.toJson((Object)new InvalidAlias()), (String)"Serialization should have failed since set alias is not subtype of the class it is defined on.");
    }

    @Test
    public void testNameCollision() {
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.toJson((Object)new PropertyNameCollision()), (String)"Serialization of the type information to the property with the name which collides with the class property, is not supported");
    }

    @JsonbTypeInfo(value={@JsonbSubtype(alias="integer", type=Integer.class), @JsonbSubtype(alias="invalid", type=InvalidAlias.class)})
    public static class InvalidAlias {
    }

    @JsonbTypeInfo(key="keyName", value={@JsonbSubtype(alias="test", type=PropertyNameCollision.class)})
    public static class PropertyNameCollision {
        public String keyName;
    }

    public static final class Dog
    implements Animal,
    LivingEntity {
    }

    @JsonbTypeInfo(key="@livingThing", value={@JsonbSubtype(alias="dog", type=Dog.class)})
    public static interface LivingEntity {
    }

    @JsonbTypeInfo(key="@animal", value={@JsonbSubtype(alias="dog", type=Dog.class)})
    public static interface Animal {
    }
}

