/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.provider;

import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JsonProviderTest {
    private static final String JSONP_PROVIDER_FACTORY = "jakarta.json.provider";
    private String factoryValue;

    @BeforeEach
    public void setUp() {
        this.factoryValue = System.getProperty(JSONP_PROVIDER_FACTORY);
        System.clearProperty(JSONP_PROVIDER_FACTORY);
    }

    @AfterEach
    public void reset() {
        if (this.factoryValue != null) {
            System.setProperty(JSONP_PROVIDER_FACTORY, this.factoryValue);
        } else {
            System.clearProperty(JSONP_PROVIDER_FACTORY);
        }
    }

    @Test
    public void systemProperty() {
        System.setProperty(JSONP_PROVIDER_FACTORY, DummyJsonProvider.class.getName());
        JsonProvider provider = JsonProvider.provider();
        Assertions.assertEquals(DummyJsonProvider.class, provider.getClass());
    }

    public static class DummyJsonProvider
    extends JsonProvider {
        public JsonParser createParser(Reader reader) {
            return null;
        }

        public JsonParser createParser(InputStream in) {
            return null;
        }

        public JsonParserFactory createParserFactory(Map<String, ?> config) {
            return null;
        }

        public JsonGenerator createGenerator(Writer writer) {
            return null;
        }

        public JsonGenerator createGenerator(OutputStream out) {
            return null;
        }

        public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> config) {
            return null;
        }

        public JsonReader createReader(Reader reader) {
            return null;
        }

        public JsonReader createReader(InputStream in) {
            return null;
        }

        public JsonWriter createWriter(Writer writer) {
            return null;
        }

        public JsonWriter createWriter(OutputStream out) {
            return null;
        }

        public JsonWriterFactory createWriterFactory(Map<String, ?> config) {
            return null;
        }

        public JsonReaderFactory createReaderFactory(Map<String, ?> config) {
            return null;
        }

        public JsonObjectBuilder createObjectBuilder() {
            return null;
        }

        public JsonArrayBuilder createArrayBuilder() {
            return null;
        }

        public JsonBuilderFactory createBuilderFactory(Map<String, ?> config) {
            return null;
        }
    }
}

