/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.wizard.WizPane;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.JavaTestSecurityManager;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.services.ServiceManager;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.tool.CommandParser;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.DesktopManager;
import com.sun.javatest.tool.HelpManager;
import com.sun.javatest.tool.ManagerLoader;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.ExitCount;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.text.html.HTMLEditorKit;

public class Main {
    private static final String CMDMGRLIST = "META-INF/services/com.sun.javatest.tool.CommandManager.lst";
    public static final String COMMAND_MANAGERS_TO_LOAD = "services.com.sun.javatest.tool.CommandManager";
    private static final int RC_GUI_ACTIVE = -1;
    private static final int RC_OK = 0;
    private static final int RC_BATCH_TESTS_FAILED = 1;
    private static final int RC_BATCH_TESTS_ERROR = 2;
    private static final int RC_USER_ERROR = 3;
    private static final int RC_INTERNAL_ERROR = 4;
    private static boolean tracing;
    private static long traceStartTime;
    private static PrintWriter traceOut;
    private static boolean initialized;
    private static I18NResourceBundle i18n;
    private CommandManager[] commandManagers;
    private HelpManager helpManager;
    private DesktopManager desktopManager;
    private ServiceManager.ServiceCommandManager serviceManager;

    public static void main(String ... args) {
        String javaVersion;
        tracing = Boolean.getBoolean("javatest.trace.startup");
        if (tracing) {
            traceStartTime = System.currentTimeMillis();
        }
        if (Boolean.getBoolean("javatest.trace.printargs")) {
            StringBuilder fullCmd = new StringBuilder();
            StringBuilder incrementalCmd = new StringBuilder();
            for (String a : args) {
                fullCmd.append(a);
                fullCmd.append(" ");
                incrementalCmd.append("// ");
                incrementalCmd.append(a);
                incrementalCmd.append("\n");
            }
            System.out.println(fullCmd.toString().trim());
            System.out.println(incrementalCmd.toString());
        }
        if ((javaVersion = System.getProperty("java.version")) != null) {
            String[] oldVersions = new String[]{"1.0", "1.1", "1.2", "1.3", "1.4", "1.5", "1.6"};
            for (String oldVersion : oldVersions) {
                if (!javaVersion.startsWith(oldVersion)) continue;
                System.err.println("Please use Java(TM) Standard Edition, Version 7.0 or better to run the JT Harness(TM) harness.");
                System.exit(1);
            }
        }
        Main.main0(args);
    }

    private static void main0(String ... args) {
        Debug.setProperties(System.getProperties());
        PrintWriter out = new PrintWriter(System.err){

            @Override
            public void close() {
                this.flush();
            }
        };
        if (tracing) {
            traceOut = out;
        }
        try {
            ExitCount.inc();
            Main m = new Main();
            CommandContext ctx = new CommandContext(out);
            m.run(args, ctx);
            if (tracing) {
                Main.trace("Main.run complete");
            }
            out.flush();
            int[] stats = ctx.getTestStats();
            int rc = stats[2] > 0 ? 2 : (stats[1] > 0 ? 1 : 0);
            ExitCount.dec(true, rc);
            boolean preload = System.getProperty("javatest.preload.classes", "false").equals("true");
            if (preload) {
                if (tracing) {
                    Main.trace("preloading classes...");
                }
                Main.preloadUsefulClasses();
                if (tracing) {
                    Main.trace("preloaded classes");
                }
            }
            out.flush();
        }
        catch (CommandContext.Fault e) {
            CommandContext ctx;
            boolean verboseCommands;
            Throwable t = e.getCause();
            if (t instanceof Command.Fault && !(verboseCommands = (ctx = e.getContext()).getVerboseOptionValue("commands"))) {
                Command.Fault ce = (Command.Fault)t;
                Command c = ce.getCommand();
                out.println("+ " + c.toString());
            }
            out.println(e.getMessage());
            out.flush();
            Main.exit(3);
        }
        catch (CommandParser.Fault e) {
            Throwable t = e.getCause();
            if (t instanceof Command.Fault) {
                Command.Fault ce = (Command.Fault)t;
                Command c = ce.getCommand();
                out.println("+ " + c.toString());
            }
            out.println(e.getMessage());
            out.flush();
            Main.exit(3);
        }
        catch (Fault e) {
            out.println(e.getMessage());
            out.flush();
            Main.exit(4);
        }
        catch (Error | RuntimeException e) {
            e.printStackTrace(out);
            out.flush();
            Main.exit(4);
        }
    }

    private static void preloadUsefulClasses() {
        new HTMLEditorKit().createDefaultDocument();
        Interview i = new Interview("dummy"){
            Question qEnd = new FinalQuestion(this);
            {
                this.setFirstQuestion(this.qEnd);
            }
        };
        new WizPane(i);
    }

    private static void trace(String msg) {
        long now = System.currentTimeMillis();
        traceOut.println(MessageFormat.format("{0,number,[##0.0]} {1}", Float.valueOf((float)(now - traceStartTime) / 1000.0f), msg));
        traceOut.flush();
    }

    private static void exit(int exitCode) {
        SecurityManager sc = System.getSecurityManager();
        if (sc instanceof JavaTestSecurityManager) {
            JavaTestSecurityManager.setAllowExit(true);
        }
        System.exit(exitCode);
        throw new JavaTestError(i18n, "main.cannotExit.err");
    }

    public final void run(String[] args, PrintWriter out) throws Fault, CommandContext.Fault, CommandParser.Fault {
        this.run(args, new CommandContext(out));
    }

    public final void run(String[] args, CommandContext ctx) throws Fault, CommandContext.Fault, CommandParser.Fault {
        block26: {
            Desktop desktop;
            boolean needDesktop;
            if (this.commandManagers == null) {
                this.desktopManager = new DesktopManager();
                this.helpManager = new HelpManager();
                this.serviceManager = new ServiceManager.ServiceCommandManager();
                try {
                    Set<Object> mgrs;
                    String listOfManagersToLoad = System.getProperty(COMMAND_MANAGERS_TO_LOAD);
                    if (listOfManagersToLoad == null) {
                        String[] ml = new ManagerLoader(CommandManager.class, System.err);
                        mgrs = ml.loadManagers(CMDMGRLIST);
                    } else {
                        mgrs = new HashSet();
                        for (String name : listOfManagersToLoad.split(",")) {
                            mgrs.add(Class.forName(name).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        }
                    }
                    mgrs.add(this.desktopManager);
                    mgrs.add(this.helpManager);
                    mgrs.add(this.serviceManager);
                    this.commandManagers = mgrs.toArray(new CommandManager[mgrs.size()]);
                    this.helpManager.setCommandManagers(this.commandManagers);
                }
                catch (IOException e) {
                    throw new Fault(i18n, "main.cantAccessResource", CMDMGRLIST, e);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
            CommandParser p = new CommandParser(this.commandManagers);
            boolean urlEncoded = Boolean.getBoolean("javatest.command.urlEncoded");
            p.parse(args, urlEncoded, ctx);
            if (!initialized) {
                File classDir = ProductInfo.getJavaTestClassDir();
                Harness.setClassDir(classDir);
                JavaTestSecurityManager.install();
                initialized = true;
            }
            Command[] cmds = ctx.getCommands();
            boolean helpInfoRequired = this.helpManager.isInfoRequired();
            if (helpInfoRequired) {
                this.helpManager.showRequiredInfo(ctx.getLogWriter(), ctx);
                if (cmds.length == 0) {
                    return;
                }
            }
            if (needDesktop = ctx.isDesktopRequired()) {
                if (tracing) {
                    Main.trace("creating desktop...");
                }
                desktop = this.desktopManager.createDesktop(ctx);
                desktop.setVisible(true);
                ctx.setDesktop(desktop);
            } else {
                desktop = null;
            }
            if (tracing) {
                Main.trace("executing command line...");
            }
            if (desktop != null) {
                desktop.setVisible(true);
            }
            ctx.runCommands();
            if (tracing) {
                Main.trace("command line done");
            }
            if (desktop != null) {
                if (ctx.isCloseDesktopWhenDoneEnabled() && desktop.isOKToAutoExit()) {
                    Runnable task = () -> {
                        desktop.setVisible(false);
                        desktop.dispose();
                    };
                    try {
                        EventQueue.invokeAndWait(task);
                    }
                    catch (InterruptedException | InvocationTargetException e) {
                        if (tracing) {
                            e.printStackTrace();
                        }
                        break block26;
                    }
                }
                InterviewParameters ip_tmp = null;
                if (desktop.isEmpty() && ctx.hasConfig()) {
                    try {
                        ip_tmp = ctx.getConfig();
                    }
                    catch (CommandContext.Fault e) {
                        System.err.println(i18n.getString("main.cantGetConfig", (Object)e.getMessage()));
                    }
                }
                InterviewParameters ip = ip_tmp;
                Runnable task = () -> {
                    if (desktop.isEmpty()) {
                        if (ctx.hasConfig() && ip != null) {
                            if (tracing) {
                                Main.trace("show specified test suite");
                            }
                            desktop.restoreHistory();
                            Tool tool = desktop.addDefaultTool(ip);
                            Map<String, String> data = ctx.getDesktopData();
                            if (data != null) {
                                tool.restore(data);
                            }
                        } else if (desktop.isFirstTime()) {
                            if (tracing) {
                                Main.trace("show default");
                            }
                            desktop.addDefaultTool();
                        } else {
                            if (tracing) {
                                Main.trace("restore desktop");
                            }
                            desktop.restore();
                        }
                    }
                    if (tracing) {
                        Main.trace("set desktop visible");
                    }
                    desktop.setVisible(true);
                };
                try {
                    EventQueue.invokeAndWait(task);
                }
                catch (InterruptedException | InvocationTargetException e) {
                    if (!tracing) break block26;
                    e.printStackTrace();
                }
            }
        }
        ctx.dispose();
    }

    static {
        initialized = false;
        i18n = I18NResourceBundle.getBundleForClass(Main.class);
    }

    public static class Fault
    extends Exception {
        public Fault(I18NResourceBundle i18n, String key) {
            super(i18n.getString(key));
        }

        public Fault(I18NResourceBundle i18n, String key, Object arg) {
            super(i18n.getString(key, arg));
        }

        public Fault(I18NResourceBundle i18n, String key, Object ... args) {
            super(i18n.getString(key, args));
        }
    }
}

