/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.jboss51;

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jboss51.JndiRefType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.InjectionTargetType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.InjectionTargetTypeImpl;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiRefTypeImpl<T>
implements Child<T>,
JndiRefType<T> {
    private T t;
    private Node childNode;

    public JndiRefTypeImpl(T t, String nodeName, Node node) {
        this.t = t;
        this.childNode = node.createChild(nodeName);
    }

    public JndiRefTypeImpl(T t, String nodeName, Node node, Node childNode) {
        this.t = t;
        this.childNode = childNode;
    }

    public T up() {
        return this.t;
    }

    public JndiRefType<T> jndiName(String jndiName) {
        this.childNode.getOrCreate("jndi-name").text(jndiName);
        return this;
    }

    public String getJndiName() {
        return this.childNode.getTextValueForPatternName("jndi-name");
    }

    public JndiRefType<T> removeJndiName() {
        this.childNode.removeChildren("jndi-name");
        return this;
    }

    public JndiRefType<T> mappedName(String mappedName) {
        this.childNode.getOrCreate("mapped-name").text(mappedName);
        return this;
    }

    public String getMappedName() {
        return this.childNode.getTextValueForPatternName("mapped-name");
    }

    public JndiRefType<T> removeMappedName() {
        this.childNode.removeChildren("mapped-name");
        return this;
    }

    public InjectionTargetType<JndiRefType<T>> getOrCreateInjectionTarget() {
        List nodeList = this.childNode.get("injection-target");
        if (nodeList != null && nodeList.size() > 0) {
            return new InjectionTargetTypeImpl<JndiRefType<T>>(this, "injection-target", this.childNode, (Node)nodeList.get(0));
        }
        return this.createInjectionTarget();
    }

    public InjectionTargetType<JndiRefType<T>> createInjectionTarget() {
        return new InjectionTargetTypeImpl<JndiRefType<T>>(this, "injection-target", this.childNode);
    }

    public List<InjectionTargetType<JndiRefType<T>>> getAllInjectionTarget() {
        ArrayList<InjectionTargetType<JndiRefType<T>>> list = new ArrayList<InjectionTargetType<JndiRefType<T>>>();
        List nodeList = this.childNode.get("injection-target");
        for (Node node : nodeList) {
            InjectionTargetTypeImpl<JndiRefTypeImpl> type = new InjectionTargetTypeImpl<JndiRefTypeImpl>(this, "injection-target", this.childNode, node);
            list.add(type);
        }
        return list;
    }

    public JndiRefType<T> removeAllInjectionTarget() {
        this.childNode.removeChildren("injection-target");
        return this;
    }

    public JndiRefType<T> ignoreDependency() {
        this.childNode.getOrCreate("ignore-dependency");
        return this;
    }

    public Boolean isIgnoreDependency() {
        return this.childNode.getSingle("ignore-dependency") != null;
    }

    public JndiRefType<T> removeIgnoreDependency() {
        this.childNode.removeChild("ignore-dependency");
        return this;
    }

    public JndiRefType<T> description(String ... values) {
        if (values != null) {
            for (String name : values) {
                this.childNode.createChild("description").text(name);
            }
        }
        return this;
    }

    public List<String> getAllDescription() {
        ArrayList<String> result = new ArrayList<String>();
        List nodes = this.childNode.get("description");
        for (Node node : nodes) {
            result.add(node.getText());
        }
        return result;
    }

    public JndiRefType<T> removeAllDescription() {
        this.childNode.removeChildren("description");
        return this;
    }

    public JndiRefType<T> jndiRefName(String jndiRefName) {
        this.childNode.getOrCreate("jndi-ref-name").text(jndiRefName);
        return this;
    }

    public String getJndiRefName() {
        return this.childNode.getTextValueForPatternName("jndi-ref-name");
    }

    public JndiRefType<T> removeJndiRefName() {
        this.childNode.removeChildren("jndi-ref-name");
        return this;
    }

    public JndiRefType<T> id(String id) {
        this.childNode.attribute("id", id);
        return this;
    }

    public String getId() {
        return this.childNode.getAttribute("id");
    }

    public JndiRefType<T> removeId() {
        this.childNode.removeAttribute("id");
        return this;
    }
}

