/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.core_syntax.actions.usebean2;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    private static final String CONTEXT_ROOT = "/jsp_coresyntx_act_usebean2_web";

    public URLClientIT() throws Exception {
        this.setGeneralURI("/jsp/spec/core_syntax/actions/usebean2");
        this.setContextRoot(CONTEXT_ROOT);
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_coresyntx_act_usebean2_web.war");
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_coresyntx_act_usebean2_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/beanBody.tag", "tags/beanBody.tag");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/unrestrictedBodyTestInclude.jsp")), "unrestrictedBodyTestInclude.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/unrestrictedBodyTest.jsp")), "unrestrictedBodyTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/noClassNoBeanNameTest.jsp")), "noClassNoBeanNameTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/inScriptlessTest.jsp")), "inScriptlessTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/existingWithBodyTestInclude.jsp")), "existingWithBodyTestInclude.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/existingWithBodyTest.jsp")), "existingWithBodyTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/blockSCopeTest.jsp")), "blockSCopeTest.jsp");
        return archive;
    }

    @Test
    public void inScriptlessTest() throws Exception {
        String testName = "inScriptlessTest";
        TEST_PROPS.setProperty("request", "GET /jsp_coresyntx_act_usebean2_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "[|]|invoke tag|[|]");
        TEST_PROPS.setProperty("unexpected_response_match", "${list");
        this.invoke();
    }

    @Test
    public void blockSCopeTest() throws Exception {
        String testName = "blockSCopeTest";
        TEST_PROPS.setProperty("request", "GET /jsp_coresyntx_act_usebean2_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "one");
        TEST_PROPS.setProperty("unexpected_response_match", "two");
        this.invoke();
    }

    @Test
    public void existingWithBodyTest() throws Exception {
        String testName = "existingWithBodyTest";
        TEST_PROPS.setProperty("request", "GET /jsp_coresyntx_act_usebean2_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "one");
        TEST_PROPS.setProperty("unexpected_response_match", "This body should be ignored");
        this.invoke();
    }

    @Test
    public void noClassNoBeanNameTest() throws Exception {
        String testName = "noClassNoBeanNameTest";
        TEST_PROPS.setProperty("request", "GET /jsp_coresyntx_act_usebean2_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED|InstantiationException");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }

    @Test
    public void unrestrictedBodyTest() throws Exception {
        String testName = "unrestrictedBodyTest";
        TEST_PROPS.setProperty("request", "GET /jsp_coresyntx_act_usebean2_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "add to list|added to list|In unrestrictedBodyTestInclude.jsp|one");
        this.invoke();
    }
}

