/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.jspdocument.general;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import ee.jakarta.tck.pages.spec.jspdocument.general.EchoTag;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    private static final String CONTEXT_ROOT = "/jsp_jspdocument_general_web";

    public URLClientIT() throws Exception {
        this.setContextRoot(CONTEXT_ROOT);
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_jspdocument_general_web.war");
        archive.addClasses(new Class[]{EchoTag.class});
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_jspdocument_general_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tagdep.tld", "tagdep.tld");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/tagDependentTest.jspx")), "tagDependentTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/negativeWellFormedness.jspx")), "negativeWellFormedness.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/negativeDTDValidation.jspx")), "negativeDTDValidation.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/invalidPlainURI.jsp")), "invalidPlainURI.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/identifyByJspRoot.jsp")), "identifyByJspRoot.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/identifyByExtension.jspx")), "identifyByExtension.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/identifyByConfig.jsp")), "identifyByConfig.jsp");
        return archive;
    }

    @Test
    public void negativeWellFormednessTest() throws Exception {
        String testName = "negativeWellFormedness";
        TEST_PROPS.setProperty("request", "GET /jsp_jspdocument_general_web/" + testName + ".jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void identifyByJspRootTest() throws Exception {
        String testName = "identifyByJspRoot";
        TEST_PROPS.setProperty("request", "GET /jsp_jspdocument_general_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "200");
        this.invoke();
    }

    @Test
    public void identifyByExtensionTest() throws Exception {
        String testName = "identifyByExtension";
        TEST_PROPS.setProperty("request", "GET /jsp_jspdocument_general_web/" + testName + ".jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "200");
        this.invoke();
    }

    @Test
    public void identifyByConfigTest() throws Exception {
        String testName = "identifyByConfig";
        TEST_PROPS.setProperty("request", "GET /jsp_jspdocument_general_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "200");
        this.invoke();
    }

    @Test
    public void negativeDTDValidationTest() throws Exception {
        String testName = "negativeDTDValidation";
        TEST_PROPS.setProperty("request", "GET /jsp_jspdocument_general_web/" + testName + ".jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void invalidPlainURITest() throws Exception {
        String testName = "invalidPlainURI";
        TEST_PROPS.setProperty("request", "GET /jsp_jspdocument_general_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "200");
        this.invoke();
    }

    @Test
    public void tagDependentTest() throws Exception {
        String testName = "tagDependentTest";
        TEST_PROPS.setProperty("request", "GET /jsp_jspdocument_general_web/" + testName + ".jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "START ${pageScope.eval}|jsp:scriptlet|out.println(\"scriptlet\");|jsp:scriptlet|jsp:useBean|java.util.Date|jsp:getProperty|property|use jsp:body|START ${pageScope.eval}|jsp:scriptlet|out.println(\"scriptlet\");|jsp:scriptlet|jsp:useBean|java.util.Date|jsp:getProperty|property|Expression from attribute: 18|END 72");
        TEST_PROPS.setProperty("unexpected_response_match", "evaluated");
        this.invoke();
    }
}

