/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import jdk.incubator.http.internal.websocket.CooperativeHandler;
import jdk.incubator.http.internal.websocket.FailWebSocketException;
import jdk.incubator.http.internal.websocket.Frame;
import jdk.incubator.http.internal.websocket.FrameConsumer;
import jdk.incubator.http.internal.websocket.MessageStreamConsumer;
import jdk.incubator.http.internal.websocket.RawChannel;

final class Receiver {
    private final MessageStreamConsumer messageConsumer;
    private final RawChannel channel;
    private final FrameConsumer frameConsumer;
    private final Frame.Reader reader = new Frame.Reader();
    private final RawChannel.RawEvent event = this.createHandler();
    private final AtomicLong demand = new AtomicLong();
    private final CooperativeHandler handler;
    private ByteBuffer data;
    private volatile int state;
    private static final int UNREGISTERED = 0;
    private static final int AVAILABLE = 1;
    private static final int WAITING = 2;

    Receiver(MessageStreamConsumer messageStreamConsumer, RawChannel rawChannel) {
        this.messageConsumer = messageStreamConsumer;
        this.channel = rawChannel;
        this.frameConsumer = new FrameConsumer(this.messageConsumer);
        this.data = rawChannel.initialByteBuffer();
        this.handler = new CooperativeHandler(this::pushContinuously);
    }

    private RawChannel.RawEvent createHandler() {
        return new RawChannel.RawEvent(){

            @Override
            public int interestOps() {
                return 1;
            }

            @Override
            public void handle() {
                Receiver.this.state = 1;
                Receiver.this.handler.handle();
            }
        };
    }

    void request(long l3) {
        if (l3 < 0L) {
            throw new IllegalArgumentException("Negative: " + l3);
        }
        this.demand.accumulateAndGet(l3, (l, l2) -> l + l2 < 0L ? Long.MAX_VALUE : l + l2);
        this.handler.handle();
    }

    void acknowledge() {
        long l = this.demand.decrementAndGet();
        if (l < 0L) {
            throw new InternalError(String.valueOf(l));
        }
    }

    void close() {
        this.handler.stop();
    }

    private void pushContinuously() {
        block11: while (!this.handler.isStopped()) {
            if (this.data.hasRemaining()) {
                if (this.demand.get() <= 0L) break;
                try {
                    int n = this.data.position();
                    this.reader.readFrame(this.data, this.frameConsumer);
                    int n2 = this.data.position();
                    assert (n != n2) : this.data;
                    continue;
                }
                catch (FailWebSocketException failWebSocketException) {
                    this.handler.stop();
                    this.messageConsumer.onError(failWebSocketException);
                    continue;
                }
            }
            switch (this.state) {
                case 2: {
                    return;
                }
                case 0: {
                    try {
                        this.state = 2;
                        this.channel.registerEvent(this.event);
                    }
                    catch (IOException iOException) {
                        this.handler.stop();
                        this.messageConsumer.onError(iOException);
                    }
                    return;
                }
                case 1: {
                    try {
                        this.data = this.channel.read();
                    }
                    catch (IOException iOException) {
                        this.handler.stop();
                        this.messageConsumer.onError(iOException);
                        return;
                    }
                    if (this.data == null) {
                        this.handler.stop();
                        this.messageConsumer.onComplete();
                        return;
                    }
                    if (this.data.hasRemaining()) continue block11;
                    this.state = 0;
                    continue block11;
                }
            }
            throw new InternalError(String.valueOf(this.state));
        }
    }
}

