/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.sigfile;

import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.sigfile.FeaturesHolder;
import com.sun.tdk.signaturetest.sigfile.Format;
import com.sun.tdk.signaturetest.sigfile.Parser;
import com.sun.tdk.signaturetest.sigfile.Reader;
import com.sun.tdk.signaturetest.toyxml.Elem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class SignatureClassLoader
implements Reader {
    protected final Format format;
    protected final Set<FeaturesHolder.Feature> features;
    private BufferedReader in;
    private final Parser parser;
    private static final int BUFSIZE = 32768;
    private final List<Elem> elems;
    protected String apiVersion = "";
    protected String signatureFileFormat = "";

    protected SignatureClassLoader(Format format) {
        this.format = format;
        this.features = format.getSupportedFeatures();
        this.parser = this.getParser();
        this.elems = new ArrayList<Elem>();
    }

    protected abstract Parser getParser();

    @Override
    public boolean hasFeature(FeaturesHolder.Feature feature) {
        return this.features.contains(feature);
    }

    @Override
    public Set<FeaturesHolder.Feature> getAllSupportedFeatures() {
        return this.features;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public ClassDescription readNextClass() throws IOException {
        String classDescr = null;
        List<String> definitions = new ArrayList<String>();
        while (true) {
            this.in.mark(32768);
            String currentLine = this.in.readLine();
            if (currentLine == null) break;
            currentLine = currentLine.trim();
            if ((currentLine = this.preprocessLine(currentLine)).isEmpty() || currentLine.startsWith("#")) continue;
            MemberType type = MemberType.getItemType(currentLine);
            if (type == MemberType.CLASS) {
                if (classDescr != null) break;
                classDescr = currentLine;
                continue;
            }
            if (type == MemberType.MODULE) {
                this.readXML("module", currentLine);
                continue;
            }
            if (classDescr == null) {
                throw new Error();
            }
            definitions.add(currentLine);
        }
        this.in.reset();
        if (classDescr == null && definitions.isEmpty()) {
            return null;
        }
        classDescr = this.convertClassDescr(classDescr);
        definitions = this.convertClassDefinitions(definitions);
        return this.parser.parseClassDescription(classDescr, definitions);
    }

    @Override
    public List<Elem> getElems() {
        return this.elems;
    }

    protected void readXML(String elName, String line) throws IOException {
        StringBuilder xmlTxt = new StringBuilder();
        while (line != null && !line.trim().isEmpty()) {
            line = line.trim();
            if ((line = this.preprocessLine(line)).isEmpty() || line.startsWith("#")) {
                line = this.in.readLine();
                continue;
            }
            xmlTxt.append(line);
            line = this.in.readLine();
        }
        Elem d = this.processXMLFragment(xmlTxt.toString());
        if (d != null) {
            this.elems.add(d);
        }
    }

    protected Elem processXMLFragment(String s) {
        return null;
    }

    protected String preprocessLine(String currentLine) {
        return currentLine;
    }

    protected abstract String convertClassDescr(String var1);

    protected abstract List<String> convertClassDefinitions(List<String> var1);

    @Override
    public boolean readSignatureFile(URL fileURL) throws IOException {
        this.in = new BufferedReader(new InputStreamReader(fileURL.openStream(), StandardCharsets.UTF_8), 32768);
        assert (this.in.markSupported());
        return this.readHeaders(this.in);
    }

    protected boolean readHeaders(BufferedReader in) throws IOException {
        String currentLine = in.readLine();
        if (currentLine == null) {
            return false;
        }
        this.signatureFileFormat = currentLine.trim();
        if (!this.signatureFileFormat.equals(this.format.getVersion())) {
            return false;
        }
        currentLine = in.readLine();
        if (currentLine == null) {
            return false;
        }
        if (!(currentLine = currentLine + ' ').startsWith("#Version ")) {
            return false;
        }
        this.apiVersion = currentLine.substring("#Version ".length()).trim();
        in.mark(32768);
        while ((currentLine = in.readLine()) != null && currentLine.startsWith("#")) {
            this.removeMissingFeature(currentLine);
        }
        in.reset();
        return true;
    }

    private void removeMissingFeature(String currentLine) {
        FeaturesHolder.Feature f = null;
        boolean remove = false;
        for (FeaturesHolder.Feature feature : this.features) {
            f = feature;
            if (!f.match(currentLine)) continue;
            remove = true;
            break;
        }
        if (f != null && remove) {
            this.features.remove(f);
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }
}

