/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.produceconsume;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.ee.rs.produceconsume.Resource;
import ee.jakarta.tck.ws.rs.ee.rs.produceconsume.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 3927081991341346347L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_produceconsume_web/resource");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/produceconsume/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_produceconsume_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void anyPlainTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "plain"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/plain");
        this.invoke();
    }

    @Test
    public void anyWidgetsxmlTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "widgetsxml"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "application/widgets+xml");
        this.invoke();
    }

    @Test
    public void anyUnknownTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "unknown"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "unknown/unknown");
        this.invoke();
    }

    @Test
    public void widgetsXmlAnyTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: application/widgets+xml");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "any"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "*/*");
        this.invoke();
    }

    @Test
    public void plainAnyTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "any"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "*/*");
        this.invoke();
    }

    @Test
    public void unknownAnyTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: unknown/unknown");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "any"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "*/*");
        this.invoke();
    }

    @Test
    public void htmlPlainTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_HTML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "plain"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NOT_ACCEPTABLE));
        this.invoke();
    }

    @Test
    public void htmlUnknownTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_HTML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "plain"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NOT_ACCEPTABLE));
        this.invoke();
    }

    @Test
    public void plainPlusProducePlainTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "plus"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/plain");
        this.invoke();
    }

    @Test
    public void plainPlusProduceXmlTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "plus"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/xml");
        this.invoke();
    }

    @Test
    public void anyPlainConsumesTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "plain"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/plain");
        this.invoke();
    }

    @Test
    public void anyWidgetsxmlConsumesTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "widgetsxml"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "application/widgets+xml");
        this.invoke();
    }

    @Test
    public void anyUnknownConsumesTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "unknown"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "unknown/unknown");
        this.invoke();
    }

    @Test
    public void widgetsXmlAnyConsumesTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Content-Type: application/widgets+xml");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "any"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "*/*");
        this.invoke();
    }

    @Test
    public void plainAnyConsumesTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "any"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "*/*");
        this.invoke();
    }

    @Test
    public void unknownAnyConsumesTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Content-type: unknown/unknown");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "any"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "*/*");
        this.invoke();
    }

    @Test
    public void htmlPlainConsumesTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_HTML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "plain"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.UNSUPPORTED_MEDIA_TYPE));
        this.invoke();
    }

    @Test
    public void htmlUnknownConsumesTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_HTML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "plain"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.UNSUPPORTED_MEDIA_TYPE));
        this.invoke();
    }

    @Test
    public void plainPlusConsumePlainTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "plus"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/plain");
        this.invoke();
    }

    @Test
    public void plainPlusConsumeXmlTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "plus"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/xml");
        this.invoke();
    }
}

