/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverapplicationconfiginlib;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverapplicationconfig.WSClientIT;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverapplicationconfiginlib.AppConfig;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverapplicationconfiginlib.OtherAppConfig;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSLibClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = 1544727768161691523L;
    private static final String CONTENT = WSLibClientIT.class.getName();

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_ee_server_appconfig_lib_web.war");
        archive.addPackages(false, Filters.exclude((Class[])new Class[]{WSClientIT.class, com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverapplicationconfig.AppConfig.class, com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverapplicationconfig.OtherAppConfig.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverapplicationconfig"});
        archive.addPackages(false, new String[]{"com.sun.ts.tests.websocket.common.stringbean"});
        archive.addClasses(new Class[]{IOUtil.class});
        JavaArchive appConfigLibJar = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"wsc_ee_server_appconfig_lib_config.jar")).addClasses(new Class[]{AppConfig.class, OtherAppConfig.class});
        archive.addAsLibrary((Archive)appConfigLibJar);
        return archive;
    }

    public WSLibClientIT() throws Exception {
        this.setContextRoot("wsc_ee_server_appconfig_lib_web");
    }

    @Test
    public void usedServerTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("used"));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, CONTENT);
        this.setProperty(WebSocketCommonClient.Property.CONTENT, CONTENT);
        this.invoke();
    }

    @Test
    public void unusedServerTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("unused"));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, CONTENT);
        this.invokeFail();
        String message = this.getResponseAsString();
        WSLibClientIT.assertTrue(WSLibClientIT.isNullOrEmpty(message), "The unused server endpoint should not be registered");
    }

    @Test
    public void otherUsedServerTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("other"));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, CONTENT);
        this.setProperty(WebSocketCommonClient.Property.CONTENT, CONTENT);
        this.invoke();
    }

    @Test
    public void configuredServerTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("configured"));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, CONTENT);
        this.setProperty(WebSocketCommonClient.Property.CONTENT, CONTENT);
        this.invoke();
    }

    @Test
    public void unusedConfiguredServerTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("unusedconfig"));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, CONTENT);
        this.invokeFail();
        String message = this.getResponseAsString();
        WSLibClientIT.assertTrue(WSLibClientIT.isNullOrEmpty(message), "The unused server endpoint config should not register an endpoint");
    }

    private void invokeFail() {
        try {
            this.invoke(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

