/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.builder;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.common.util.StringUtil;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Extension;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.util.List;

public class WSCommonServer
extends Endpoint
implements MessageHandler.Whole<String> {
    protected Session session;
    protected ServerEndpointConfig config;

    public void onMessage(String message) {
        try {
            if (message.equals("subprotocols")) {
                this.session.getBasicRemote().sendText(StringUtil.objectsToString(this.config.getSubprotocols()));
            } else if (message.equals("path")) {
                this.session.getBasicRemote().sendText(this.config.getPath());
            } else if (message.equals("endpoint")) {
                this.session.getBasicRemote().sendText(this.config.getEndpointClass().getName());
            } else if (message.equals("configurator")) {
                this.session.getBasicRemote().sendText(this.config.getConfigurator().getClass().getName());
            } else if (message.equals("extensions")) {
                Extension[] ext;
                StringBuilder sb = new StringBuilder().append("[");
                for (Extension e : ext = this.config.getExtensions().toArray(new Extension[0])) {
                    sb.append(e.getName()).append(" ");
                }
                sb.append("]");
                this.session.getBasicRemote().sendText(sb.toString());
            } else if (message.equals("decoders")) {
                List list = this.config.getDecoders();
                this.session.getBasicRemote().sendText("{" + StringUtil.objectsToString(list) + "}");
            } else if (message.equals("encoders")) {
                List list = this.config.getEncoders();
                this.session.getBasicRemote().sendText("{" + StringUtil.objectsToString(list) + "}");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                this.session.getBasicRemote().sendText(IOUtil.printStackTrace(e));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void onOpen(Session session, EndpointConfig config) {
        this.session = session;
        this.config = (ServerEndpointConfig)config;
        session.addMessageHandler((MessageHandler)this);
    }

    public void onError(Session session, Throwable thr) {
        thr.printStackTrace();
        String message = IOUtil.printStackTrace(thr);
        try {
            session.getBasicRemote().sendText(message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

