/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.january.form.Component;
import org.eclipse.january.form.Composite;
import org.eclipse.january.form.ICEObject;
import org.eclipse.january.form.IComponentVisitor;
import org.eclipse.january.form.Identifiable;

@XmlRootElement(name="Form")
public class Form
extends ICEObject
implements Composite {
    private int itemID = 0;
    @XmlElementWrapper
    @XmlAnyElement(lax=true)
    private ArrayList<Component> componentList = new ArrayList();
    protected ArrayList<String> actionList;
    protected boolean canProcess = true;

    public Form() {
        this.listeners = new ArrayList();
    }

    @XmlAttribute
    public int getItemID() {
        return this.itemID;
    }

    public void setItemID(int newItemID) {
        this.itemID = newItemID;
    }

    @XmlElement(name="ActionList")
    public ArrayList<String> getActionList() {
        return this.actionList;
    }

    public void setActionList(ArrayList<String> actions) {
        this.actionList = actions;
    }

    public boolean isReady() {
        return this.canProcess;
    }

    public void markReady(boolean ready) {
        this.canProcess = ready;
    }

    @Override
    public boolean equals(Object otherForm) {
        if (this == otherForm) {
            return true;
        }
        if (otherForm == null || !(otherForm instanceof Form)) {
            return false;
        }
        if (!super.equals(otherForm)) {
            return false;
        }
        Form castedForm = (Form)otherForm;
        if (this.itemID != castedForm.itemID || this.canProcess != castedForm.canProcess) {
            return false;
        }
        for (Component comp : this.componentList) {
            if (castedForm.componentList.contains(comp)) continue;
            return false;
        }
        if (this.actionList != null && castedForm != null) {
            for (String action : this.actionList) {
                if (castedForm.actionList.contains(action)) continue;
                return false;
            }
        }
        return (this.actionList != null || castedForm.actionList == null) && (this.actionList == null || castedForm.actionList != null);
    }

    @Override
    public int hashCode() {
        int hash = 13;
        hash = 31 * hash + super.hashCode();
        hash = 31 * hash + this.itemID;
        hash = 31 * hash + (!this.canProcess ? 0 : 1);
        for (Component comp : this.componentList) {
            hash = 31 * hash + comp.hashCode();
        }
        if (this.actionList != null) {
            for (String action : this.actionList) {
                hash = 31 * hash + action.hashCode();
            }
        }
        return hash;
    }

    @Override
    public Object clone() {
        Form form = new Form();
        form.copy(this);
        return form;
    }

    public void copy(Form otherForm) {
        int i;
        if (otherForm == null) {
            return;
        }
        super.copy(otherForm);
        if (otherForm.actionList == null) {
            this.actionList = null;
        } else {
            if (this.actionList != null) {
                this.actionList.clear();
            } else {
                this.actionList = new ArrayList();
            }
            i = 0;
            while (i < otherForm.actionList.size()) {
                this.actionList.add(otherForm.actionList.get(i));
                ++i;
            }
        }
        this.componentList.clear();
        i = 0;
        while (i < otherForm.componentList.size()) {
            Identifiable compWithId = (Identifiable)otherForm.componentList.get(i).clone();
            this.componentList.add((Component)compWithId);
            ++i;
        }
        this.itemID = otherForm.itemID;
        this.canProcess = otherForm.canProcess;
        this.notifyListeners();
    }

    @Override
    public void update(String updatedKey, String newValue) {
        for (Component i : this.componentList) {
            i.update(updatedKey, newValue);
        }
    }

    @Override
    public void accept(IComponentVisitor visitor) {
    }

    @Override
    public void addComponent(Component child) {
        if (child == null) {
            throw new RuntimeException("Data components in Forms  cannot be null.");
        }
        this.componentList.add(child);
        this.notifyListeners();
    }

    @Override
    public void removeComponent(int childId) {
        Identifiable comp = null;
        int i = 0;
        while (i < this.componentList.size()) {
            comp = this.componentList.get(i);
            if (comp.getId() == childId) {
                this.componentList.remove(i);
                break;
            }
            ++i;
        }
    }

    @Override
    public Component getComponent(int childId) {
        Identifiable comp = null;
        int i = 0;
        while (i < this.componentList.size()) {
            comp = this.componentList.get(i);
            if (comp.getId() == childId) {
                return this.componentList.get(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public int getNumberOfComponents() {
        return this.componentList.size();
    }

    @Override
    public ArrayList<Component> getComponents() {
        return this.componentList;
    }
}

