/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.january.form.MaterialStack;

@XmlRootElement(name="Material")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Material
implements Cloneable,
Comparable<Material> {
    @XmlTransient
    public static final String ATOMIC_MASS = "M (amu)";
    @XmlTransient
    public static final String ATOMIC_DENSITY = "Dens (at/nm3)";
    @XmlTransient
    public static final String DENSITY = "Dens (g/cm3)";
    @XmlTransient
    public static final String NUMBER_DENSITY = "N (Ang^-3)";
    @XmlTransient
    public static final String COHERENT_SCAT_LENGTH = "Coh b";
    @XmlTransient
    public static final String INCOHERENT_SCAT_LENGTH = "Inc b";
    @XmlTransient
    public static final String COHERENT_SCAT_X_SECTION = "Coh xs";
    @XmlTransient
    public static final String INCOHERENT_SCAT_X_SECTION = "Inc xs";
    @XmlTransient
    public static final String SCAT_LENGTH_DENSITY = "Scattering Length Density (A^-2)";
    @XmlTransient
    public static final String SCAT_X_SECTION = "Scattering Cross Section";
    @XmlTransient
    public static final String ABS_X_SECTION = "Abs xs";
    @XmlTransient
    public static final String MASS_ABS_COHERENT = "mmabs/l (Ang^-2)";
    @XmlTransient
    public static final String MASS_ABS_INCOHERENT = "mminc (Ang^-1)";
    @XmlElement
    private String name = "";
    @XmlElement(name="properties")
    private HashMap<String, Double> properties = new HashMap();
    @XmlElement(name="components")
    private HashMap<String, MaterialStack> components = new HashMap();

    public String getName() {
        return this.name;
    }

    public void setName(String matName) {
        this.name = matName;
    }

    public double getProperty(String key) {
        double value = 0.0;
        if (this.properties.containsKey(key)) {
            value = this.properties.get(key);
        }
        return value;
    }

    public void setProperty(String key, double value) {
        this.properties.put(key, value);
    }

    public void removeProperty(String key) {
        if (this.properties.containsKey(key)) {
            this.properties.remove(key);
        }
    }

    public Map<String, Double> getProperties() {
        return new HashMap<String, Double>(this.properties);
    }

    public List<MaterialStack> getComponents() {
        return new ArrayList<MaterialStack>(this.components.values());
    }

    public void addComponent(Material component) {
        MaterialStack stack = new MaterialStack(component, 1);
        this.addComponent(stack);
    }

    public void addComponent(MaterialStack stack) {
        Material component = stack.getMaterial();
        if (this.components.containsKey(component.name)) {
            this.components.get(component.name).addAmount(stack.getAmount());
        } else {
            this.components.put(component.getName(), stack);
        }
    }

    public boolean isComponent(Material material) {
        return this.components.containsKey(material.getName());
    }

    public boolean equals(Object other) {
        boolean retVal = false;
        if (other != null && other instanceof Material) {
            if (this == other) {
                retVal = true;
            } else {
                Material otherMaterial = (Material)other;
                boolean val1 = this.name.equals(otherMaterial.name);
                boolean val2 = this.components.equals(otherMaterial.components);
                boolean val3 = this.properties.equals(otherMaterial.properties);
                retVal = val1 && val2 && val3;
            }
        }
        return retVal;
    }

    public int hashCode() {
        int hash = 8;
        hash = 31 * hash + this.name.hashCode();
        hash = 31 * hash + this.properties.hashCode();
        hash = 31 * hash + this.components.hashCode();
        return hash;
    }

    public void copy(Material material) {
        if (material != null && material != this) {
            this.name = material.name;
            this.properties = new HashMap<String, Double>(material.properties);
            this.components = new HashMap<String, MaterialStack>(material.components);
        }
    }

    public void updateProperties() {
        if (!this.isElemental()) {
            double numberDensity = 0.0;
            double muMAbs = 0.0;
            double muMInc = 0.0;
            double b = 0.0;
            double density = this.getProperty(DENSITY);
            double molMass = 0.0;
            List<MaterialStack> list = this.getComponents();
            for (MaterialStack stack : list) {
                System.out.println("adding mass: " + stack.getMaterial().getName() + " amount: " + (molMass += (double)stack.getAmount() * stack.getMaterial().getProperty(ATOMIC_MASS)));
            }
            if (list.size() > 0 && molMass >= 1.0) {
                numberDensity = 0.602 * (density / molMass);
                int j = 0;
                while (j < list.size()) {
                    MaterialStack stack = list.get(j);
                    Material mat = stack.getMaterial();
                    int N = stack.getAmount();
                    double cohb = 1.0E-5 * mat.getProperty(COHERENT_SCAT_LENGTH);
                    b += (double)N * cohb;
                    double massPercent = mat.getProperty(ATOMIC_MASS) / molMass;
                    muMAbs += (double)N * massPercent * mat.getProperty(MASS_ABS_COHERENT);
                    muMInc += (double)N * massPercent * mat.getProperty(MASS_ABS_INCOHERENT);
                    ++j;
                }
            }
            this.setProperty(ATOMIC_MASS, molMass);
            this.setProperty(NUMBER_DENSITY, numberDensity);
            this.setProperty(SCAT_LENGTH_DENSITY, numberDensity * b);
            this.setProperty(MASS_ABS_COHERENT, muMAbs *= 1.0E-24 * this.getProperty(DENSITY));
            this.setProperty(MASS_ABS_INCOHERENT, muMInc *= 1.0E-24 * this.getProperty(DENSITY));
        }
    }

    public boolean isElemental() {
        return this.components.isEmpty();
    }

    public int getIsotopicNumber() {
        int retVal;
        String numStr = "";
        if (!this.components.isEmpty()) {
            retVal = 0;
        } else {
            int i = 0;
            while (i < this.name.length()) {
                if (!Character.isDigit(this.name.charAt(i))) break;
                numStr = String.valueOf(numStr) + this.name.charAt(i);
                ++i;
            }
            retVal = numStr.equals("") ? 0 : Integer.parseInt(numStr);
        }
        return retVal;
    }

    public String getElementalName() {
        String nameStr = "";
        if (!this.components.isEmpty()) {
            nameStr = this.name;
        } else {
            int i = this.name.length() - 1;
            while (i >= 0) {
                if (!Character.isLetter(this.name.charAt(i))) break;
                nameStr = String.valueOf(this.name.charAt(i)) + nameStr;
                --i;
            }
        }
        return nameStr;
    }

    public Object clone() {
        Material clone = new Material();
        clone.copy(this);
        return clone;
    }

    @Override
    public int compareTo(Material otherMaterial) {
        int returnVal = 0;
        String thisElement = this.getElementalName();
        String otherElement = otherMaterial.getElementalName();
        int thisNum = this.getIsotopicNumber();
        int otherNum = otherMaterial.getIsotopicNumber();
        returnVal = thisElement.toLowerCase().equals(otherElement.toLowerCase()) ? (thisNum < otherNum ? -1 : (thisNum > otherNum ? 1 : 0)) : thisElement.toLowerCase().compareTo(otherElement.toLowerCase());
        return returnVal;
    }
}

