/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.geometry.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.january.geometry.Cube;
import org.eclipse.january.geometry.GeometryFactory;
import org.eclipse.january.geometry.GeometryPackage;
import org.eclipse.january.geometry.Triangle;
import org.eclipse.january.geometry.impl.ShapeImpl;
import org.eclipse.january.geometry.util.MeshUtils;

public class CubeImpl
extends ShapeImpl
implements Cube {
    protected static final double SIDE_LENGTH_EDEFAULT = 0.0;
    protected double sideLength = 0.0;
    private double prevSideLength = 0.0;

    protected CubeImpl() {
        this.properties.put("sideLength", this.sideLength);
    }

    @Override
    protected EClass eStaticClass() {
        return GeometryPackage.Literals.CUBE;
    }

    @Override
    public double getSideLength() {
        return this.sideLength;
    }

    @Override
    public void setSideLength(double newSideLength) {
        if (newSideLength != this.sideLength) {
            double oldSideLength = this.sideLength;
            this.sideLength = newSideLength;
            if (this.properties.get("sideLength") == null || (Double)this.properties.get("sideLength") != this.sideLength) {
                this.properties.put("sideLength", this.sideLength);
            }
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldSideLength, this.sideLength));
            }
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getSideLength();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setSideLength((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setSideLength(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.sideLength != 0.0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (sideLength: ");
        result.append(this.sideLength);
        result.append(')');
        return result.toString();
    }

    @Override
    public EList<Triangle> getTriangles() {
        if (this.prevSideLength == this.sideLength && this.triangles != null && !this.triangles.isEmpty()) {
            if (this.triangles == null) {
                this.triangles = new BasicEList();
            }
            return this.triangles;
        }
        this.prevSideLength = this.sideLength;
        double[] points = MeshUtils.createRectangularPrism(this.sideLength, this.sideLength, this.sideLength);
        if (this.triangles == null) {
            this.triangles = new BasicInternalEList(Triangle.class);
        } else {
            this.triangles.clear();
        }
        this.triangles.addAll(MeshUtils.createRectangularPrismMesh(points));
        return this.triangles;
    }

    @Override
    public void setProperty(String property, double value) {
        if ("sideLength".equals(property)) {
            this.setSideLength(value);
        }
        super.setProperty(property, value);
    }

    @Override
    public Object clone() {
        Cube clone = GeometryFactory.eINSTANCE.createCube();
        clone.copy(this);
        return clone;
    }
}

