/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.january.form.GeometryComponent;
import org.eclipse.january.form.ICEJAXBHandler;
import org.eclipse.january.form.IUpdateable;
import org.eclipse.january.form.IUpdateableListener;
import org.eclipse.january.form.MeshComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="ICEObject")
@XmlSeeAlso(value={GeometryComponent.class, MeshComponent.class})
public class ICEObject
implements IUpdateable {
    @XmlTransient
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @XmlTransient
    protected String context = "ice-default";
    protected int uniqueId = 1;
    protected String objectName = "ICE Object";
    protected String objectDescription = "ICE Object";
    protected ICEJAXBHandler jaxbManipulator;
    @XmlTransient
    protected ArrayList<IUpdateableListener> listeners = new ArrayList();

    @Override
    public void setId(int id) {
        if (id >= 0) {
            this.uniqueId = id;
            this.notifyListeners();
        }
    }

    @Override
    @XmlAttribute
    public int getId() {
        return this.uniqueId;
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            this.objectName = name;
            this.notifyListeners();
        }
    }

    @Override
    @XmlAttribute
    public String getName() {
        return this.objectName;
    }

    @Override
    public void setDescription(String description) {
        if (description != null) {
            this.objectDescription = description;
            this.notifyListeners();
        }
    }

    @Override
    @XmlAttribute
    public String getDescription() {
        return this.objectDescription;
    }

    public void copy(ICEObject entity) {
        if (entity == null) {
            return;
        }
        this.objectDescription = entity.objectDescription;
        this.objectName = entity.objectName;
        this.uniqueId = entity.uniqueId;
        this.context = entity.context;
    }

    protected void notifyListeners() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            Thread notifierThread = new Thread(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < ICEObject.this.listeners.size()) {
                        ICEObject.this.listeners.get(i).update(ICEObject.this);
                        ++i;
                    }
                }
            };
            notifierThread.start();
        }
    }

    @Override
    public Object clone() {
        ICEObject newObject = new ICEObject();
        newObject.copy(this);
        return newObject;
    }

    @Override
    public boolean equals(Object otherObject) {
        boolean retVal = false;
        ICEObject castedOtherObject = null;
        if (otherObject != null && otherObject instanceof ICEObject) {
            if (this == otherObject) {
                retVal = true;
            } else {
                castedOtherObject = (ICEObject)otherObject;
                retVal = this.uniqueId == castedOtherObject.uniqueId && this.objectName.equals(castedOtherObject.objectName) && this.objectDescription.equals(castedOtherObject.objectDescription) && this.context.equals(castedOtherObject.context);
            }
        }
        return retVal;
    }

    @Override
    public int hashCode() {
        int hash = 11;
        hash = 31 * hash + this.uniqueId;
        hash = 31 * hash + (this.objectName == null ? 0 : this.objectName.hashCode());
        hash = 31 * hash + (this.objectDescription == null ? 0 : this.objectDescription.hashCode());
        hash = 31 * hash + this.context.hashCode();
        return hash;
    }

    @Override
    public void update(String updatedKey, String newValue) {
    }

    @Override
    public void register(IUpdateableListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void unregister(IUpdateableListener listener) {
        if (listener != null && this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public void setContext(String context) {
        this.context = context;
    }
}

