/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.eclipse.january.dataset.IndexIterator;

public class ContiguousIteratorWithPosition
extends IndexIterator {
    private final int[] shape;
    private final int endrank;
    private final int imax;
    private final int istep;
    private final int[] pos;

    public ContiguousIteratorWithPosition(int[] shape, int length) {
        this(shape, length, 1);
    }

    public ContiguousIteratorWithPosition(int[] shape, int length, int isize) {
        this.shape = shape;
        this.endrank = this.shape.length - 1;
        this.istep = isize;
        if (shape.length == 0) {
            this.pos = new int[0];
        } else {
            this.pos = new int[this.endrank + 1];
            this.pos[this.endrank] = -1;
        }
        this.index = -isize;
        this.imax = length;
    }

    @Override
    public boolean hasNext() {
        int j = this.endrank;
        while (j >= 0) {
            int n = j;
            this.pos[n] = this.pos[n] + 1;
            if (this.pos[j] < this.shape[j]) break;
            this.pos[j] = 0;
            --j;
        }
        if (j == -1 && this.endrank >= 0) {
            this.index = this.imax;
            return false;
        }
        this.index += this.istep;
        return this.index < this.imax;
    }

    @Override
    public int[] getPos() {
        return this.pos;
    }

    @Override
    public void reset() {
        if (this.shape.length > 0) {
            Arrays.fill(this.pos, 0);
            this.pos[this.endrank] = -1;
        }
        this.index = -this.istep;
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }
}

