/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.geometry.util;

import java.util.ArrayList;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.january.geometry.GeometryFactory;
import org.eclipse.january.geometry.Triangle;
import org.eclipse.january.geometry.Vertex;

public class MeshUtils {
    public static double[] centerPoints(double[] points, Vertex center) {
        double[] centered = new double[points.length];
        int i = 0;
        while (i < points.length / 3) {
            centered[i * 3] = points[i * 3] + center.getX();
            centered[i * 3 + 1] = points[i * 3 + 1] + center.getY();
            centered[i * 3 + 2] = points[i * 3 + 2] + center.getZ();
            ++i;
        }
        return centered;
    }

    public static double[] createCircle(double radius, int samples) {
        double[] points = new double[samples * 2];
        double angle = 0.0;
        int i = 0;
        while (i < samples) {
            points[i * 2] = radius * Math.cos(angle);
            points[i * 2 + 1] = radius * Math.sin(angle);
            angle += (double)(2.0f / (float)samples) * Math.PI;
            ++i;
        }
        return points;
    }

    public static float[] createCircle(float radius, int samples) {
        float[] points = new float[samples * 2];
        float angle = 0.0f;
        int i = 0;
        while (i < samples) {
            points[i * 2] = (float)((double)radius * Math.cos(angle));
            points[i * 2 + 1] = (float)((double)radius * Math.sin(angle));
            angle = (float)((double)angle + (double)(2.0f / (float)samples) * Math.PI);
            ++i;
        }
        return points;
    }

    public static double[] createRectangularPrism(double lengthX, double lengthY, double lengthZ) {
        double[] points = new double[]{-lengthX / 2.0, -lengthY / 2.0, -lengthZ / 2.0, -lengthX / 2.0, -lengthY / 2.0, lengthZ / 2.0, -lengthX / 2.0, lengthY / 2.0, -lengthZ / 2.0, -lengthX / 2.0, lengthY / 2.0, lengthZ / 2.0, lengthX / 2.0, -lengthY / 2.0, -lengthZ / 2.0, lengthX / 2.0, -lengthY / 2.0, lengthZ / 2.0, lengthX / 2.0, lengthY / 2.0, -lengthZ / 2.0, lengthX / 2.0, lengthY / 2.0, lengthZ / 2.0};
        return points;
    }

    public static EList<Triangle> createRectangularPrismMesh(double[] points) {
        Vertex v0 = GeometryFactory.eINSTANCE.createVertex();
        v0.setX(points[0]);
        v0.setY(points[1]);
        v0.setZ(points[2]);
        Vertex v1 = GeometryFactory.eINSTANCE.createVertex();
        v1.setX(points[3]);
        v1.setY(points[4]);
        v1.setZ(points[5]);
        Vertex v2 = GeometryFactory.eINSTANCE.createVertex();
        v2.setX(points[6]);
        v2.setY(points[7]);
        v2.setZ(points[8]);
        Vertex v3 = GeometryFactory.eINSTANCE.createVertex();
        v3.setX(points[9]);
        v3.setY(points[10]);
        v3.setZ(points[11]);
        Vertex v4 = GeometryFactory.eINSTANCE.createVertex();
        v4.setX(points[12]);
        v4.setY(points[13]);
        v4.setZ(points[14]);
        Vertex v5 = GeometryFactory.eINSTANCE.createVertex();
        v5.setX(points[15]);
        v5.setY(points[16]);
        v5.setZ(points[17]);
        Vertex v6 = GeometryFactory.eINSTANCE.createVertex();
        v6.setX(points[18]);
        v6.setY(points[19]);
        v6.setZ(points[20]);
        Vertex v7 = GeometryFactory.eINSTANCE.createVertex();
        v7.setX(points[21]);
        v7.setY(points[22]);
        v7.setZ(points[23]);
        BasicEList triangles = new BasicEList();
        Triangle t0 = GeometryFactory.eINSTANCE.createTriangle();
        t0.getVertices().add((Object)((Vertex)v2.clone()));
        t0.getVertices().add((Object)((Vertex)v0.clone()));
        t0.getVertices().add((Object)((Vertex)v1.clone()));
        triangles.add((Object)t0);
        Triangle t1 = GeometryFactory.eINSTANCE.createTriangle();
        t1.getVertices().add((Object)((Vertex)v3.clone()));
        t1.getVertices().add((Object)((Vertex)v2.clone()));
        t1.getVertices().add((Object)((Vertex)v1.clone()));
        triangles.add((Object)t1);
        Triangle t2 = GeometryFactory.eINSTANCE.createTriangle();
        t2.getVertices().add((Object)((Vertex)v2.clone()));
        t2.getVertices().add((Object)((Vertex)v3.clone()));
        t2.getVertices().add((Object)((Vertex)v7.clone()));
        triangles.add((Object)t2);
        Triangle t3 = GeometryFactory.eINSTANCE.createTriangle();
        t3.getVertices().add((Object)((Vertex)v2.clone()));
        t3.getVertices().add((Object)((Vertex)v7.clone()));
        t3.getVertices().add((Object)((Vertex)v6.clone()));
        triangles.add((Object)t3);
        Triangle t4 = GeometryFactory.eINSTANCE.createTriangle();
        t4.getVertices().add((Object)((Vertex)v2.clone()));
        t4.getVertices().add((Object)((Vertex)v6.clone()));
        t4.getVertices().add((Object)((Vertex)v0.clone()));
        triangles.add((Object)t4);
        Triangle t5 = GeometryFactory.eINSTANCE.createTriangle();
        t5.getVertices().add((Object)((Vertex)v6.clone()));
        t5.getVertices().add((Object)((Vertex)v4.clone()));
        t5.getVertices().add((Object)((Vertex)v0.clone()));
        triangles.add((Object)t5);
        Triangle t6 = GeometryFactory.eINSTANCE.createTriangle();
        t6.getVertices().add((Object)((Vertex)v7.clone()));
        t6.getVertices().add((Object)((Vertex)v3.clone()));
        t6.getVertices().add((Object)((Vertex)v1.clone()));
        triangles.add((Object)t6);
        Triangle t7 = GeometryFactory.eINSTANCE.createTriangle();
        t7.getVertices().add((Object)((Vertex)v7.clone()));
        t7.getVertices().add((Object)((Vertex)v1.clone()));
        t7.getVertices().add((Object)((Vertex)v5.clone()));
        triangles.add((Object)t7);
        Triangle t8 = GeometryFactory.eINSTANCE.createTriangle();
        t8.getVertices().add((Object)((Vertex)v1.clone()));
        t8.getVertices().add((Object)((Vertex)v0.clone()));
        t8.getVertices().add((Object)((Vertex)v5.clone()));
        triangles.add((Object)t8);
        Triangle t9 = GeometryFactory.eINSTANCE.createTriangle();
        t9.getVertices().add((Object)((Vertex)v5.clone()));
        t9.getVertices().add((Object)((Vertex)v0.clone()));
        t9.getVertices().add((Object)((Vertex)v4.clone()));
        triangles.add((Object)t9);
        Triangle t10 = GeometryFactory.eINSTANCE.createTriangle();
        t10.getVertices().add((Object)((Vertex)v6.clone()));
        t10.getVertices().add((Object)((Vertex)v7.clone()));
        t10.getVertices().add((Object)((Vertex)v4.clone()));
        triangles.add((Object)t10);
        Triangle t11 = GeometryFactory.eINSTANCE.createTriangle();
        t11.getVertices().add((Object)((Vertex)v7.clone()));
        t11.getVertices().add((Object)((Vertex)v5.clone()));
        t11.getVertices().add((Object)((Vertex)v4.clone()));
        triangles.add((Object)t11);
        return triangles;
    }

    public static double[] createSemiCircle(double radius, int samples, boolean top) {
        double[] points = new double[samples * 2];
        double angle = 0.0;
        int i = 0;
        while (i < samples) {
            points[i * 2] = radius * Math.cos(angle);
            points[i * 2 + 1] = radius * Math.sin(angle);
            angle += (double)(1.0f / (float)(samples - 1)) * Math.PI;
            ++i;
        }
        return points;
    }

    public static double[] createTube(double height, double innerRadius, double radius, int resolution, int segments) {
        double[] points = innerRadius != radius ? new double[2 * resolution * (segments + 1) * 3] : new double[resolution * (segments + 1) * 3];
        double base = height / -2.0;
        double[] innerVertices = new double[resolution * 2];
        double[] outerVertices = new double[resolution * 2];
        innerVertices = MeshUtils.createCircle(innerRadius, resolution);
        outerVertices = MeshUtils.createCircle(radius, resolution);
        int i = 0;
        while (i <= segments) {
            int j = 0;
            while (j < resolution) {
                points[(i * resolution + j) * 3] = innerVertices[j * 2];
                points[(i * resolution + j) * 3 + 1] = base + (double)i * (height / (double)segments);
                points[(i * resolution + j) * 3 + 2] = innerVertices[j * 2 + 1];
                ++j;
            }
            ++i;
        }
        if (innerRadius == radius) {
            return points;
        }
        int cylinderSize = (segments + 1) * resolution * 3;
        int i2 = 0;
        while (i2 <= segments) {
            int j = 0;
            while (j < resolution) {
                points[cylinderSize + (i2 * resolution + j) * 3] = outerVertices[j * 2];
                points[cylinderSize + (i2 * resolution + j) * 3 + 1] = base + (double)i2 * (height / (double)segments);
                points[cylinderSize + (i2 * resolution + j) * 3 + 2] = outerVertices[j * 2 + 1];
                ++j;
            }
            ++i2;
        }
        return points;
    }

    public static EList<Triangle> createTubeMesh(double[] points, int resolution, int segments) {
        BasicEList triangles = new BasicEList();
        boolean complex = points.length > resolution * (segments + 1) * 3;
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        int i = 0;
        while (i < points.length / 3) {
            Vertex vertex = GeometryFactory.eINSTANCE.createVertex();
            vertex.setX(points[i * 3]);
            vertex.setY(points[i * 3 + 1]);
            vertex.setZ(points[i * 3 + 2]);
            vertices.add(vertex);
            ++i;
        }
        int vertexBlockSize = (segments + 1) * resolution;
        int axialSegment = 0;
        while (axialSegment < segments) {
            int radialSegment = 0;
            while (radialSegment < resolution) {
                Triangle innerTri0 = GeometryFactory.eINSTANCE.createTriangle();
                innerTri0.getVertices().add((Object)((Vertex)((Vertex)vertices.get(axialSegment * resolution + radialSegment)).clone()));
                innerTri0.getVertices().add((Object)((Vertex)((Vertex)vertices.get(axialSegment * resolution + (radialSegment + 1) % resolution)).clone()));
                innerTri0.getVertices().add((Object)((Vertex)((Vertex)vertices.get((axialSegment + 1) * resolution + (radialSegment + 1) % resolution)).clone()));
                triangles.add((Object)innerTri0);
                Triangle innerTri1 = GeometryFactory.eINSTANCE.createTriangle();
                innerTri1.getVertices().add((Object)((Vertex)((Vertex)vertices.get((axialSegment + 1) * resolution + (radialSegment + 1) % resolution)).clone()));
                innerTri1.getVertices().add((Object)((Vertex)((Vertex)vertices.get((axialSegment + 1) * resolution + radialSegment)).clone()));
                innerTri1.getVertices().add((Object)((Vertex)((Vertex)vertices.get(axialSegment * resolution + radialSegment)).clone()));
                triangles.add((Object)innerTri1);
                if (complex) {
                    Triangle outerTri0 = GeometryFactory.eINSTANCE.createTriangle();
                    outerTri0.getVertices().add((Object)((Vertex)((Vertex)vertices.get(vertexBlockSize + (axialSegment + 1) * resolution + (radialSegment + 1) % resolution)).clone()));
                    outerTri0.getVertices().add((Object)((Vertex)((Vertex)vertices.get(vertexBlockSize + axialSegment * resolution + (radialSegment + 1) % resolution)).clone()));
                    outerTri0.getVertices().add((Object)((Vertex)((Vertex)vertices.get(vertexBlockSize + axialSegment * resolution + radialSegment)).clone()));
                    triangles.add((Object)outerTri0);
                    Triangle outerTri1 = GeometryFactory.eINSTANCE.createTriangle();
                    outerTri1.getVertices().add((Object)((Vertex)((Vertex)vertices.get(vertexBlockSize + axialSegment * resolution + radialSegment)).clone()));
                    outerTri1.getVertices().add((Object)((Vertex)((Vertex)vertices.get(vertexBlockSize + (axialSegment + 1) * resolution + radialSegment)).clone()));
                    outerTri1.getVertices().add((Object)((Vertex)((Vertex)vertices.get(vertexBlockSize + (axialSegment + 1) * resolution + (radialSegment + 1) % resolution)).clone()));
                    triangles.add((Object)outerTri1);
                }
                ++radialSegment;
            }
            if (complex) {
                radialSegment = 0;
                while (radialSegment < resolution) {
                    Triangle bottomTri0 = GeometryFactory.eINSTANCE.createTriangle();
                    bottomTri0.getVertices().add((Object)((Vertex)((Vertex)vertices.get(vertexBlockSize + (radialSegment + 1) % resolution)).clone()));
                    bottomTri0.getVertices().add((Object)((Vertex)((Vertex)vertices.get((radialSegment + 1) % resolution)).clone()));
                    bottomTri0.getVertices().add((Object)((Vertex)((Vertex)vertices.get(radialSegment)).clone()));
                    triangles.add((Object)bottomTri0);
                    Triangle bottomTri1 = GeometryFactory.eINSTANCE.createTriangle();
                    bottomTri1.getVertices().add((Object)((Vertex)((Vertex)vertices.get(segments * resolution + radialSegment)).clone()));
                    bottomTri1.getVertices().add((Object)((Vertex)((Vertex)vertices.get(segments * resolution + (radialSegment + 1) % resolution)).clone()));
                    bottomTri1.getVertices().add((Object)((Vertex)((Vertex)vertices.get(segments * resolution + vertexBlockSize + (radialSegment + 1) % resolution)).clone()));
                    triangles.add((Object)bottomTri1);
                    Triangle topTri0 = GeometryFactory.eINSTANCE.createTriangle();
                    topTri0.getVertices().add((Object)((Vertex)((Vertex)vertices.get(radialSegment)).clone()));
                    topTri0.getVertices().add((Object)((Vertex)((Vertex)vertices.get(vertexBlockSize + radialSegment)).clone()));
                    topTri0.getVertices().add((Object)((Vertex)((Vertex)vertices.get(vertexBlockSize + (radialSegment + 1) % resolution)).clone()));
                    triangles.add((Object)topTri0);
                    Triangle topTri1 = GeometryFactory.eINSTANCE.createTriangle();
                    topTri1.getVertices().add((Object)((Vertex)((Vertex)vertices.get(segments * resolution + vertexBlockSize + (radialSegment + 1) % resolution)).clone()));
                    topTri1.getVertices().add((Object)((Vertex)((Vertex)vertices.get(segments * resolution + vertexBlockSize + radialSegment)).clone()));
                    topTri1.getVertices().add((Object)((Vertex)((Vertex)vertices.get(segments * resolution + radialSegment)).clone()));
                    triangles.add((Object)topTri1);
                    ++radialSegment;
                }
            }
            ++axialSegment;
        }
        return triangles;
    }

    public static double[] rotatePoints(double[] points, double rotationX, double rotationY, double rotationZ) {
        double[] rotated = new double[points.length];
        int i = 0;
        while (i < points.length / 3) {
            double x = points[i * 3];
            double y = points[i * 3 + 1];
            double z = points[i * 3 + 2];
            double tempY = x * Math.sin(rotationZ) + y * Math.cos(rotationZ);
            x = x * Math.cos(rotationZ) - y * Math.sin(rotationZ);
            y = tempY;
            double tempX = z * Math.sin(rotationY) + x * Math.cos(rotationY);
            z = z * Math.cos(rotationY) - x * Math.sin(rotationY);
            rotated[i * 3] = tempX;
            tempY = y * Math.cos(rotationX) - z * Math.sin(rotationX);
            rotated[i * 3 + 2] = y * Math.sin(rotationX) + z * Math.cos(rotationX);
            rotated[i * 3 + 1] = tempY;
            ++i;
        }
        return rotated;
    }

    public static double[] rotatePointsAboutAxis(double[] points, Vertex axis, double magnitude) {
        double[] rotated = new double[points.length];
        double[][] matrix = new double[3][3];
        double x = axis.getX();
        double y = axis.getY();
        double z = axis.getZ();
        double vectorLength = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0));
        double sin = Math.sin(magnitude);
        double cos = Math.cos(magnitude);
        double inverseCos = 1.0 - Math.cos(magnitude);
        matrix[0][0] = cos + Math.pow(x /= vectorLength, 2.0) * inverseCos;
        matrix[0][1] = x * (y /= vectorLength) * inverseCos - (z /= vectorLength) * sin;
        matrix[0][2] = x * z * inverseCos + y * sin;
        matrix[1][0] = y * x * inverseCos + z * sin;
        matrix[1][1] = cos + Math.pow(y, 2.0) * inverseCos;
        matrix[1][2] = y * z * inverseCos - x * sin;
        matrix[2][0] = x * z * inverseCos - y * sin;
        matrix[2][1] = z * y * inverseCos + x * sin;
        matrix[2][2] = cos + Math.pow(z, 2.0) * inverseCos;
        int i = 0;
        while (i < points.length / 3) {
            rotated[i * 3] = points[i * 3] * matrix[0][0] + points[i * 3 + 1] * matrix[0][1] + points[i * 3 + 2] * matrix[0][2];
            rotated[i * 3 + 1] = points[i * 3] * matrix[1][0] + points[i * 3 + 1] * matrix[1][1] + points[i * 3 + 2] * matrix[1][2];
            rotated[i * 3 + 2] = points[i * 3] * matrix[2][0] + points[i * 3 + 1] * matrix[2][1] + points[i * 3 + 2] * matrix[2][2];
            ++i;
        }
        return rotated;
    }
}

