/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.january.dataset.AbstractDataset;
import org.eclipse.january.dataset.BooleanIterator;
import org.eclipse.january.dataset.BroadcastSelfIterator;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerIterator;
import org.eclipse.january.dataset.IntegersIterator;
import org.eclipse.january.dataset.PositionIterator;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceIterator;
import org.eclipse.january.dataset.StringDataset;
import org.eclipse.january.metadata.StatisticsMetadata;

public class StringDatasetBase
extends AbstractDataset {
    private static final long serialVersionUID = -6891075135217265625L;
    protected String[] data;

    @Override
    protected void setData() {
        this.data = (String[])this.odata;
    }

    protected static String[] createArray(int size) {
        String[] array = null;
        try {
            array = new String[size];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("The size of the dataset ({}) that is being created is too large and there is not enough memory to hold it.", (Object)size);
            throw new OutOfMemoryError("The dimensions given are too large, and there is not enough memory available in the Java Virtual Machine");
        }
        return array;
    }

    @Override
    public int getDType() {
        return 9;
    }

    StringDatasetBase() {
    }

    StringDatasetBase(int ... shape) {
        if (shape != null) {
            this.size = ShapeUtils.calcSize(shape);
            this.shape = (int[])shape.clone();
            try {
                this.data = StringDatasetBase.createArray(this.size);
                this.odata = this.data;
            }
            catch (Throwable t) {
                logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(shape), (Object)t);
                throw new IllegalArgumentException(t);
            }
        }
    }

    StringDatasetBase(String[] data, int ... shape) {
        if (data == null) {
            throw new IllegalArgumentException("Data must not be null");
        }
        if (shape == null || shape.length == 0) {
            shape = new int[]{data.length};
        }
        this.size = ShapeUtils.calcSize(shape);
        if (this.size != data.length) {
            throw new IllegalArgumentException(String.format("Shape %s is not compatible with size of data array, %d", Arrays.toString(shape), data.length));
        }
        this.shape = this.size == 0 ? null : (int[])shape.clone();
        this.data = data;
        this.odata = data;
    }

    StringDatasetBase(StringDatasetBase dataset) {
        StringDatasetBase.copyToView(dataset, this, true, true);
        try {
            if (dataset.stride == null) {
                this.data = (String[])dataset.data.clone();
                this.odata = this.data;
            } else {
                this.offset = 0;
                this.stride = null;
                this.base = null;
                this.data = StringDatasetBase.createArray(this.size);
                this.odata = this.data;
                IndexIterator iter = dataset.getIterator();
                int i = 0;
                while (iter.hasNext()) {
                    this.data[i] = dataset.data[iter.index];
                    ++i;
                }
            }
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
    }

    StringDatasetBase(Dataset dataset) {
        StringDatasetBase.copyToView(dataset, this, true, false);
        this.offset = 0;
        this.stride = null;
        this.base = null;
        try {
            this.data = StringDatasetBase.createArray(this.size);
            this.odata = this.data;
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        IndexIterator iter = dataset.getIterator();
        int i = 0;
        while (iter.hasNext()) {
            this.data[i] = dataset.getStringAbs(iter.index);
            ++i;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getRank() == 0 && !this.getClass().equals(obj.getClass())) {
            return true;
        }
        StringDatasetBase other = (StringDatasetBase)obj;
        IndexIterator iter = this.getIterator();
        IndexIterator oiter = other.getIterator();
        while (iter.hasNext() && oiter.hasNext()) {
            if (this.data[iter.index].equals(other.data[oiter.index])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public StringDatasetBase clone() {
        return new StringDatasetBase(this);
    }

    static StringDatasetBase createFromObject(Object obj) {
        StringDatasetBase result = new StringDatasetBase();
        if (obj != null) {
            result.shape = ShapeUtils.getShapeFromObject(obj);
            result.size = ShapeUtils.calcSize(result.shape);
            try {
                result.data = StringDatasetBase.createArray(result.size);
                result.odata = result.data;
            }
            catch (Throwable t) {
                logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(result.shape), (Object)t);
                throw new IllegalArgumentException(t);
            }
            int[] pos = new int[result.shape.length];
            result.fillData(obj, 0, pos);
        }
        return result;
    }

    static StringDatasetBase ones(int ... shape) {
        return new StringDatasetBase(shape).fill(1);
    }

    @Override
    public StringDatasetBase fill(Object obj) {
        this.setDirty();
        String dv = obj.toString();
        IndexIterator iter = this.getIterator();
        while (iter.hasNext()) {
            this.data[iter.index] = dv;
        }
        return this;
    }

    public String[] getData() {
        return this.data;
    }

    @Override
    protected int getBufferLength() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    @Override
    public StringDatasetBase getView(boolean deepCopyMetadata) {
        StringDatasetBase view = new StringDatasetBase();
        StringDatasetBase.copyToView(this, view, true, deepCopyMetadata);
        view.setData();
        return view;
    }

    public String getAbs(int index) {
        return this.data[index];
    }

    @Override
    public boolean getElementBooleanAbs(int index) {
        return false;
    }

    @Override
    public double getElementDoubleAbs(int index) {
        return 0.0;
    }

    @Override
    public long getElementLongAbs(int index) {
        return 0L;
    }

    @Override
    public Object getObjectAbs(int index) {
        return this.data[index];
    }

    @Override
    public String getStringAbs(int index) {
        return this.stringFormat == null ? this.data[index] : this.stringFormat.format(this.data[index]);
    }

    public void setAbs(int index, String val) {
        this.setDirty();
        this.data[index] = val;
    }

    @Override
    protected void setItemDirect(int dindex, int sindex, Object src) {
        this.setDirty();
        String[] dsrc = (String[])src;
        this.data[dindex] = dsrc[sindex];
    }

    @Override
    public void setObjectAbs(int index, Object obj) {
        if (index < 0 || index > this.data.length) {
            throw new IndexOutOfBoundsException("Index given is outside dataset");
        }
        this.setAbs(index, obj.toString());
    }

    public String get() {
        return this.data[this.getFirst1DIndex()];
    }

    public String get(int i) {
        return this.data[this.get1DIndex(i)];
    }

    public String get(int i, int j) {
        return this.data[this.get1DIndex(i, j)];
    }

    public String get(int ... pos) {
        return this.data[this.get1DIndex(pos)];
    }

    @Override
    public Object getObject() {
        return this.get();
    }

    @Override
    public Object getObject(int i) {
        return this.get(i);
    }

    @Override
    public Object getObject(int i, int j) {
        return this.get(i, j);
    }

    @Override
    public Object getObject(int ... pos) {
        return this.get(pos);
    }

    @Override
    public String getString() {
        return this.getStringAbs(this.getFirst1DIndex());
    }

    @Override
    public String getString(int i) {
        return this.getStringAbs(this.get1DIndex(i));
    }

    @Override
    public String getString(int i, int j) {
        return this.getStringAbs(this.get1DIndex(i, j));
    }

    @Override
    public String getString(int ... pos) {
        return this.getStringAbs(this.get1DIndex(pos));
    }

    @Override
    public double getDouble() {
        return 0.0;
    }

    @Override
    public double getDouble(int i) {
        return 0.0;
    }

    @Override
    public double getDouble(int i, int j) {
        return 0.0;
    }

    @Override
    public double getDouble(int ... pos) {
        return 0.0;
    }

    @Override
    public float getFloat() {
        return 0.0f;
    }

    @Override
    public float getFloat(int i) {
        return 0.0f;
    }

    @Override
    public float getFloat(int i, int j) {
        return 0.0f;
    }

    @Override
    public float getFloat(int ... pos) {
        return 0.0f;
    }

    @Override
    public long getLong() {
        return 0L;
    }

    @Override
    public long getLong(int i) {
        return 0L;
    }

    @Override
    public long getLong(int i, int j) {
        return 0L;
    }

    @Override
    public long getLong(int ... pos) {
        return 0L;
    }

    @Override
    public int getInt() {
        return 0;
    }

    @Override
    public int getInt(int i) {
        return 0;
    }

    @Override
    public int getInt(int i, int j) {
        return 0;
    }

    @Override
    public int getInt(int ... pos) {
        return 0;
    }

    @Override
    public short getShort() {
        return 0;
    }

    @Override
    public short getShort(int i) {
        return 0;
    }

    @Override
    public short getShort(int i, int j) {
        return 0;
    }

    @Override
    public short getShort(int ... pos) {
        return 0;
    }

    @Override
    public byte getByte() {
        return 0;
    }

    @Override
    public byte getByte(int i) {
        return 0;
    }

    @Override
    public byte getByte(int i, int j) {
        return 0;
    }

    @Override
    public byte getByte(int ... pos) {
        return 0;
    }

    @Override
    public boolean getBoolean() {
        return false;
    }

    @Override
    public boolean getBoolean(int i) {
        return false;
    }

    @Override
    public boolean getBoolean(int i, int j) {
        return false;
    }

    @Override
    public boolean getBoolean(int ... pos) {
        return false;
    }

    public void setItem(String value) {
        this.setAbs(this.getFirst1DIndex(), value);
    }

    public void setItem(String value, int i) {
        this.setAbs(this.get1DIndex(i), value);
    }

    public void setItem(String value, int i, int j) {
        this.setAbs(this.get1DIndex(i, j), value);
    }

    public void setItem(String value, int ... pos) {
        this.setAbs(this.get1DIndex(pos), value);
    }

    @Override
    public void set(Object obj) {
        this.setItem(obj.toString());
    }

    @Override
    public void set(Object obj, int i) {
        this.setItem(obj.toString(), i);
    }

    @Override
    public void set(Object obj, int i, int j) {
        this.setItem(obj.toString(), i, j);
    }

    @Override
    public void set(Object obj, int ... pos) {
        if (pos == null || pos.length == 0 && this.shape.length > 0) {
            pos = new int[this.shape.length];
        }
        this.setItem(obj.toString(), pos);
    }

    @Override
    public void resize(int ... newShape) {
        String[] ndata;
        this.setDirty();
        IndexIterator iter = this.getIterator();
        int nsize = ShapeUtils.calcSize(newShape);
        try {
            ndata = StringDatasetBase.createArray(nsize);
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        int i = 0;
        while (iter.hasNext() && i < nsize) {
            ndata[i] = this.data[iter.index];
            ++i;
        }
        this.data = ndata;
        this.odata = ndata;
        this.size = nsize;
        this.shape = newShape;
        this.stride = null;
        this.offset = 0;
        this.base = null;
    }

    @Override
    public StringDatasetBase sort(Integer axis) {
        this.setDirty();
        if (axis == null) {
            if (this.stride == null) {
                Arrays.sort(this.data);
            } else {
                StringDatasetBase ads = this.clone().sort(null);
                this.setSlicedView(this.getView(false), ads);
            }
        } else {
            axis = this.checkAxis(axis);
            StringDatasetBase ads = new StringDatasetBase(this.shape[axis]);
            PositionIterator pi = this.getPositionIterator(axis);
            int[] pos = pi.getPos();
            boolean[] hit = pi.getOmit();
            while (pi.hasNext()) {
                this.copyItemsFromAxes(pos, hit, ads);
                Arrays.sort(ads.data);
                this.setItemsOnAxes(pos, hit, ads.data);
            }
        }
        return this;
    }

    @Override
    public StringDatasetBase getUniqueItems() {
        TreeSet<String> set = new TreeSet<String>();
        IndexIterator it = this.getIterator();
        while (it.hasNext()) {
            set.add(this.data[it.index]);
        }
        StringDataset u = new StringDataset(set.size());
        int i = 0;
        String[] udata = u.getData();
        for (String v : set) {
            udata[i++] = v;
        }
        return u;
    }

    @Override
    public StringDatasetBase getSlice(SliceIterator siter) {
        StringDatasetBase result = new StringDatasetBase(siter.getShape());
        String[] rdata = result.data;
        int i = 0;
        while (siter.hasNext()) {
            rdata[i] = this.data[siter.index];
            ++i;
        }
        result.setName(String.valueOf(this.name) + '[' + Slice.createString(siter.shape, siter.start, siter.stop, siter.step) + ']');
        return result;
    }

    @Override
    public void fillDataset(Dataset result, IndexIterator iter) {
        this.setDirty();
        IndexIterator riter = result.getIterator();
        String[] rdata = ((StringDatasetBase)result).data;
        while (riter.hasNext() && iter.hasNext()) {
            rdata[riter.index] = this.data[iter.index];
        }
    }

    @Override
    public StringDatasetBase setByBoolean(Object obj, Dataset selection) {
        this.setDirty();
        if (obj instanceof Dataset) {
            Dataset ds = (Dataset)obj;
            int length = ((Number)selection.sum(new boolean[0])).intValue();
            if (length != ds.getSize()) {
                throw new IllegalArgumentException("Number of true items in selection does not match number of items in dataset");
            }
            IndexIterator oiter = ds.getIterator();
            BooleanIterator biter = this.getBooleanIterator(selection);
            while (biter.hasNext() && oiter.hasNext()) {
                this.data[biter.index] = ds.getStringAbs(oiter.index);
            }
        } else {
            String dv = obj.toString();
            BooleanIterator biter = this.getBooleanIterator(selection);
            while (biter.hasNext()) {
                this.data[biter.index] = dv;
            }
        }
        return this;
    }

    @Override
    public StringDatasetBase setBy1DIndex(Object obj, Dataset index) {
        this.setDirty();
        if (obj instanceof Dataset) {
            Dataset ds = (Dataset)obj;
            if (index.getSize() != ds.getSize()) {
                throw new IllegalArgumentException("Number of items in index dataset does not match number of items in dataset");
            }
            IndexIterator oiter = ds.getIterator();
            IntegerIterator iter = new IntegerIterator(index, this.size);
            while (iter.hasNext() && oiter.hasNext()) {
                this.data[iter.index] = ds.getStringAbs(oiter.index);
            }
        } else {
            String dv = obj.toString();
            IntegerIterator iter = new IntegerIterator(index, this.size);
            while (iter.hasNext()) {
                this.data[iter.index] = dv;
            }
        }
        return this;
    }

    @Override
    public StringDatasetBase setByIndexes(Object obj, Object ... indexes) {
        this.setDirty();
        IntegersIterator iter = new IntegersIterator(this.shape, indexes);
        int[] pos = iter.getPos();
        if (obj instanceof Dataset) {
            Dataset ds = (Dataset)obj;
            if (ShapeUtils.calcSize(iter.getShape()) != ds.getSize()) {
                throw new IllegalArgumentException("Number of items in index datasets does not match number of items in dataset");
            }
            IndexIterator oiter = ds.getIterator();
            while (iter.hasNext() && oiter.hasNext()) {
                this.setItem(ds.getStringAbs(oiter.index), pos);
            }
        } else {
            String dv = obj.toString();
            while (iter.hasNext()) {
                this.setItem(dv, pos);
            }
        }
        return this;
    }

    @Override
    StringDatasetBase setSlicedView(Dataset view, Dataset d) {
        this.setDirty();
        BroadcastSelfIterator it = BroadcastSelfIterator.createIterator(view, d);
        while (it.hasNext()) {
            this.data[it.aIndex] = d.getStringAbs(it.bIndex);
        }
        return this;
    }

    @Override
    public StringDatasetBase setSlice(Object obj, IndexIterator siter) {
        this.setDirty();
        if (obj instanceof IDataset) {
            IDataset ds = (IDataset)obj;
            int[] oshape = ds.getShape();
            if (!ShapeUtils.areShapesCompatible(siter.getShape(), oshape)) {
                throw new IllegalArgumentException(String.format("Input dataset is not compatible with slice: %s cf %s", Arrays.toString(oshape), Arrays.toString(siter.getShape())));
            }
            if (ds instanceof Dataset) {
                Dataset ads = (Dataset)ds;
                IndexIterator oiter = ads.getIterator();
                while (siter.hasNext() && oiter.hasNext()) {
                    this.data[siter.index] = ads.getStringAbs(oiter.index);
                }
            } else {
                PositionIterator oiter = new PositionIterator(oshape);
                int[] pos = ((IndexIterator)oiter).getPos();
                while (siter.hasNext() && ((IndexIterator)oiter).hasNext()) {
                    this.data[siter.index] = ds.getString(pos);
                }
            }
        } else {
            try {
                String v = obj.toString();
                while (siter.hasNext()) {
                    this.data[siter.index] = v;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Object for setting slice is not a dataset or number");
            }
        }
        return this;
    }

    @Override
    public void copyItemsFromAxes(int[] pos, boolean[] axes, Dataset dest) {
        String[] ddata = (String[])dest.getBuffer();
        SliceIterator siter = this.getSliceIteratorFromAxes(pos, axes);
        int[] sshape = ShapeUtils.squeezeShape(siter.getShape(), false);
        IndexIterator diter = dest.getSliceIterator(null, sshape, null);
        if (ddata.length < ShapeUtils.calcSize(sshape)) {
            throw new IllegalArgumentException("destination array is not large enough");
        }
        dest.setDirty();
        while (siter.hasNext() && diter.hasNext()) {
            ddata[diter.index] = this.data[siter.index];
        }
    }

    @Override
    public void setItemsOnAxes(int[] pos, boolean[] axes, Object src) {
        this.setDirty();
        String[] sdata = (String[])src;
        SliceIterator siter = this.getSliceIteratorFromAxes(pos, axes);
        if (sdata.length < ShapeUtils.calcSize(siter.getShape())) {
            throw new IllegalArgumentException("destination array is not large enough");
        }
        int i = 0;
        while (siter.hasNext()) {
            this.data[siter.index] = sdata[i];
            ++i;
        }
    }

    private List<int[]> findPositions(String value) {
        IndexIterator iter = this.getIterator(true);
        ArrayList<int[]> posns = new ArrayList<int[]>();
        int[] pos = iter.getPos();
        while (iter.hasNext()) {
            if (this.data[iter.index] != value) continue;
            posns.add((int[])pos.clone());
        }
        return posns;
    }

    @Override
    public int[] maxPos(boolean ... ignoreInvalids) {
        StatisticsMetadata<String> md = this.getStringStats();
        List<int[]> max = md.getMaximumPositions(ignoreInvalids);
        if (max == null) {
            max = this.findPositions(md.getMaximum(ignoreInvalids).toString());
            md.setMaximumPositions(max, new boolean[0]);
        }
        return max.get(0);
    }

    @Override
    public int[] minPos(boolean ... ignoreInvalids) {
        StatisticsMetadata<String> md = this.getStringStats();
        List<int[]> min = md.getMinimumPositions(ignoreInvalids);
        if (min == null) {
            min = this.findPositions(md.getMinimum(ignoreInvalids).toString());
            md.setMinimumPositions(min, new boolean[0]);
        }
        return min.get(0);
    }

    @Override
    public boolean containsNans() {
        return false;
    }

    @Override
    public boolean containsInfs() {
        return false;
    }

    @Override
    public boolean containsInvalidNumbers() {
        return false;
    }

    @Override
    public StringDatasetBase iadd(Object b) {
        return this;
    }

    @Override
    public StringDatasetBase isubtract(Object b) {
        return this;
    }

    @Override
    public StringDatasetBase imultiply(Object b) {
        return this;
    }

    @Override
    public StringDatasetBase idivide(Object b) {
        return this;
    }

    @Override
    public StringDatasetBase ifloor() {
        return this;
    }

    @Override
    public StringDatasetBase iremainder(Object b) {
        return this;
    }

    @Override
    public StringDatasetBase ipower(Object b) {
        return this;
    }

    @Override
    public double residual(Object b, Dataset w, boolean ignoreNaNs) {
        double sum = 0.0;
        return sum;
    }
}

