/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.BooleanDataset;
import org.eclipse.january.dataset.Comparisons;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IDataset;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ComparisonsTest {
    Dataset a;
    Dataset b;
    Dataset z;

    @Before
    public void setUpClass() {
        this.a = DatasetFactory.createFromObject((Object)new double[]{0.0, 1.0, 3.0, 5.0, -7.0, -9.0});
        this.b = DatasetFactory.createFromObject((Object)new double[]{0.01, 1.2, 2.9, 5.0, -7.1, -9.0});
        this.z = DatasetFactory.createFromObject(ComplexDoubleDataset.class, (Object)new double[]{0.01, 1.2, 2.5, 5.0, -7.1, -9.0, 2.5, 0.0}, (int[])new int[0]);
    }

    @Test
    public void testEqualTo() {
        BooleanDataset c = Comparisons.equalTo((Object)this.a, (Object)this.b);
        boolean[] blArray = new boolean[6];
        blArray[3] = true;
        blArray[5] = true;
        BooleanDataset d = (BooleanDataset)DatasetFactory.createFromObject(BooleanDataset.class, (Object)blArray, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)c, (Dataset)d);
        boolean[] blArray2 = new boolean[6];
        blArray2[2] = true;
        TestUtils.assertDatasetEquals((Dataset)Comparisons.equalTo((Object)3, (Object)this.a), (Dataset)DatasetFactory.createFromObject((Object)blArray2));
        DoubleDataset ta = (DoubleDataset)DatasetFactory.zeros(DoubleDataset.class, (int[])new int[]{20, 10});
        ta.fill((Object)Double.NaN);
        DoubleDataset tb = (DoubleDataset)DatasetFactory.zeros(DoubleDataset.class, (int[])new int[]{20, 10});
        tb.fill((Object)Double.NaN);
        BooleanDataset bd = (BooleanDataset)DatasetFactory.zeros(BooleanDataset.class, (int[])ta.getShape());
        bd.fill((Object)Boolean.FALSE);
        TestUtils.assertDatasetEquals((Dataset)Comparisons.equalTo((Object)ta, (Object)tb), (Dataset)bd);
        ta.fill((Object)Double.POSITIVE_INFINITY);
        tb.fill((Object)Double.POSITIVE_INFINITY);
        bd.fill((Object)Boolean.TRUE);
        TestUtils.assertDatasetEquals((Dataset)Comparisons.equalTo((Object)ta, (Object)tb), (Dataset)bd);
        c = Comparisons.equalTo((Object)((DoubleDataset)DatasetFactory.zeros(DoubleDataset.class, (int[])new int[0])).fill((Object)1), (Object)1);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new boolean[]{true}), (Dataset)c);
        c = Comparisons.equalTo((Object)this.a, (Object)3);
        boolean[] blArray3 = new boolean[6];
        blArray3[2] = true;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)blArray3), (Dataset)c);
        c = Comparisons.equalTo((Object)3, (Object)this.a);
        boolean[] blArray4 = new boolean[6];
        blArray4[2] = true;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)blArray4), (Dataset)c);
        c = Comparisons.equalTo((Object)this.z, (Object)2.5);
        boolean[] blArray5 = new boolean[4];
        blArray5[3] = true;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)blArray5), (Dataset)c);
        c = Comparisons.equalTo((Object)2.5, (Object)this.z);
        boolean[] blArray6 = new boolean[4];
        blArray6[3] = true;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)blArray6), (Dataset)c);
    }

    @Test
    public void testAlmostEqualTo() {
        BooleanDataset c = Comparisons.almostEqualTo((Object)this.a, (Object)this.b, (double)0.1, (double)0.001);
        boolean[] blArray = new boolean[6];
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        BooleanDataset d = (BooleanDataset)DatasetFactory.createFromObject(BooleanDataset.class, (Object)blArray, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)d, (Dataset)c);
        boolean[] blArray2 = new boolean[6];
        blArray2[2] = true;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)blArray2), (Dataset)Comparisons.almostEqualTo((Object)this.a, (Object)3, (double)0.1, (double)0.001));
        boolean[] blArray3 = new boolean[6];
        blArray3[2] = true;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)blArray3), (Dataset)Comparisons.almostEqualTo((Object)3, (Object)this.a, (double)0.1, (double)0.001));
        c = Comparisons.almostEqualTo((Object)this.z, (Object)2.5, (double)0.1, (double)0.001);
        boolean[] blArray4 = new boolean[4];
        blArray4[3] = true;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)blArray4), (Dataset)c);
    }

    @Test
    public void testAllCloseTo() {
        Assert.assertFalse((boolean)Comparisons.allCloseTo((Object)this.a, (Object)this.b, (double)0.1, (double)0.001));
        Assert.assertTrue((boolean)Comparisons.allCloseTo((Object)this.a, (Object)this.b, (double)0.1, (double)0.2));
        Assert.assertFalse((boolean)Comparisons.allCloseTo((Object)this.z, (Object)2.5, (double)0.1, (double)0.001));
        Assert.assertFalse((boolean)Comparisons.allCloseTo((Object)2.5, (Object)this.z, (double)0.1, (double)0.001));
    }

    @Test
    public void testGreaterThan() {
        BooleanDataset c = Comparisons.greaterThan((Object)this.a, (Object)this.b);
        boolean[] blArray = new boolean[6];
        blArray[2] = true;
        blArray[4] = true;
        BooleanDataset d = (BooleanDataset)DatasetFactory.createFromObject(BooleanDataset.class, (Object)blArray, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)d, (Dataset)c);
        boolean[] blArray2 = new boolean[6];
        blArray2[0] = true;
        blArray2[1] = true;
        blArray2[4] = true;
        blArray2[5] = true;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)blArray2), (Dataset)Comparisons.greaterThan((Object)3, (Object)this.a));
        boolean[] blArray3 = new boolean[6];
        blArray3[3] = true;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)blArray3), (Dataset)Comparisons.greaterThan((Object)this.a, (Object)3));
    }

    @Test
    public void testGreaterThanOrEqualTo() {
        BooleanDataset c = Comparisons.greaterThanOrEqualTo((Object)this.a, (Object)this.b);
        boolean[] blArray = new boolean[6];
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        BooleanDataset d = (BooleanDataset)DatasetFactory.createFromObject(BooleanDataset.class, (Object)blArray, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)d, (Dataset)c);
        boolean[] blArray2 = new boolean[6];
        blArray2[0] = true;
        blArray2[1] = true;
        blArray2[2] = true;
        blArray2[4] = true;
        blArray2[5] = true;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)blArray2), (Dataset)Comparisons.greaterThanOrEqualTo((Object)3, (Object)this.a));
        boolean[] blArray3 = new boolean[6];
        blArray3[2] = true;
        blArray3[3] = true;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)blArray3), (Dataset)Comparisons.greaterThanOrEqualTo((Object)this.a, (Object)3));
    }

    @Test
    public void testLessThan() {
        BooleanDataset c = Comparisons.lessThan((Object)this.a, (Object)this.b);
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        blArray[1] = true;
        BooleanDataset d = (BooleanDataset)DatasetFactory.createFromObject(BooleanDataset.class, (Object)blArray, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)d, (Dataset)c);
        boolean[] blArray2 = new boolean[6];
        blArray2[3] = true;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)blArray2), (Dataset)Comparisons.lessThan((Object)3, (Object)this.a));
        boolean[] blArray3 = new boolean[6];
        blArray3[0] = true;
        blArray3[1] = true;
        blArray3[4] = true;
        blArray3[5] = true;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)blArray3), (Dataset)Comparisons.lessThan((Object)this.a, (Object)3));
    }

    @Test
    public void testLessThanOrEqualTo() {
        BooleanDataset c = Comparisons.lessThanOrEqualTo((Object)this.a, (Object)this.b);
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        blArray[1] = true;
        blArray[3] = true;
        blArray[5] = true;
        BooleanDataset d = (BooleanDataset)DatasetFactory.createFromObject(BooleanDataset.class, (Object)blArray, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)d, (Dataset)c);
        boolean[] blArray2 = new boolean[6];
        blArray2[2] = true;
        blArray2[3] = true;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)blArray2), (Dataset)Comparisons.lessThanOrEqualTo((Object)3, (Object)this.a));
        boolean[] blArray3 = new boolean[6];
        blArray3[0] = true;
        blArray3[1] = true;
        blArray3[2] = true;
        blArray3[4] = true;
        blArray3[5] = true;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)blArray3), (Dataset)Comparisons.lessThanOrEqualTo((Object)this.a, (Object)3));
    }

    @Test
    public void testWithinRange() {
        BooleanDataset c = Comparisons.withinRange((Object)this.b, (Number)-8, (Number)2);
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        blArray[1] = true;
        blArray[4] = true;
        BooleanDataset d = (BooleanDataset)DatasetFactory.createFromObject(BooleanDataset.class, (Object)blArray, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)d, (Dataset)c);
    }

    @Test
    public void testAllTrue() {
        Assert.assertFalse((boolean)Comparisons.allTrue((Object)this.a));
        Assert.assertTrue((boolean)Comparisons.allTrue((Object)this.b));
        Dataset c = this.a.clone().reshape(new int[]{2, 3});
        boolean[] blArray = new boolean[3];
        blArray[1] = true;
        blArray[2] = true;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)blArray), (Dataset)Comparisons.allTrue((IDataset)c, (int)0));
        Dataset d = this.b.clone().reshape(new int[]{2, 3});
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new boolean[]{true, true}), (Dataset)Comparisons.allTrue((IDataset)d, (int)1));
    }

    @Test
    public void testAnyTrue() {
        Assert.assertTrue((boolean)Comparisons.anyTrue((Object)this.a));
        Assert.assertTrue((boolean)Comparisons.anyTrue((Object)this.b));
        Assert.assertFalse((boolean)Comparisons.anyTrue((Object)DatasetFactory.createFromObject((Object)new double[]{0.0, 0.0})));
        Dataset c = this.a.clone().reshape(new int[]{2, 3});
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new boolean[]{true, true, true}), (Dataset)Comparisons.anyTrue((IDataset)c, (int)0));
        Dataset d = this.b.clone().reshape(new int[]{2, 3});
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new boolean[]{true, true}), (Dataset)Comparisons.anyTrue((IDataset)d, (int)1));
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)blArray), (Dataset)Comparisons.anyTrue((IDataset)DatasetFactory.createFromObject((Object)new double[]{0.0, 0.0, 0.0, 1.0}).reshape(new int[]{2, 2}), (int)1));
    }

    @Test
    public void testNot() {
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)blArray), (Dataset)Comparisons.logicalNot((Object)this.a));
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new boolean[6]), (Dataset)Comparisons.logicalNot((Object)this.b));
    }

    @Test
    public void testAnd() {
        BooleanDataset c = Comparisons.logicalAnd((Object)this.a, (Object)this.b);
        boolean[] blArray = new boolean[6];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        BooleanDataset d = (BooleanDataset)DatasetFactory.createFromObject(BooleanDataset.class, (Object)blArray, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)d, (Dataset)c);
    }

    @Test
    public void testOr() {
        BooleanDataset c = Comparisons.logicalOr((Object)this.a, (Object)this.b);
        BooleanDataset d = (BooleanDataset)DatasetFactory.createFromObject(BooleanDataset.class, (Object)new boolean[]{true, true, true, true, true, true}, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)d, (Dataset)c);
    }

    @Test
    public void testXor() {
        BooleanDataset c = Comparisons.logicalXor((Object)this.a, (Object)this.b);
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        BooleanDataset d = (BooleanDataset)DatasetFactory.createFromObject(BooleanDataset.class, (Object)blArray, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)d, (Dataset)c);
    }

    @Test
    public void testNonZero() {
        Dataset c = this.a.clone().reshape(new int[]{2, 3});
        List e = Comparisons.nonZero((Dataset)c);
        int[] nArray = new int[5];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        TestUtils.assertDatasetEquals((Dataset)((Dataset)e.get(0)), (Dataset)DatasetFactory.createFromObject((Object)nArray));
        int[] nArray2 = new int[5];
        nArray2[0] = 1;
        nArray2[1] = 2;
        nArray2[3] = 1;
        nArray2[4] = 2;
        TestUtils.assertDatasetEquals((Dataset)((Dataset)e.get(1)), (Dataset)DatasetFactory.createFromObject((Object)nArray2));
    }

    @Test
    public void testNoNonZeros() {
        Dataset c = DatasetFactory.createFromObject((Object)new byte[6]).reshape(new int[]{2, 3});
        List e = Comparisons.nonZero((Dataset)c);
        Assert.assertEquals((long)e.size(), (long)2L);
        Dataset empty = DatasetFactory.createFromList((int)3, new ArrayList());
        TestUtils.assertDatasetEquals((Dataset)((Dataset)e.get(0)), (Dataset)empty);
        TestUtils.assertDatasetEquals((Dataset)((Dataset)e.get(1)), (Dataset)empty);
    }

    @Test
    public void testFlags() {
        int[] nArray = new int[3];
        nArray[1] = -1;
        nArray[2] = 1;
        Dataset c = DatasetFactory.createFromObject((Object)nArray);
        TestUtils.assertDatasetEquals((Dataset)Comparisons.isFinite((Object)c), (Dataset)DatasetFactory.createFromObject((Object)new boolean[]{true, true, true}));
        TestUtils.assertDatasetEquals((Dataset)Comparisons.isInfinite((Object)c), (Dataset)DatasetFactory.createFromObject((Object)new boolean[3]));
        TestUtils.assertDatasetEquals((Dataset)Comparisons.isPositiveInfinite((Object)c), (Dataset)DatasetFactory.createFromObject((Object)new boolean[3]));
        TestUtils.assertDatasetEquals((Dataset)Comparisons.isNegativeInfinite((Object)c), (Dataset)DatasetFactory.createFromObject((Object)new boolean[3]));
        TestUtils.assertDatasetEquals((Dataset)Comparisons.isNaN((Object)c), (Dataset)DatasetFactory.createFromObject((Object)new boolean[3]));
        c = DatasetFactory.createFromObject((Object)new double[]{0.0, -1.0, 1.0});
        TestUtils.assertDatasetEquals((Dataset)Comparisons.isFinite((Object)c), (Dataset)DatasetFactory.createFromObject((Object)new boolean[]{true, true, true}));
        TestUtils.assertDatasetEquals((Dataset)Comparisons.isInfinite((Object)c), (Dataset)DatasetFactory.createFromObject((Object)new boolean[3]));
        TestUtils.assertDatasetEquals((Dataset)Comparisons.isPositiveInfinite((Object)c), (Dataset)DatasetFactory.createFromObject((Object)new boolean[3]));
        TestUtils.assertDatasetEquals((Dataset)Comparisons.isNegativeInfinite((Object)c), (Dataset)DatasetFactory.createFromObject((Object)new boolean[3]));
        TestUtils.assertDatasetEquals((Dataset)Comparisons.isNaN((Object)c), (Dataset)DatasetFactory.createFromObject((Object)new boolean[3]));
        c = DatasetFactory.createFromObject((Object)new double[]{Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY});
        TestUtils.assertDatasetEquals((Dataset)Comparisons.isFinite((Object)c), (Dataset)DatasetFactory.createFromObject((Object)new boolean[3]));
        boolean[] blArray = new boolean[3];
        blArray[1] = true;
        blArray[2] = true;
        TestUtils.assertDatasetEquals((Dataset)Comparisons.isInfinite((Object)c), (Dataset)DatasetFactory.createFromObject((Object)blArray));
        boolean[] blArray2 = new boolean[3];
        blArray2[2] = true;
        TestUtils.assertDatasetEquals((Dataset)Comparisons.isPositiveInfinite((Object)c), (Dataset)DatasetFactory.createFromObject((Object)blArray2));
        boolean[] blArray3 = new boolean[3];
        blArray3[1] = true;
        TestUtils.assertDatasetEquals((Dataset)Comparisons.isNegativeInfinite((Object)c), (Dataset)DatasetFactory.createFromObject((Object)blArray3));
        boolean[] blArray4 = new boolean[3];
        blArray4[0] = true;
        TestUtils.assertDatasetEquals((Dataset)Comparisons.isNaN((Object)c), (Dataset)DatasetFactory.createFromObject((Object)blArray4));
        c = DatasetFactory.createFromObject((Object)new double[]{Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY});
        TestUtils.assertDatasetEquals((Dataset)Comparisons.isFinite((Object)c), (Dataset)DatasetFactory.createFromObject((Object)new boolean[3]));
        boolean[] blArray5 = new boolean[3];
        blArray5[1] = true;
        blArray5[2] = true;
        TestUtils.assertDatasetEquals((Dataset)Comparisons.isInfinite((Object)c), (Dataset)DatasetFactory.createFromObject((Object)blArray5));
        boolean[] blArray6 = new boolean[3];
        blArray6[2] = true;
        TestUtils.assertDatasetEquals((Dataset)Comparisons.isPositiveInfinite((Object)c), (Dataset)DatasetFactory.createFromObject((Object)blArray6));
        boolean[] blArray7 = new boolean[3];
        blArray7[1] = true;
        TestUtils.assertDatasetEquals((Dataset)Comparisons.isNegativeInfinite((Object)c), (Dataset)DatasetFactory.createFromObject((Object)blArray7));
        boolean[] blArray8 = new boolean[3];
        blArray8[0] = true;
        TestUtils.assertDatasetEquals((Dataset)Comparisons.isNaN((Object)c), (Dataset)DatasetFactory.createFromObject((Object)blArray8));
    }

    @Test
    public void testNans() {
        double n = Double.NaN;
        double[] a = new double[]{-4.34, -1.34, 21.34};
        double l = -2.0;
        double h = 15.4;
        double[] dArray = a;
        int n2 = a.length;
        int n3 = 0;
        while (n3 < n2) {
            double x = dArray[n3];
            System.err.println(String.valueOf(x >= l && x <= h) + "\t" + (x <= h) + " = " + ((Double.isNaN(n) || x >= n) && x <= h) + "\t" + (x >= l) + " = " + (x >= l && (Double.isNaN(n) || x <= n)) + "\t" + (x >= n && x <= n));
            ++n3;
        }
        System.err.println(Double.isNaN(n));
        System.err.println(Float.isNaN((float)n));
        float f = Float.NaN;
        System.err.println(Double.isNaN(f));
    }

    @Test
    public void testIsMonotonic() {
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)1));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)Double.NaN));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)Double.POSITIVE_INFINITY));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)new double[]{Double.NaN, Double.NaN}));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)new double[]{Double.NaN, Double.POSITIVE_INFINITY}));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY}));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)new double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY}));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)new double[]{Double.NaN, Double.NaN, Double.NaN}));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)new double[]{Double.NaN, Double.NaN, Double.POSITIVE_INFINITY}));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)new double[]{Double.NaN, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)new double[]{Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY}));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)new double[]{Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY}));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)new double[]{Double.POSITIVE_INFINITY, Double.NaN, Double.NaN}));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)new double[]{Double.POSITIVE_INFINITY, Double.NaN, Double.POSITIVE_INFINITY}));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY}));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY}));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)new double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY}));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)new double[]{0.0, 1.0, 1.0, 2.0, 6.0, Double.NaN, Double.POSITIVE_INFINITY}));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)new double[]{0.0, -1.0, -1.0, -2.0, -6.0, Double.NaN, Double.NEGATIVE_INFINITY}));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)new double[]{0.0, 1.0, 0.5, 2.0, 6.0, Double.NaN, Double.POSITIVE_INFINITY}));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)new double[]{0.0, 0.0, -1.0, -0.2, -6.0, Double.NaN, Double.NEGATIVE_INFINITY}));
        Assert.assertFalse((boolean)Comparisons.isStrictlyMonotonic((Object)new double[]{0.0, 1.0, 1.0, 2.0, 6.0, Double.NaN, Double.POSITIVE_INFINITY}));
        Assert.assertFalse((boolean)Comparisons.isStrictlyMonotonic((Object)new double[]{0.0, 0.0, -1.0, -2.0, -6.0, Double.NaN, Double.NEGATIVE_INFINITY}));
        Assert.assertTrue((boolean)Comparisons.isStrictlyMonotonic((Object)new double[]{0.0, 1.0, 1.5, 2.0, 6.0, Double.NaN, Double.POSITIVE_INFINITY}));
        Assert.assertTrue((boolean)Comparisons.isStrictlyMonotonic((Object)new double[]{0.5, 0.0, -1.0, -2.0, -6.0, Double.NaN, Double.NEGATIVE_INFINITY}));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)1, (Comparisons.Monotonicity)Comparisons.Monotonicity.NOT_ORDERED));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)1, (Comparisons.Monotonicity)Comparisons.Monotonicity.ALL_EQUAL));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)1, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_DECREASING));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)1, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONINCREASING));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)1, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONDECREASING));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)1, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_INCREASING));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)Double.NaN, (Comparisons.Monotonicity)Comparisons.Monotonicity.NOT_ORDERED));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)Double.NaN, (Comparisons.Monotonicity)Comparisons.Monotonicity.ALL_EQUAL));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)Double.NaN, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_DECREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)Double.NaN, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONINCREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)Double.NaN, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONDECREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)Double.NaN, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_INCREASING));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)Double.POSITIVE_INFINITY, (Comparisons.Monotonicity)Comparisons.Monotonicity.NOT_ORDERED));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)Double.POSITIVE_INFINITY, (Comparisons.Monotonicity)Comparisons.Monotonicity.ALL_EQUAL));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)Double.POSITIVE_INFINITY, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_DECREASING));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)Double.POSITIVE_INFINITY, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONINCREASING));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)Double.POSITIVE_INFINITY, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONDECREASING));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)Double.POSITIVE_INFINITY, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_INCREASING));
        double[] x = new double[]{0.0, 1.0, 1.5, 2.0, 6.0, Double.NaN, Double.POSITIVE_INFINITY};
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_INCREASING));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONDECREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.NOT_ORDERED));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.ALL_EQUAL));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_DECREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONINCREASING));
        x = new double[]{0.0, 1.0, 1.0, 2.0, 6.0, Double.NaN, Double.POSITIVE_INFINITY};
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONDECREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.NOT_ORDERED));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.ALL_EQUAL));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_DECREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONINCREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_INCREASING));
        x = new double[]{0.0, -1.0, -1.0, -2.0, -6.0, Double.NaN, Double.NEGATIVE_INFINITY};
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONINCREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.NOT_ORDERED));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.ALL_EQUAL));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_DECREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONDECREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_INCREASING));
        x = new double[]{0.0, -1.0, -1.5, -2.0, -6.0, Double.NaN, Double.NEGATIVE_INFINITY};
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_DECREASING));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONINCREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.NOT_ORDERED));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.ALL_EQUAL));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONDECREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_INCREASING));
        x = new double[]{0.0, 1.0, 0.5, 2.0, 6.0, Double.NaN, Double.POSITIVE_INFINITY};
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.NOT_ORDERED));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.ALL_EQUAL));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_DECREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONINCREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONDECREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_INCREASING));
        x = new double[]{0.0, -1.0, 1.5, -2.0, -6.0, Double.NaN, Double.NEGATIVE_INFINITY};
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.NOT_ORDERED));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.ALL_EQUAL));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_DECREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONINCREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONDECREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_INCREASING));
        x = new double[]{1.0, 1.0, Double.NaN};
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.ALL_EQUAL));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONINCREASING));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONDECREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.NOT_ORDERED));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_DECREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)x, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_INCREASING));
        Dataset d = DatasetFactory.createRange((double)5.0, (int)3);
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)d, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONDECREASING));
        Assert.assertTrue((boolean)Comparisons.isMonotonic((Object)d, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_INCREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)d, (Comparisons.Monotonicity)Comparisons.Monotonicity.NOT_ORDERED));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)d, (Comparisons.Monotonicity)Comparisons.Monotonicity.ALL_EQUAL));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)d, (Comparisons.Monotonicity)Comparisons.Monotonicity.STRICTLY_DECREASING));
        Assert.assertFalse((boolean)Comparisons.isMonotonic((Object)d, (Comparisons.Monotonicity)Comparisons.Monotonicity.NONINCREASING));
    }
}

