/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.metadata.internal;

import java.io.Serializable;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.Maths;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.metadata.AxesMetadata;
import org.eclipse.january.metadata.ErrorMetadata;
import org.eclipse.january.metadata.MetadataType;
import org.eclipse.january.metadata.Reshapeable;
import org.eclipse.january.metadata.Sliceable;
import org.eclipse.january.metadata.Transposable;

public class ErrorMetadataImpl
implements ErrorMetadata,
Serializable {
    private static final long serialVersionUID = -4365046277441185058L;
    @Transposable
    @Sliceable
    @Reshapeable
    private ILazyDataset error = null;
    @Transposable
    @Sliceable
    @Reshapeable
    private transient ILazyDataset sqError = null;

    public ErrorMetadataImpl() {
    }

    @Override
    public void initialize() {
    }

    private ErrorMetadataImpl(ErrorMetadataImpl error) {
        this.error = error.error == null ? null : error.error.getSliceView(new Slice[0]);
        this.sqError = error.sqError == null ? null : error.sqError.getSliceView(new Slice[0]);
    }

    @Override
    public MetadataType clone() {
        return new ErrorMetadataImpl(this);
    }

    @Override
    public ILazyDataset getError() {
        return this.error;
    }

    @Override
    public void setError(ILazyDataset error) {
        this.error = this.sanitizeErrorData(error);
        this.sqError = null;
    }

    public Dataset getSquaredError() {
        if (this.sqError == null) {
            this.sqError = this.error instanceof IDataset ? Maths.square(this.error) : null;
        }
        return (Dataset)this.sqError;
    }

    public void setSquaredError(IDataset sqErrors) {
        ILazyDataset se = this.sanitizeErrorData(sqErrors);
        if (se instanceof IDataset) {
            this.sqError = DatasetUtils.convertToDataset((IDataset)se);
            if (this.sqError != null) {
                this.error = Maths.sqrt(this.sqError);
            }
        }
    }

    private ILazyDataset sanitizeErrorData(ILazyDataset errorData) {
        if (errorData == null) {
            return null;
        }
        ILazyDataset view = errorData.getSliceView(new Slice[0]);
        view.clearMetadata(AxesMetadata.class);
        return view;
    }

    public String toString() {
        if (this.error != null) {
            return this.error.toString();
        }
        if (this.sqError != null) {
            return this.sqError.toString();
        }
        return null;
    }
}

