/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.CompoundByteDataset;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.CompoundFloatDataset;
import org.eclipse.january.dataset.CompoundIntegerDataset;
import org.eclipse.january.dataset.CompoundLongDataset;
import org.eclipse.january.dataset.CompoundShortDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.Maths;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MathsArrayTypeAbsFunctionParameterizeTest {
    @Parameterized.Parameter
    public Class<? extends CompoundDataset> classType;
    private static final double ABSERRD = 1.0E-8;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object> data() {
        return Arrays.asList(CompoundFloatDataset.class, CompoundDoubleDataset.class, CompoundByteDataset.class, CompoundShortDataset.class, CompoundIntegerDataset.class, CompoundLongDataset.class);
    }

    @Test
    public void test() throws Exception {
        Class<? extends CompoundDataset> class1 = this.classType;
        byte[] byArray = new byte[15];
        byArray[1] = 8;
        byArray[2] = -1;
        byArray[3] = 2;
        byArray[4] = 3;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 41;
        byArray[8] = 7;
        byArray[9] = 95;
        byArray[10] = 8;
        byArray[11] = -74;
        byArray[12] = 9;
        byArray[13] = 41;
        byArray[14] = 11;
        byte[] ba = byArray;
        Dataset a = DatasetFactory.createFromObject((Object)ba);
        CompoundDataset input = DatasetUtils.createCompoundDataset(class1, (Dataset[])new Dataset[]{a});
        int size = a.getSize();
        double[] c = new double[size];
        int i = 0;
        while (i < size) {
            double abs;
            c[i] = abs = (double)Math.abs(ba[i]);
            ++i;
        }
        CompoundDataset expectedResult = DatasetUtils.createCompoundDataset(class1, (Dataset[])new Dataset[]{DatasetFactory.createFromObject((Object)c)});
        CompoundDataset output = DatasetUtils.createCompoundDataset(class1, (Dataset[])new Dataset[]{DatasetFactory.createFromObject((Object)new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f})});
        Dataset actual = Maths.abs((Object)input, (Dataset)output);
        CompoundDataset actualResult = DatasetUtils.createCompoundDataset((Dataset[])new Dataset[]{actual});
        System.out.println(expectedResult.toString(true));
        System.out.println(actualResult.toString(true));
        TestUtils.assertDatasetEquals((Dataset)expectedResult, (Dataset)actualResult, (boolean)true, (double)1.0E-8, (double)1.0E-8);
    }
}

