/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerDataset;

public class IntegerIterator
extends IndexIterator {
    private final IntegerDataset indices;
    private final IndexIterator iter;
    private final int istep;
    private final int imax;

    public IntegerIterator(Dataset index, int length) {
        this(index, length, 1);
    }

    public IntegerIterator(Dataset index, int length, int isize) {
        this.indices = DatasetUtils.convertToDataset(index).cast(IntegerDataset.class);
        this.iter = index.getIterator();
        this.istep = isize;
        this.imax = length * this.istep;
    }

    @Override
    public boolean hasNext() {
        if (this.iter.hasNext()) {
            this.index = this.istep * this.indices.getAbs(this.iter.index);
            if (this.index < 0) {
                this.index += this.imax;
            }
            return true;
        }
        return false;
    }

    @Override
    public int[] getPos() {
        return null;
    }

    @Override
    public void reset() {
        this.iter.reset();
    }
}

