/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceIterator;
import org.eclipse.january.dataset.StrideIterator;
import org.junit.Assert;
import org.junit.Test;

public class StrideIteratorTest {
    @Test
    public void testIterations() {
        int size = 1024;
        this.testIterationsND(size, DoubleDataset.class);
        this.testIterationsND(size, ComplexDoubleDataset.class);
    }

    @Test
    public void testZeroSizedIteration() {
        DoubleDataset ta = DatasetFactory.zeros((int[])new int[]{4, 4, 4});
        int[] nArray = new int[3];
        nArray[0] = 4;
        nArray[2] = 4;
        IndexIterator it = ta.getSliceView(null, nArray, null).getIterator();
        Assert.assertFalse((boolean)it.hasNext());
        int[] nArray2 = new int[3];
        nArray2[0] = 4;
        nArray2[2] = 4;
        it = new StrideIterator(nArray2);
        Assert.assertFalse((boolean)it.hasNext());
    }

    private void testIterationsND(int size, Class<? extends Dataset> clazz) {
        TestUtils.verbosePrintf((String)"Size: %d\n", (Object[])new Object[]{size});
        Dataset ta = DatasetFactory.zeros(clazz, (int[])new int[0]);
        this.testDataset(ta);
        ta = DatasetFactory.createRange(clazz, (double)0.0, (double)size, (double)1.0);
        this.testDataset(ta);
        ta = DatasetFactory.createRange(clazz, (double)0.0, (double)size, (double)1.0).reshape(new int[]{16, size / 16});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShapeRef())});
        this.testDataset(ta);
        ta = DatasetFactory.createRange(clazz, (double)0.0, (double)size, (double)1.0).reshape(new int[]{size / 32, 32});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShapeRef())});
        this.testDataset(ta);
        ta = DatasetFactory.createRange(clazz, (double)0.0, (double)size, (double)1.0).reshape(new int[]{16, 8, size / 128});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShapeRef())});
        this.testDataset(ta);
        ta = DatasetFactory.createRange(clazz, (double)0.0, (double)size, (double)1.0).reshape(new int[]{size / 128, 16, 8});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShapeRef())});
        this.testDataset(ta);
    }

    private void testDataset(Dataset ta) {
        StrideIterator iter = new StrideIterator(ta.getElementsPerItem(), ta.getShapeRef());
        double[] data = (double[])ta.getBuffer();
        int size = ta.getSize();
        int i = 0;
        while (iter.hasNext()) {
            Assert.assertEquals((double)i, (double)data[iter.index], (double)(1.0E-5 * (double)i));
            ++i;
        }
        Assert.assertEquals((long)size, (long)i);
        iter.reset();
        i = 0;
        while (iter.hasNext()) {
            Assert.assertEquals((double)i, (double)data[iter.index], (double)(1.0E-5 * (double)i));
            ++i;
        }
        Assert.assertEquals((long)size, (long)i);
        iter = ta.getIterator(true);
        int[] pos = iter.getPos();
        i = 0;
        while (iter.hasNext()) {
            Assert.assertEquals((double)i, (double)ta.getDouble(pos), (double)(1.0E-5 * (double)i));
            ++i;
        }
        Assert.assertEquals((long)size, (long)i);
        iter.reset();
        i = 0;
        while (iter.hasNext()) {
            Assert.assertEquals((double)i, (double)ta.getDouble(pos), (double)(1.0E-5 * (double)i));
            ++i;
        }
        Assert.assertEquals((long)size, (long)i);
    }

    private Dataset oldSlice(Dataset t, SliceIterator siter) {
        int j;
        int[] shape = siter.getShape();
        int rank = shape.length;
        int[] lstart = siter.getStart();
        int[] lstep = siter.getStep();
        DoubleDataset result = DatasetFactory.zeros((int[])shape);
        int[] relative = new int[rank];
        int[] absolute = new int[rank];
        int i = 0;
        while (i < rank) {
            relative[i] = lstart[i];
            absolute[i] = 0;
            ++i;
        }
        block1: do {
            result.set((Object)t.getDouble(relative), absolute);
            j = rank - 1;
            while (j >= 0) {
                int n = j;
                relative[n] = relative[n] + lstep[j];
                int n2 = j;
                absolute[n2] = absolute[n2] + 1;
                if (absolute[j] < shape[j]) continue block1;
                relative[j] = lstart[j];
                absolute[j] = 0;
                --j;
            }
        } while (j != -1);
        return result;
    }

    private void timeOldSlice(SliceIterator siter) {
        int j;
        int[] shape = siter.getShape();
        int rank = shape.length;
        int[] lstart = siter.getStart();
        int[] lstep = siter.getStep();
        int[] relative = new int[rank];
        int[] absolute = new int[rank];
        int i = 0;
        while (i < rank) {
            relative[i] = lstart[i];
            absolute[i] = 0;
            ++i;
        }
        block1: do {
            j = rank - 1;
            while (j >= 0) {
                int n = j;
                relative[n] = relative[n] + lstep[j];
                int n2 = j;
                absolute[n2] = absolute[n2] + 1;
                if (absolute[j] < shape[j]) continue block1;
                relative[j] = lstart[j];
                absolute[j] = 0;
                --j;
            }
        } while (j != -1);
    }

    private Dataset newSlice(Dataset t, int[] start, int[] stop, int[] step) {
        StrideIterator iter = new StrideIterator(t.getElementsPerItem(), t.getShapeRef(), start, stop, step);
        DoubleDataset result = DatasetFactory.zeros((int[])iter.getShape());
        int i = 0;
        while (iter.hasNext()) {
            result.setObjectAbs(i++, (Object)t.getElementDoubleAbs(iter.index));
        }
        return result;
    }

    private void timeNewSlice(Dataset t, int[] start, int[] stop, int[] step) {
        StrideIterator iter = new StrideIterator(t.getElementsPerItem(), t.getShapeRef(), start, stop, step);
        while (iter.hasNext()) {
        }
    }

    private void timeCurrentSlice(Dataset t, int[] start, int[] stop, int[] step) {
        IndexIterator iter = t.getSliceIterator(start, stop, step);
        while (iter.hasNext()) {
        }
    }

    private void testSlicedDataset(Dataset t, int start, int startaxis, int step, int stepaxis) {
        long stime;
        int rank = t.getRank();
        int[] steps = new int[rank];
        int[] starts = new int[rank];
        Arrays.fill(steps, 1);
        while (stepaxis > rank) {
            stepaxis -= rank;
        }
        if (stepaxis < 0) {
            stepaxis += rank;
        }
        steps[stepaxis] = step;
        while (startaxis > rank) {
            startaxis -= rank;
        }
        if (startaxis < 0) {
            startaxis += rank;
        }
        starts[startaxis] = start;
        int nloop = 7;
        ArrayList<Long> elapsed = new ArrayList<Long>();
        Dataset sliced = null;
        SliceIterator siter = (SliceIterator)t.getSliceIterator(starts, null, steps);
        sliced = this.oldSlice(t, siter);
        TestUtils.verbosePrintf((String)"  Slicing : %d@%d, %d@%d\n", (Object[])new Object[]{start, startaxis, step, stepaxis});
        TestUtils.verbosePrintf((String)"  Sliced shape: %s\n", (Object[])new Object[]{Arrays.toString(sliced.getShape())});
        elapsed.clear();
        int i = 0;
        while (i < nloop) {
            stime = System.nanoTime();
            this.timeOldSlice(siter);
            elapsed.add(System.nanoTime() - stime);
            ++i;
        }
        Collections.sort(elapsed);
        TestUtils.verbosePrintf((String)"    old  %5.2fus\n", (Object[])new Object[]{(double)((Long)elapsed.get(0)).longValue() * 0.001});
        Dataset nsliced = null;
        elapsed.clear();
        int i2 = 0;
        while (i2 < nloop) {
            stime = System.nanoTime();
            this.timeCurrentSlice(t, starts, null, steps);
            elapsed.add(System.nanoTime() - stime);
            ++i2;
        }
        Collections.sort(elapsed);
        TestUtils.verbosePrintf((String)"    iter %5.2fus\n", (Object[])new Object[]{(double)((Long)elapsed.get(0)).longValue() * 0.001});
        double current = ((Long)elapsed.get(0)).longValue();
        nsliced = this.newSlice(t, starts, null, steps);
        elapsed.clear();
        int i3 = 0;
        while (i3 < nloop) {
            stime = System.nanoTime();
            this.timeNewSlice(t, starts, null, steps);
            elapsed.add(System.nanoTime() - stime);
            ++i3;
        }
        Collections.sort(elapsed);
        TestUtils.verbosePrintf((String)"    strides %5.2fus (%.2f)\n", (Object[])new Object[]{(double)((Long)elapsed.get(0)).longValue() * 0.001, (double)((Long)elapsed.get(0)).longValue() / current});
        this.checkSliced(sliced, nsliced);
    }

    private void checkSliced(Dataset sliced, Dataset nsliced) {
        double[] ndata = (double[])nsliced.getBuffer();
        IndexIterator iter = nsliced.getIterator();
        double[] sdata = (double[])sliced.getBuffer();
        int n = 0;
        int isize = sliced.getElementsPerItem();
        int i = 0;
        while (i < sdata.length && iter.hasNext()) {
            int j = 0;
            while (j < isize) {
                Assert.assertEquals((double)sdata[i], (double)ndata[iter.index + j], (double)(1.0E-5 * sdata[i]));
                ++i;
                ++j;
                ++n;
            }
        }
        Assert.assertEquals((String)"Size of dataset slice is incorrect", (long)sdata.length, (long)n);
    }

    @Test
    public void testNegativeStrideIteration() {
        DoubleDataset t = DatasetFactory.createRange((double)40.0);
        SliceIterator siter = (SliceIterator)t.getSliceIterator(new int[]{12}, null, new int[]{-2});
        Dataset sliced = this.oldSlice((Dataset)t, siter);
        Dataset nsliced = this.newSlice((Dataset)t, new int[]{12}, null, new int[]{-2});
        this.checkSliced(sliced, nsliced);
        t.setShape(new int[]{8, 5});
        sliced = this.oldSlice((Dataset)t, (SliceIterator)t.getSliceIterator(new int[]{1, 3}, null, new int[]{2, -2}));
        nsliced = this.newSlice((Dataset)t, new int[]{1, 3}, null, new int[]{2, -2});
        this.checkSliced(sliced, nsliced);
        sliced = this.oldSlice((Dataset)t, (SliceIterator)t.getSliceIterator(new int[]{7, 4}, null, new int[]{-1, -1}));
        nsliced = this.newSlice((Dataset)t, new int[]{7, 4}, null, new int[]{-1, -1});
        this.checkSliced(sliced, nsliced);
    }

    @Test
    public void testSliceIteration() {
        int size = 6000;
        this.testSliceIterationND(size, DoubleDataset.class);
        this.testSliceIterationND(size, ComplexDoubleDataset.class);
    }

    private void testSliceIterationND(int size, Class<? extends Dataset> clazz) {
        TestUtils.verbosePrintf((String)" Size: %d\n", (Object[])new Object[]{size});
        Dataset ta = DatasetFactory.createRange(clazz, (double)0.0, (double)size, (double)1.0);
        this.testSlicedDataset(ta, 0, 0, 3, 0);
        this.testSlicedDataset(ta, 0, 0, 62, 0);
        this.testSlicedDataset(ta, 23, 0, 3, 0);
        this.testSlicedDataset(ta, 23, 0, 62, 0);
        this.testSlicedDataset(ta, -3, 0, -2, 0);
        ta = DatasetFactory.createRange(clazz, (double)0.0, (double)size, (double)1.0).reshape(new int[]{size / 15, 15});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShapeRef())});
        this.testSlicedDataset(ta, 0, 0, 3, 0);
        this.testSlicedDataset(ta, 0, 0, 3, 1);
        this.testSlicedDataset(ta, 2, 0, 3, 0);
        this.testSlicedDataset(ta, 2, 0, 3, 1);
        this.testSlicedDataset(ta, 3, 1, 3, 0);
        this.testSlicedDataset(ta, 3, 1, 3, 1);
        this.testSlicedDataset(ta, 0, 0, 4, 0);
        this.testSlicedDataset(ta, 0, 0, 4, 1);
        this.testSlicedDataset(ta, 2, 0, 4, 0);
        this.testSlicedDataset(ta, 2, 0, 4, 1);
        this.testSlicedDataset(ta, 3, 1, 4, 0);
        this.testSlicedDataset(ta, 3, 1, 4, 1);
        this.testSlicedDataset(ta, 0, 0, -1, 0);
        this.testSlicedDataset(ta, 0, 0, -1, 1);
        this.testSlicedDataset(ta, 2, 0, -1, 0);
        this.testSlicedDataset(ta, 2, 0, -1, 1);
        this.testSlicedDataset(ta, 3, 1, -1, 0);
        this.testSlicedDataset(ta, 3, 1, -1, 1);
        this.testSlicedDataset(ta, 0, 0, -2, 0);
        this.testSlicedDataset(ta, 0, 0, -2, 1);
        this.testSlicedDataset(ta, 2, 0, -2, 0);
        this.testSlicedDataset(ta, 2, 0, -2, 1);
        this.testSlicedDataset(ta, 3, 1, -2, 0);
        this.testSlicedDataset(ta, 3, 1, -2, 1);
        this.testSlicedDataset(ta, 0, 0, -3, 0);
        this.testSlicedDataset(ta, 0, 0, -3, 1);
        this.testSlicedDataset(ta, 2, 0, -3, 0);
        this.testSlicedDataset(ta, 2, 0, -3, 1);
        this.testSlicedDataset(ta, 3, 1, -3, 0);
        this.testSlicedDataset(ta, 3, 1, -3, 1);
        this.testSlicedDataset(ta, 8, 0, -3, 0);
        this.testSlicedDataset(ta, 8, 1, -3, 1);
        ta = DatasetFactory.createRange(clazz, (double)0.0, (double)size, (double)1.0).reshape(new int[]{size / 10, 2, 5});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShapeRef())});
        this.testSlicedDataset(ta, 0, 0, 3, 0);
        this.testSlicedDataset(ta, 0, 0, 3, 1);
        this.testSlicedDataset(ta, 0, 0, 3, 2);
        this.testSlicedDataset(ta, 3, 0, 3, 0);
        this.testSlicedDataset(ta, 3, 0, 3, 1);
        this.testSlicedDataset(ta, 3, 0, 3, 2);
        this.testSlicedDataset(ta, 1, 1, 3, 0);
        this.testSlicedDataset(ta, 1, 1, 3, 1);
        this.testSlicedDataset(ta, 1, 1, 3, 2);
        this.testSlicedDataset(ta, 2, 2, 3, 0);
        this.testSlicedDataset(ta, 2, 2, 3, 1);
        this.testSlicedDataset(ta, 2, 2, 3, 2);
        this.testSlicedDataset(ta, 0, 0, 4, 0);
        this.testSlicedDataset(ta, 0, 0, 4, 1);
        this.testSlicedDataset(ta, 0, 0, 4, 2);
        this.testSlicedDataset(ta, 3, 0, 4, 0);
        this.testSlicedDataset(ta, 3, 0, 4, 1);
        this.testSlicedDataset(ta, 3, 0, 4, 2);
        this.testSlicedDataset(ta, 1, 1, 4, 0);
        this.testSlicedDataset(ta, 1, 1, 4, 1);
        this.testSlicedDataset(ta, 1, 1, 4, 2);
        this.testSlicedDataset(ta, 2, 2, 4, 0);
        this.testSlicedDataset(ta, 2, 2, 4, 1);
        this.testSlicedDataset(ta, 2, 2, 4, 2);
        this.testSlicedDataset(ta, 0, 0, -1, 0);
        this.testSlicedDataset(ta, 0, 0, -1, 1);
        this.testSlicedDataset(ta, 0, 0, -1, 2);
        this.testSlicedDataset(ta, 3, 0, -1, 0);
        this.testSlicedDataset(ta, 3, 0, -1, 1);
        this.testSlicedDataset(ta, 3, 0, -1, 2);
        this.testSlicedDataset(ta, 1, 1, -1, 0);
        this.testSlicedDataset(ta, 1, 1, -1, 1);
        this.testSlicedDataset(ta, 1, 1, -1, 2);
        this.testSlicedDataset(ta, 2, 2, -1, 0);
        this.testSlicedDataset(ta, 2, 2, -1, 1);
        this.testSlicedDataset(ta, 2, 2, -1, 2);
        this.testSlicedDataset(ta, 0, 0, -2, 0);
        this.testSlicedDataset(ta, 0, 0, -2, 1);
        this.testSlicedDataset(ta, 0, 0, -2, 2);
        this.testSlicedDataset(ta, 3, 0, -2, 0);
        this.testSlicedDataset(ta, 3, 0, -2, 1);
        this.testSlicedDataset(ta, 3, 0, -2, 2);
        this.testSlicedDataset(ta, 1, 1, -2, 0);
        this.testSlicedDataset(ta, 1, 1, -2, 1);
        this.testSlicedDataset(ta, 1, 1, -2, 2);
        this.testSlicedDataset(ta, 2, 2, -2, 0);
        this.testSlicedDataset(ta, 2, 2, -2, 1);
        this.testSlicedDataset(ta, 2, 2, -2, 2);
        this.testSlicedDataset(ta, 0, 0, -3, 0);
        this.testSlicedDataset(ta, 0, 0, -3, 1);
        this.testSlicedDataset(ta, 0, 0, -3, 2);
        this.testSlicedDataset(ta, 3, 0, -3, 0);
        this.testSlicedDataset(ta, 3, 0, -3, 1);
        this.testSlicedDataset(ta, 3, 0, -3, 2);
        this.testSlicedDataset(ta, 1, 1, -3, 0);
        this.testSlicedDataset(ta, 1, 1, -3, 1);
        this.testSlicedDataset(ta, 1, 1, -3, 2);
        this.testSlicedDataset(ta, 2, 2, -3, 0);
        this.testSlicedDataset(ta, 2, 2, -3, 1);
        this.testSlicedDataset(ta, 2, 2, -3, 2);
    }

    @Test
    public void testBroadcastStrideIteration() {
        Dataset b = DatasetFactory.createFromObject((Object)2.0, (int[])new int[]{1}).getBroadcastView(new int[]{4});
        Dataset r = DatasetFactory.zeros(b.getClass(), (int[])b.getShapeRef()).fill(b.getObjectAbs(0));
        this.checkSliced(r, b);
        b = DatasetFactory.createRange((double)2.0).getBroadcastView(new int[]{4, 2});
        r = DatasetFactory.createRange((double)2.0).reshape(new int[]{1, 2});
        r = DatasetUtils.concatenate((IDataset[])new Dataset[]{r, r, r, r}, (int)0);
        this.checkSliced(r, b);
        r = DatasetFactory.createRange((double)2.0);
        this.checkSliced(r, b.getSlice(new Slice[]{new Slice(Integer.valueOf(0), Integer.valueOf(1))}));
        this.checkSliced(r, b.getSlice(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))}));
        this.checkSliced(r, b.getSliceView(new Slice[]{new Slice(Integer.valueOf(0), Integer.valueOf(1))}));
        this.checkSliced(r, b.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))}));
        b = DatasetFactory.createCompoundDataset((Object[])new Object[]{1.0, 2.0, 3.0}).getBroadcastView(new int[]{4});
        r = DatasetFactory.zeros((int)b.getElementsPerItem(), b.getClass(), (int[])b.getShapeRef()).fill(b.getObjectAbs(0));
        this.checkSliced(r, b);
        CompoundDataset a = DatasetFactory.createCompoundDataset((Object[])new Object[]{new double[]{1.0, 2.0}, new double[]{3.0, 4.0}});
        b = a.getBroadcastView(new int[]{4, 2});
        a.reshape(new int[]{1, 2});
        r = DatasetUtils.concatenate((IDataset[])new Dataset[]{a, a, a, a}, (int)0);
        this.checkSliced(r, b);
    }
}

