/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.WritableTableFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.january.form.Component;
import org.eclipse.january.form.ICEJAXBHandler;
import org.eclipse.january.form.IComponentVisitor;
import org.eclipse.january.form.IElementSource;
import org.eclipse.january.form.IUpdateableListener;
import org.eclipse.january.form.WrappedGlazedEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="ListComponent")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ListComponent<T>
extends TransformedList<T, T>
implements Component,
WritableTableFormat<T> {
    @XmlTransient
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @XmlTransient
    protected ICEJAXBHandler jaxbManipulator;
    @XmlTransient
    Map<IUpdateableListener, ListEventListener<Object>> listenerMap;
    protected BasicEventList<String> idList;
    protected BasicEventList<T> jaxbSourceList;
    @XmlTransient
    protected IElementSource<T> elementSource;
    @XmlTransient
    protected WritableTableFormat<T> tableFormat;

    public ListComponent() {
        this((EventList<T>)new BasicEventList());
    }

    public ListComponent(IElementSource<T> elementSource) {
        this();
        this.elementSource = elementSource;
    }

    protected ListComponent(EventList<T> source) {
        super(source);
        this.jaxbSourceList = (BasicEventList)source;
        this.idList = new BasicEventList();
        this.idList.add((Object)"1");
        this.idList.add((Object)"ICE Object");
        this.idList.add((Object)"ICE Object");
        this.idList.add((Object)"");
        this.listenerMap = new HashMap<IUpdateableListener, ListEventListener<Object>>();
    }

    public void copy(ListComponent<T> list) {
        if (list == null) {
            return;
        }
        this.idList.clear();
        this.idList.addAll(list.idList);
        this.clear();
        this.addAll((Collection)((Object)list));
    }

    @Override
    public int hashCode() {
        int hash = 11;
        hash = 31 * hash + this.idList.hashCode();
        hash = 31 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object otherObject) {
        boolean retVal = false;
        ListComponent castedOtherObject = null;
        if (otherObject != null && otherObject instanceof ListComponent) {
            if (this == otherObject) {
                retVal = true;
            } else {
                castedOtherObject = (ListComponent)otherObject;
                retVal = this.idList.equals(castedOtherObject.idList) && this.source.equals((Object)castedOtherObject.source);
            }
        }
        return retVal;
    }

    @Override
    public void register(IUpdateableListener listener) {
        WrappedGlazedEventListener glazedListener = new WrappedGlazedEventListener(listener, this);
        this.logger.info("Registered!");
        this.source.addListEventListener(glazedListener);
        this.idList.addListEventListener(glazedListener);
        this.listenerMap.put(listener, glazedListener);
    }

    @Override
    public void unregister(IUpdateableListener listener) {
        ListEventListener<Object> glazedListener = this.listenerMap.get(listener);
        this.source.removeListEventListener(glazedListener);
        this.idList.removeListEventListener(glazedListener);
        this.listenerMap.remove(listener);
    }

    @Override
    public void setId(int id) {
        if (id >= 0) {
            this.idList.set(0, (Object)String.valueOf(id));
        }
    }

    @Override
    public String getDescription() {
        return (String)this.idList.get(2);
    }

    @Override
    public int getId() {
        return Integer.valueOf((String)this.idList.get(0));
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            this.idList.set(1, (Object)name);
        }
    }

    @Override
    public String getName() {
        return (String)this.idList.get(1);
    }

    @Override
    public void setDescription(String description) {
        if (description != null) {
            this.idList.set(2, (Object)description);
        }
    }

    public void listChanged(ListEvent<T> listChanges) {
        this.logger.info("List changed!");
    }

    protected boolean isWritable() {
        return true;
    }

    @Override
    public void accept(IComponentVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        ListComponent<T> copy = new ListComponent<T>();
        copy.copy(this);
        return copy;
    }

    @Override
    public void update(String updatedKey, String newValue) {
    }

    public int getColumnCount() {
        int retValue = 0;
        if (this.tableFormat != null) {
            retValue = this.tableFormat.getColumnCount();
        }
        return retValue;
    }

    public String getColumnName(int column) {
        String name = null;
        if (this.tableFormat != null) {
            name = this.tableFormat.getColumnName(column);
        }
        return name;
    }

    public Object getColumnValue(T baseObject, int column) {
        Object obj = null;
        if (this.tableFormat != null) {
            obj = this.tableFormat.getColumnValue(baseObject, column);
        }
        return obj;
    }

    public boolean isEditable(T baseObject, int column) {
        boolean retValue = false;
        if (this.tableFormat != null) {
            retValue = this.tableFormat.isEditable(baseObject, column);
        }
        return retValue;
    }

    public T setColumnValue(T baseObject, Object editedValue, int column) {
        Object retValue = null;
        if (this.tableFormat != null) {
            retValue = this.tableFormat.setColumnValue(baseObject, editedValue, column);
        }
        return (T)retValue;
    }

    public void setElementSource(IElementSource<T> source) {
        this.elementSource = source;
    }

    public IElementSource<T> getElementSource() {
        return this.elementSource;
    }

    public void setTableFormat(WritableTableFormat<T> format) {
        this.tableFormat = format;
    }

    public WritableTableFormat<T> getTableFormat() {
        return this.tableFormat;
    }

    public void addListEventListener(ListEventListener<? super T> listChangeListener) {
        super.addListEventListener(listChangeListener);
        this.source.addListEventListener(listChangeListener);
    }

    public void removeListEventListener(ListEventListener<? super T> listChangeListener) {
        super.removeListEventListener(listChangeListener);
        this.source.removeListEventListener(listChangeListener);
    }

    @Override
    public String getContext() {
        return (String)this.idList.get(3);
    }

    @Override
    public void setContext(String context) {
        this.idList.set(3, (Object)context);
    }
}

