/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import java.util.EventObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataEvent
extends EventObject {
    private static final long serialVersionUID = 751125872769278449L;
    private int[] shape;
    private String filePath;
    private String name;

    public DataEvent() {
        this("", new int[]{1});
    }

    public DataEvent(String name, int[] shape) {
        super(name);
        this.shape = shape;
        this.name = name;
    }

    @Override
    public String getSource() {
        return (String)super.getSource();
    }

    public String getName() {
        return this.getSource();
    }

    public void setName(String name) {
        this.name = name;
    }

    public int[] getShape() {
        return this.shape;
    }

    public void setShape(int[] shape) {
        this.shape = shape;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String encode() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        buf.append("\"name\" : \"");
        buf.append(this.getName());
        buf.append("\"");
        buf.append(", \"shape\" : ");
        buf.append(Arrays.toString(this.shape));
        buf.append(", \"filepath\" : \"");
        buf.append(this.getFilePath());
        buf.append("\"");
        buf.append("}");
        return buf.toString();
    }

    public static DataEvent decode(String json) {
        String name = DataEvent.getValue(json, ".*\"name\" \\: \"([^\"]+)\".*");
        String filepath = DataEvent.getValue(json, ".*\"filepath\" \\: \"([^\"]+)\".*");
        String shape = DataEvent.getValue(json, ".*\"shape\" \\: \\[([^\\]]+)\\].*");
        DataEvent ret = new DataEvent(name, DataEvent.getArray(shape));
        if (filepath != null && !"null".equals(filepath)) {
            ret.setFilePath(filepath);
        }
        return ret;
    }

    private static String getValue(String json, String regex) {
        Matcher matcher = Pattern.compile(regex).matcher(json);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new RuntimeException(String.valueOf(regex) + " unmatched in " + json);
    }

    private static int[] getArray(String value) {
        String[] split = value.split(",");
        int[] ret = new int[split.length];
        int i = 0;
        while (i < split.length) {
            ret[i] = Integer.parseInt(split[i].trim());
            ++i;
        }
        return ret;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.filePath == null ? 0 : this.filePath.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + Arrays.hashCode(this.shape);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataEvent other = (DataEvent)obj;
        if (this.filePath == null ? other.filePath != null : !this.filePath.equals(other.filePath)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return Arrays.equals(this.shape, other.shape);
    }
}

