/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.metadata.internal;

import java.util.HashMap;
import org.eclipse.january.MetadataException;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.LazyDatasetBase;
import org.eclipse.january.metadata.DynamicConnectionInfo;
import org.eclipse.january.metadata.ErrorMetadata;
import org.eclipse.january.metadata.IExtendedMetadata;
import org.eclipse.january.metadata.IMetadata;
import org.eclipse.january.metadata.MetadataFactory;
import org.eclipse.january.metadata.MetadataType;
import org.eclipse.january.metadata.OriginMetadata;
import org.eclipse.january.metadata.internal.ErrorMetadataImpl;
import org.eclipse.january.metadata.internal.OriginMetadataImpl;
import org.junit.Assert;
import org.junit.Test;

public class MetadataFactoryTest {
    @Test
    public void testFinder() throws MetadataException {
        Class clazz = LazyDatasetBase.findMetadataTypeSubInterfaces(IExtendedMetadata.class);
        Assert.assertEquals(IExtendedMetadata.class, (Object)clazz);
        clazz = LazyDatasetBase.findMetadataTypeSubInterfaces(DynamicConnectionInfo.class);
        Assert.assertEquals(DynamicConnectionInfo.class, (Object)clazz);
        clazz = LazyDatasetBase.findMetadataTypeSubInterfaces(OriginMetadataImpl.class);
        Assert.assertEquals(OriginMetadata.class, (Object)clazz);
        clazz = LazyDatasetBase.findMetadataTypeSubInterfaces(new DynamicConnectionInfo(){
            private static final long serialVersionUID = 3467617639382611191L;
        }.getClass());
        Assert.assertEquals(DynamicConnectionInfo.class, (Object)clazz);
        clazz = LazyDatasetBase.findMetadataTypeSubInterfaces(new InnerMetadata().getClass());
        Assert.assertEquals(InnerMetadata.class, (Object)clazz);
        clazz = LazyDatasetBase.findMetadataTypeSubInterfaces(new InnerMetadata2().getClass());
        Assert.assertEquals(InnerMetadata2.class, (Object)clazz);
    }

    @Test
    public void testFinderWithInproperMetadataType() {
        try {
            LazyDatasetBase.findMetadataTypeSubInterfaces(MetadataType.class);
            Assert.fail((String)"Should not be able to find direct implementation of MetadataType");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        MetadataType md = new MetadataType(){
            private static final long serialVersionUID = 1L;

            public MetadataType clone() {
                return null;
            }
        };
        try {
            LazyDatasetBase.findMetadataTypeSubInterfaces(md.getClass());
            Assert.fail((String)"Should not be able to find anonymous direct implementation of MetadataType");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        DoubleDataset d = DatasetFactory.zeros((int[])new int[]{2, 3});
        try {
            d.addMetadata(md);
            Assert.fail((String)"Should not be able to add anonymous direct implementation of MetadataType");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testCreator() throws MetadataException {
        ErrorMetadata emd = (ErrorMetadata)MetadataFactory.createMetadata(ErrorMetadata.class, (Object[])new Object[0]);
        Assert.assertEquals((Object)new ErrorMetadataImpl().getError(), (Object)emd.getError());
    }

    @Test
    public void testMetadata() throws MetadataException {
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put("Hello", "World");
        IMetadata imd = (IMetadata)MetadataFactory.createMetadata(IMetadata.class, (Object[])new Object[]{meta});
        Assert.assertEquals(meta.get("Hello"), (Object)imd.clone().getMetaValue("Hello"));
    }

    class InnerMetadata
    implements MetadataType {
        private static final long serialVersionUID = 93680612340323601L;

        public InnerMetadata clone() {
            return new InnerMetadata();
        }
    }

    static class InnerMetadata2
    implements MetadataType {
        private static final long serialVersionUID = 93680612340323601L;

        public InnerMetadata2 clone() {
            return new InnerMetadata2();
        }
    }
}

