/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.LazyWriteableDataset;
import org.eclipse.january.dataset.Random;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceND;
import org.junit.Assert;
import org.junit.Test;

public class LazyWriteableDatasetTest {
    @Test
    public void testSetSlice() throws Exception {
        int[] shape = new int[]{1, 2, 3, 4};
        DoubleDataset d = Random.randn((int[])shape);
        LazyWriteableDataset ld = LazyWriteableDataset.createLazyDataset((Dataset)d);
        SliceND s = new SliceND(d.getShapeRef(), new Slice[]{null, null, new Slice(Integer.valueOf(1)), new Slice(Integer.valueOf(0), null, Integer.valueOf(2))});
        Dataset sd = DatasetFactory.ones(d.getClass(), (int[])s.getShape());
        ld.setSlice((IDataset)sd, s);
        Assert.assertEquals((Object)d.getSlice(s), (Object)sd);
        sd = DatasetFactory.ones(d.getClass(), (int[])shape);
        sd.fill((Object)2);
        ld.setSlice((IDataset)sd, null);
        Assert.assertEquals((Object)d, (Object)sd);
    }

    @Test
    public void testSetSliceOnFullView() throws Exception {
        int[] shape = new int[]{1, 2, 3, 4};
        DoubleDataset d = Random.randn((int[])shape);
        LazyWriteableDataset old = LazyWriteableDataset.createLazyDataset((Dataset)d);
        LazyWriteableDataset ld = old.getSliceView(new Slice[0]);
        SliceND s = new SliceND(ld.getShape(), new Slice[]{null, null, new Slice(Integer.valueOf(1), null), new Slice(Integer.valueOf(0), null, Integer.valueOf(2))});
        Dataset sd = DatasetFactory.ones((Class)ld.getInterface(), (int[])s.getShape());
        ld.setSlice((IDataset)sd, s);
        Assert.assertEquals((Object)d.getSlice(s), (Object)sd);
    }

    @Test
    public void testSetSliceOnSlicedView() throws Exception {
        int[] shape = new int[]{1, 2, 3, 4};
        DoubleDataset d = Random.randn((int[])shape);
        LazyWriteableDataset old = LazyWriteableDataset.createLazyDataset((Dataset)d);
        LazyWriteableDataset ld = old.getSliceView(new Slice[]{null, null, null, new Slice(Integer.valueOf(1), null)});
        SliceND s = new SliceND(ld.getShape(), new Slice[]{null, null, new Slice(Integer.valueOf(1), null), new Slice(Integer.valueOf(0), null, Integer.valueOf(2))});
        Dataset sd = DatasetFactory.ones((Class)ld.getInterface(), (int[])s.getShape());
        ld.setSlice((IDataset)sd, s);
        Assert.assertEquals((Object)d.getSlice(new Slice[]{null, null, new Slice(Integer.valueOf(1), null), new Slice(Integer.valueOf(1), null, Integer.valueOf(2))}), (Object)sd);
    }

    @Test
    public void testSetSliceOnTransposedView() throws Exception {
        int[] shape = new int[]{1, 2, 3, 4};
        DoubleDataset d = Random.randn((int[])shape);
        LazyWriteableDataset old = LazyWriteableDataset.createLazyDataset((Dataset)d);
        LazyWriteableDataset ld = old.getTransposedView(new int[0]);
        SliceND s = new SliceND(ld.getShape(), new Slice[]{new Slice(Integer.valueOf(0), null, Integer.valueOf(2)), new Slice(Integer.valueOf(1), null), null, null});
        Dataset sd = DatasetFactory.ones((Class)ld.getInterface(), (int[])s.getShape());
        ld.setSlice((IDataset)sd, s);
        Assert.assertEquals((Object)d.transpose(new int[0]).getSlice(s), (Object)sd);
    }

    @Test
    public void testSetExpandedSlice() throws Exception {
        int[] shape = new int[]{1, 2, 3, 4};
        DoubleDataset d = Random.randn((int[])shape);
        LazyWriteableDataset ld = LazyWriteableDataset.createLazyDataset((Dataset)d, (int[])new int[]{2, 2, 3, 4});
        SliceND s = new SliceND(d.getShapeRef(), ld.getMaxShape(), new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2)), null, new Slice(Integer.valueOf(1)), new Slice(Integer.valueOf(0), null, Integer.valueOf(2))});
        Dataset sd = DatasetFactory.ones((Class)ld.getInterface(), (int[])s.getShape());
        ld.setSlice((IDataset)sd, s);
        Assert.assertEquals((Object)ld.getSlice(s), (Object)sd);
    }

    @Test
    public void testSetSliceOnSqueezed() throws Exception {
        int[] shape = new int[]{1, 2, 3, 4};
        DoubleDataset d = Random.randn((int[])shape);
        LazyWriteableDataset ld = LazyWriteableDataset.createLazyDataset((Dataset)d);
        Dataset dv = d.getSliceView(new Slice[0]).squeezeEnds();
        LazyWriteableDataset sv = ld.getSliceView(new Slice[0]);
        sv.squeezeEnds();
        SliceND s = new SliceND(dv.getShapeRef(), new Slice[]{new Slice(Integer.valueOf(1)), null, new Slice(Integer.valueOf(0), null, Integer.valueOf(2))});
        Dataset sd = DatasetFactory.ones(d.getClass(), (int[])s.getShape());
        sv.setSlice((IDataset)sd, s);
        Assert.assertEquals((Object)dv.getSlice(s), (Object)sd);
        sd = DatasetFactory.ones(d.getClass(), (int[])dv.getShapeRef());
        sd.fill((Object)2);
        sv.setSlice((IDataset)sd, null);
        Assert.assertEquals((Object)dv, (Object)sd);
    }
}

