/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.lang.reflect.Array;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.complex.Complex;
import org.eclipse.january.dataset.BooleanDataset;
import org.eclipse.january.dataset.BooleanDatasetBase;
import org.eclipse.january.dataset.ByteDataset;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.ComplexFloatDataset;
import org.eclipse.january.dataset.CompoundByteDataset;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.CompoundFloatDataset;
import org.eclipse.january.dataset.CompoundIntegerDataset;
import org.eclipse.january.dataset.CompoundLongDataset;
import org.eclipse.january.dataset.CompoundShortDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DateDataset;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.FloatDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.LongDataset;
import org.eclipse.january.dataset.ObjectDataset;
import org.eclipse.january.dataset.ObjectDatasetBase;
import org.eclipse.january.dataset.RGBByteDataset;
import org.eclipse.january.dataset.RGBDataset;
import org.eclipse.january.dataset.ShortDataset;
import org.eclipse.january.dataset.StringDataset;
import org.eclipse.january.dataset.StringDatasetBase;

public class InterfaceUtils {
    private static final Map<Class<?>, Class<? extends Dataset>> class2Interface = InterfaceUtils.createClassInterfaceMap();
    private static final Map<Class<? extends Dataset>, Class<?>> interface2Class = InterfaceUtils.createInterfaceClassMap();
    private static final Map<Class<?>, Integer> elementBytes;
    private static final Map<Class<?>, Class<?>> bestFloatElement;
    private static final Map<Class<? extends Dataset>, Class<? extends CompoundDataset>> interface2Compound;
    private static final Map<Class<? extends CompoundDataset>, Class<? extends Dataset>> compound2Interface;
    private static Set<Class<? extends Dataset>> interfaces;

    static {
        interfaces = interface2Class.keySet();
        elementBytes = InterfaceUtils.createElementBytesMap();
        bestFloatElement = InterfaceUtils.createBestFloatElementMap();
        interface2Compound = InterfaceUtils.createInterfaceCompoundMap();
        compound2Interface = new HashMap<Class<? extends CompoundDataset>, Class<? extends Dataset>>();
        for (Map.Entry<Class<? extends Dataset>, Class<? extends CompoundDataset>> e : interface2Compound.entrySet()) {
            compound2Interface.put(e.getValue(), e.getKey());
        }
        compound2Interface.put(RGBByteDataset.class, ByteDataset.class);
        compound2Interface.put(RGBDataset.class, ShortDataset.class);
        compound2Interface.put(ComplexFloatDataset.class, FloatDataset.class);
        compound2Interface.put(ComplexDoubleDataset.class, DoubleDataset.class);
    }

    private static Map<Class<?>, Class<? extends Dataset>> createClassInterfaceMap() {
        HashMap result = new HashMap();
        result.put(Boolean.class, BooleanDataset.class);
        result.put(Byte.class, ByteDataset.class);
        result.put(Short.class, ShortDataset.class);
        result.put(Integer.class, IntegerDataset.class);
        result.put(Long.class, LongDataset.class);
        result.put(Float.class, FloatDataset.class);
        result.put(Double.class, DoubleDataset.class);
        result.put(Boolean.TYPE, BooleanDataset.class);
        result.put(Byte.TYPE, ByteDataset.class);
        result.put(Short.TYPE, ShortDataset.class);
        result.put(Integer.TYPE, IntegerDataset.class);
        result.put(Long.TYPE, LongDataset.class);
        result.put(Float.TYPE, FloatDataset.class);
        result.put(Double.TYPE, DoubleDataset.class);
        result.put(Complex.class, ComplexDoubleDataset.class);
        result.put(String.class, StringDataset.class);
        result.put(Date.class, DateDataset.class);
        return result;
    }

    private static Map<Class<? extends Dataset>, Class<?>> createInterfaceClassMap() {
        LinkedHashMap result = new LinkedHashMap();
        result.put(DoubleDataset.class, Double.class);
        result.put(DateDataset.class, Date.class);
        result.put(IntegerDataset.class, Integer.class);
        result.put(BooleanDataset.class, Boolean.class);
        result.put(StringDataset.class, String.class);
        result.put(ComplexDoubleDataset.class, Double.class);
        result.put(RGBByteDataset.class, Byte.class);
        result.put(RGBDataset.class, Short.class);
        result.put(ByteDataset.class, Byte.class);
        result.put(ShortDataset.class, Short.class);
        result.put(LongDataset.class, Long.class);
        result.put(FloatDataset.class, Float.class);
        result.put(ComplexFloatDataset.class, Float.class);
        result.put(CompoundShortDataset.class, Short.class);
        result.put(CompoundByteDataset.class, Byte.class);
        result.put(CompoundIntegerDataset.class, Integer.class);
        result.put(CompoundLongDataset.class, Long.class);
        result.put(CompoundFloatDataset.class, Float.class);
        result.put(CompoundDoubleDataset.class, Double.class);
        result.put(ObjectDataset.class, Object.class);
        return result;
    }

    private static Map<Class<?>, Integer> createElementBytesMap() {
        LinkedHashMap result = new LinkedHashMap();
        result.put(Boolean.class, 1);
        result.put(Byte.class, 1);
        result.put(Short.class, 2);
        result.put(Integer.class, 4);
        result.put(Long.class, 8);
        result.put(Float.class, 4);
        result.put(Double.class, 8);
        result.put(String.class, 1);
        result.put(Object.class, 1);
        result.put(Date.class, 1);
        return result;
    }

    private static Map<Class<?>, Class<?>> createBestFloatElementMap() {
        HashMap result = new HashMap();
        result.put(Boolean.class, Float.class);
        result.put(Byte.class, Float.class);
        result.put(Short.class, Float.class);
        result.put(Integer.class, Double.class);
        result.put(Long.class, Double.class);
        result.put(Float.class, Float.class);
        result.put(Double.class, Double.class);
        return result;
    }

    private static Map<Class<? extends Dataset>, Class<? extends CompoundDataset>> createInterfaceCompoundMap() {
        HashMap<Class<? extends Dataset>, Class<? extends CompoundDataset>> result = new HashMap<Class<? extends Dataset>, Class<? extends CompoundDataset>>();
        result.put(ByteDataset.class, CompoundByteDataset.class);
        result.put(ShortDataset.class, CompoundShortDataset.class);
        result.put(IntegerDataset.class, CompoundIntegerDataset.class);
        result.put(LongDataset.class, CompoundLongDataset.class);
        result.put(FloatDataset.class, CompoundFloatDataset.class);
        result.put(DoubleDataset.class, CompoundDoubleDataset.class);
        return result;
    }

    public static boolean isInstance(Object object, Class<? extends Dataset> dInterface) {
        return dInterface.isInstance(object);
    }

    public static boolean hasInterface(Class<? extends Dataset> clazz, Class<? extends Dataset> dInterface) {
        return dInterface.isAssignableFrom(clazz);
    }

    public static boolean hasInterface(Class<? extends Dataset> clazz, Class<? extends Dataset> ... dInterfaces) {
        Class<? extends Dataset>[] classArray = dInterfaces;
        int n = dInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Dataset> d = classArray[n2];
            if (d != null && d.isAssignableFrom(clazz)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isElementSupported(Class<? extends Object> clazz) {
        return class2Interface.containsKey(clazz);
    }

    public static Class<?> getElementClass(Class<? extends Dataset> clazz) {
        Class<? extends Dataset> eInterface = InterfaceUtils.getElementalInterface(clazz);
        return interface2Class.get(eInterface);
    }

    public static Class<? extends Dataset> getInterface(Object obj) {
        Class<? extends Dataset> dc = null;
        if (obj == null) {
            return ObjectDataset.class;
        }
        if (obj instanceof List) {
            List jl = (List)obj;
            int l = jl.size();
            int i = 0;
            while (i < l) {
                dc = InterfaceUtils.getBestInterface(dc, InterfaceUtils.getInterface(jl.get(i)));
                ++i;
            }
        } else if (obj.getClass().isArray()) {
            Class<?> ca = obj.getClass().getComponentType();
            if (InterfaceUtils.isElementSupported(ca)) {
                return class2Interface.get(ca);
            }
            int l = Array.getLength(obj);
            int i = 0;
            while (i < l) {
                Object lo = Array.get(obj, i);
                dc = InterfaceUtils.getBestInterface(dc, InterfaceUtils.getInterface(lo));
                ++i;
            }
        } else if (obj instanceof Dataset) {
            dc = InterfaceUtils.findSubInterface(((Dataset)obj).getClass());
        } else if (obj instanceof ILazyDataset) {
            dc = InterfaceUtils.getInterfaceFromClass(((ILazyDataset)obj).getElementsPerItem(), ((ILazyDataset)obj).getElementClass());
        } else {
            Class<?> ca = obj.getClass();
            if (InterfaceUtils.isElementSupported(ca)) {
                return class2Interface.get(ca);
            }
        }
        return dc;
    }

    public static Class<? extends Dataset> findSubInterface(Class<? extends Dataset> clazz) {
        if (Dataset.class.equals(clazz)) {
            throw new IllegalArgumentException("Class must be a sub-interface of Dataset");
        }
        for (Class<? extends Dataset> i : interfaces) {
            if (!i.isAssignableFrom(clazz)) continue;
            return i;
        }
        if (BooleanDatasetBase.class.equals(clazz)) {
            return BooleanDataset.class;
        }
        if (StringDatasetBase.class.equals(clazz)) {
            return StringDataset.class;
        }
        if (ObjectDatasetBase.class.equals(clazz)) {
            return ObjectDataset.class;
        }
        throw new IllegalArgumentException("Unknown sub-interface of Dataset");
    }

    public static Class<? extends Dataset> getInterfaceFromClass(int elementsPerItem, Class<?> elementClass) {
        Class<? extends Dataset> clazz = class2Interface.get(elementClass);
        if (clazz == null) {
            throw new IllegalArgumentException("Class of object not supported");
        }
        if (elementsPerItem > 1 && interface2Compound.containsKey(clazz)) {
            clazz = interface2Compound.get(clazz);
        }
        return clazz;
    }

    public static Class<? extends Dataset> getElementalInterface(Class<? extends Dataset> clazz) {
        Class<? extends Dataset> c = InterfaceUtils.findSubInterface(clazz);
        return InterfaceUtils.isElemental(c) ? c : compound2Interface.get(c);
    }

    public static Class<? extends CompoundDataset> getCompoundInterface(Class<? extends Dataset> clazz) {
        Class<? extends Dataset> c = null;
        Class<? extends Dataset> d = InterfaceUtils.findSubInterface(clazz);
        c = InterfaceUtils.isElemental(d) ? interface2Compound.get(d) : d;
        if (c == null) {
            throw new IllegalArgumentException("Interface cannot be compound");
        }
        return c;
    }

    public static boolean isElemental(ILazyDataset a) {
        return InterfaceUtils.isElemental(InterfaceUtils.getInterface(a));
    }

    public static boolean isElemental(Class<? extends Dataset> clazz) {
        return !CompoundDataset.class.isAssignableFrom(clazz);
    }

    public static boolean isCompound(Class<? extends Dataset> clazz) {
        Class<? extends Dataset> c = InterfaceUtils.findSubInterface(clazz);
        return compound2Interface.containsKey(c);
    }

    public static boolean isInteger(ILazyDataset a) {
        return a instanceof Dataset ? InterfaceUtils.isInteger(((Dataset)a).getClass()) : InterfaceUtils.isElementClassInteger(a.getElementClass());
    }

    public static boolean isFloating(ILazyDataset a) {
        return a instanceof Dataset ? InterfaceUtils.isFloating(((Dataset)a).getClass()) : InterfaceUtils.isElementClassFloating(a.getElementClass());
    }

    public static boolean isInteger(Class<? extends Dataset> clazz) {
        Class<?> c = InterfaceUtils.getElementClass(clazz);
        return InterfaceUtils.isElementClassInteger(c);
    }

    public static boolean isFloating(Class<? extends Dataset> clazz) {
        Class<?> c = InterfaceUtils.getElementClass(clazz);
        return InterfaceUtils.isElementClassFloating(c);
    }

    private static boolean isElementClassInteger(Class<?> c) {
        return Byte.class == c || Short.class == c || Integer.class == c || Long.class == c;
    }

    private static boolean isElementClassFloating(Class<?> c) {
        return Double.class == c || Float.class == c;
    }

    public static boolean isComplex(Class<? extends Dataset> clazz) {
        return ComplexDoubleDataset.class.isAssignableFrom(clazz) || ComplexFloatDataset.class.isAssignableFrom(clazz);
    }

    public static boolean isNumerical(Class<? extends Dataset> clazz) {
        Class<?> c = InterfaceUtils.getElementClass(clazz);
        return Boolean.class == c || InterfaceUtils.isElementClassInteger(c) || InterfaceUtils.isElementClassFloating(c);
    }

    public static int getElementsPerItem(Class<? extends Dataset> clazz) {
        if (InterfaceUtils.isComplex(clazz)) {
            return 2;
        }
        if (RGBByteDataset.class.isAssignableFrom(clazz) || RGBDataset.class.isAssignableFrom(clazz)) {
            return 3;
        }
        if (CompoundDataset.class.isAssignableFrom(clazz)) {
            throw new UnsupportedOperationException("Multi-element type unsupported");
        }
        return 1;
    }

    public static Class<? extends Dataset> getBestInterface(Class<? extends Dataset> a, Class<? extends Dataset> b) {
        Class<? extends Dataset> c;
        boolean bz;
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        boolean isElemental = true;
        boolean az = InterfaceUtils.isComplex(a);
        if (!az && !InterfaceUtils.isElemental(a)) {
            isElemental = false;
            a = compound2Interface.get(a);
        }
        if (!(bz = InterfaceUtils.isComplex(b)) && !InterfaceUtils.isElemental(b)) {
            isElemental = false;
            b = compound2Interface.get(b);
        }
        if (InterfaceUtils.isFloating(a)) {
            if (!InterfaceUtils.isFloating(b)) {
                b = InterfaceUtils.getBestFloatInterface(b);
            }
            if (az) {
                b = DoubleDataset.class.isAssignableFrom(b) ? ComplexDoubleDataset.class : ComplexFloatDataset.class;
            }
        } else if (InterfaceUtils.isFloating(b)) {
            a = InterfaceUtils.getBestFloatInterface(a);
            if (bz) {
                a = DoubleDataset.class.isAssignableFrom(a) ? ComplexDoubleDataset.class : ComplexFloatDataset.class;
            }
        }
        Class<? extends Dataset> clazz = c = InterfaceUtils.isBetter(interface2Class.get(a), interface2Class.get(b)) ? a : b;
        if ((az || bz) && !InterfaceUtils.isComplex(c)) {
            Class clazz2 = c = DoubleDataset.class.isAssignableFrom(c) ? ComplexDoubleDataset.class : ComplexFloatDataset.class;
        }
        if (!isElemental && interface2Compound.containsKey(c)) {
            c = interface2Compound.get(c);
        }
        return c;
    }

    private static boolean isBetter(Class<?> a, Class<?> b) {
        for (Class<?> k : elementBytes.keySet()) {
            if (k.equals(b)) {
                return true;
            }
            if (!k.equals(a)) continue;
            return false;
        }
        return true;
    }

    public static Class<? extends Dataset> getLargestInterface(Dataset a) {
        if (a instanceof BooleanDataset || a instanceof ByteDataset || a instanceof ShortDataset) {
            return IntegerDataset.class;
        }
        if (a instanceof IntegerDataset) {
            return LongDataset.class;
        }
        if (a instanceof FloatDataset) {
            return DoubleDataset.class;
        }
        if (a instanceof ComplexFloatDataset) {
            return ComplexDoubleDataset.class;
        }
        if (a instanceof CompoundByteDataset || a instanceof CompoundShortDataset) {
            return CompoundIntegerDataset.class;
        }
        if (a instanceof CompoundIntegerDataset) {
            return CompoundLongDataset.class;
        }
        if (a instanceof CompoundFloatDataset) {
            return CompoundDoubleDataset.class;
        }
        return a.getClass();
    }

    public static Class<? extends Dataset> getBestFloatInterface(Class<? extends Dataset> clazz) {
        Class<?> e = interface2Class.get(clazz);
        if (bestFloatElement.containsKey(e)) {
            e = bestFloatElement.get(e);
            return class2Interface.get(e);
        }
        return clazz;
    }

    public static int getItemBytes(int isize, Class<? extends Dataset> clazz) {
        Class<?> eClass = interface2Class.get(clazz);
        if (eClass == null) {
            eClass = interface2Class.get(InterfaceUtils.findSubInterface(clazz));
        }
        int bytes = elementBytes.get(eClass);
        return isize * bytes;
    }

    public static Object fromDoublesToBiggestPrimitives(Class<? extends Dataset> clazz, double[] x) {
        if (BooleanDataset.class.isAssignableFrom(clazz) || ByteDataset.class.isAssignableFrom(clazz) || ShortDataset.class.isAssignableFrom(clazz) || IntegerDataset.class.isAssignableFrom(clazz)) {
            int[] i32 = new int[x.length];
            int i = 0;
            while (i < x.length) {
                i32[i] = (int)x[i];
                ++i;
            }
            return i32;
        }
        if (LongDataset.class.isAssignableFrom(clazz)) {
            long[] i64 = new long[x.length];
            int i = 0;
            while (i < x.length) {
                i64[i] = (long)x[i];
                ++i;
            }
            return i64;
        }
        if (FloatDataset.class.isAssignableFrom(clazz)) {
            float[] f32 = new float[x.length];
            int i = 0;
            while (i < x.length) {
                f32[i] = (float)x[i];
                ++i;
            }
            return f32;
        }
        if (DoubleDataset.class.isAssignableFrom(clazz)) {
            return x;
        }
        return null;
    }

    public static Number fromDoubleToNumber(Class<? extends Dataset> clazz, double x) {
        if (BooleanDataset.class.isAssignableFrom(clazz) || ByteDataset.class.isAssignableFrom(clazz)) {
            return (byte)x;
        }
        if (ShortDataset.class.isAssignableFrom(clazz)) {
            return (short)x;
        }
        if (IntegerDataset.class.isAssignableFrom(clazz)) {
            return (int)x;
        }
        if (LongDataset.class.isAssignableFrom(clazz)) {
            return (long)x;
        }
        if (FloatDataset.class.isAssignableFrom(clazz)) {
            return Float.valueOf((float)x);
        }
        if (DoubleDataset.class.isAssignableFrom(clazz)) {
            return x;
        }
        return null;
    }

    public static Number fromDoubleToBiggestNumber(Class<? extends Dataset> clazz, double x) {
        if (BooleanDataset.class.isAssignableFrom(clazz) || ByteDataset.class.isAssignableFrom(clazz) || ShortDataset.class.isAssignableFrom(clazz) || IntegerDataset.class.isAssignableFrom(clazz)) {
            return (int)x;
        }
        if (LongDataset.class.isAssignableFrom(clazz)) {
            return (long)x;
        }
        if (FloatDataset.class.isAssignableFrom(clazz)) {
            return Float.valueOf((float)x);
        }
        if (DoubleDataset.class.isAssignableFrom(clazz)) {
            return x;
        }
        return null;
    }

    public static Number toBiggestNumber(Class<? extends Dataset> clazz, Number x) {
        if (BooleanDataset.class.isAssignableFrom(clazz) || ByteDataset.class.isAssignableFrom(clazz) || ShortDataset.class.isAssignableFrom(clazz) || IntegerDataset.class.isAssignableFrom(clazz)) {
            return x instanceof Integer ? (Number)x : (Number)x.intValue();
        }
        if (LongDataset.class.isAssignableFrom(clazz)) {
            return x instanceof Long ? (Number)x : (Number)x.longValue();
        }
        if (FloatDataset.class.isAssignableFrom(clazz)) {
            return x instanceof Float ? (Number)x : (Number)Float.valueOf(x.floatValue());
        }
        if (DoubleDataset.class.isAssignableFrom(clazz)) {
            return x instanceof Double ? (Number)x : (Number)x.doubleValue();
        }
        return null;
    }
}

