/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.math3.complex.Complex;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.AbstractDataset;
import org.eclipse.january.dataset.BooleanDataset;
import org.eclipse.january.dataset.ByteDataset;
import org.eclipse.january.dataset.Comparisons;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.ComplexFloatDataset;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.FloatDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.InterfaceUtils;
import org.eclipse.january.dataset.LongDataset;
import org.eclipse.january.dataset.Maths;
import org.eclipse.january.dataset.Random;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.ShortDataset;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceND;
import org.eclipse.january.metadata.StatisticsMetadata;
import org.junit.Assert;
import org.junit.Test;

public class AbstractDatasetTest {
    @Test
    public void testBestDType() {
        Assert.assertEquals(FloatDataset.class, (Object)InterfaceUtils.getBestInterface(ShortDataset.class, FloatDataset.class));
        Assert.assertEquals(DoubleDataset.class, (Object)InterfaceUtils.getBestInterface(LongDataset.class, FloatDataset.class));
        Assert.assertEquals(ComplexFloatDataset.class, (Object)InterfaceUtils.getBestInterface(FloatDataset.class, ComplexFloatDataset.class));
        Assert.assertEquals(ComplexDoubleDataset.class, (Object)InterfaceUtils.getBestInterface(IntegerDataset.class, ComplexFloatDataset.class));
    }

    @Test
    public void testCompatibleShapes() {
        Assert.assertTrue((String)"[] and []", (boolean)ShapeUtils.areShapesCompatible((int[])new int[0], (int[])new int[0]));
        Assert.assertTrue((String)"[1] and []", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{1}, (int[])new int[0]));
        Assert.assertFalse((String)"[2] and []", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{2}, (int[])new int[0]));
        Assert.assertTrue((String)"[2] and [2]", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{2}, (int[])new int[]{2}));
        Assert.assertTrue((String)"[3] and [3]", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{3}, (int[])new int[]{3}));
        Assert.assertTrue((String)"[1,2] and [2]", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{1, 2}, (int[])new int[]{2}));
        Assert.assertTrue((String)"[2] and [1,2]", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{2}, (int[])new int[]{1, 2}));
        Assert.assertFalse((String)"[10,10] and [10,10,10]", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{10, 10}, (int[])new int[]{10, 10, 10}));
        Assert.assertFalse((String)"[10,10,10] and [10,10]", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{10, 10, 10}, (int[])new int[]{10, 10}));
        Assert.assertTrue((String)"[2] and [2,1,1,1]", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{2}, (int[])new int[]{2, 1, 1, 1}));
        Assert.assertTrue((String)"[2,1] and [2,1,1,1]", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{2, 1}, (int[])new int[]{2, 1, 1, 1}));
        Assert.assertFalse((String)"[2,1] and [3,1,1,2]", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{2, 1}, (int[])new int[]{3, 1, 1, 2}));
        Assert.assertFalse((String)"[2,1] and [3,1,1,1]", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{2, 1}, (int[])new int[]{3, 1, 1, 1}));
        Assert.assertTrue((String)"[1,2,1] and [2,1,1,1]", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{1, 2, 1}, (int[])new int[]{2, 1, 1, 1}));
        Assert.assertTrue((String)"[1,2,1,3] and [2,1,1,1,3]", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{1, 2, 1, 3}, (int[])new int[]{2, 1, 1, 1, 3}));
        Assert.assertTrue((String)"[2,1,1] and [1,1,2]", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{2, 1, 1}, (int[])new int[]{1, 1, 2}));
        Assert.assertFalse((String)"[2,1,1] and [1,1,3]", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{2, 1, 1}, (int[])new int[]{1, 1, 3}));
        Assert.assertFalse((String)"[2,1,4] and [2,1,1,3]", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{2, 1, 4}, (int[])new int[]{2, 1, 1, 3}));
        Assert.assertFalse((String)"[2,1,4] and [2,1,3]", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{2, 1, 4}, (int[])new int[]{2, 1, 3}));
        Assert.assertFalse((String)"[2,4] and [2,3]", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{2, 4}, (int[])new int[]{2, 3}));
        Assert.assertTrue((String)"[2,1,4] and [2,1,4]", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{2, 1, 4}, (int[])new int[]{2, 1, 4}));
        Assert.assertTrue((String)"[2,1,4] and [2,1,1,4]", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{2, 1, 4}, (int[])new int[]{2, 1, 1, 4}));
        Assert.assertFalse((String)"[2,4] and [2,4,3]", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{2, 4}, (int[])new int[]{2, 4, 3}));
        Assert.assertFalse((String)"[2,1,4] and [2,4,3]", (boolean)ShapeUtils.areShapesCompatible((int[])new int[]{2, 1, 4}, (int[])new int[]{2, 4, 3}));
        Assert.assertTrue((boolean)ShapeUtils.areShapesCompatible((int[])new int[0], (int[])new int[0], (int)0));
        Assert.assertTrue((boolean)ShapeUtils.areShapesCompatible((int[])new int[]{2}, (int[])new int[]{3}, (int)0));
        Assert.assertFalse((boolean)ShapeUtils.areShapesCompatible((int[])new int[]{2, 4}, (int[])new int[]{3, 4}, (int)1));
        Assert.assertTrue((boolean)ShapeUtils.areShapesCompatible((int[])new int[]{2, 4}, (int[])new int[]{3, 4}, (int)0));
    }

    @Test
    public void testBroadcastCompatibleShapes() {
        Assert.assertTrue((String)"[] and []", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[0], (int[])new int[0]));
        Assert.assertTrue((String)"[1] and []", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{1}, (int[])new int[0]));
        Assert.assertTrue((String)"[2] and []", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{2}, (int[])new int[0]));
        Assert.assertTrue((String)"[2] and [2]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{2}, (int[])new int[]{2}));
        Assert.assertTrue((String)"[3] and [3]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{3}, (int[])new int[]{3}));
        Assert.assertTrue((String)"[1,2] and [2]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{1, 2}, (int[])new int[]{2}));
        Assert.assertTrue((String)"[2] and [1,2]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{2}, (int[])new int[]{1, 2}));
        Assert.assertTrue((String)"[4,2] and [1,2]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{4, 2}, (int[])new int[]{1, 2}));
        Assert.assertTrue((String)"[10,10] and [10,10,10]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{10, 10}, (int[])new int[]{10, 10, 10}));
        Assert.assertTrue((String)"[10,10,10] and [10,10]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{10, 10, 10}, (int[])new int[]{10, 10}));
        Assert.assertTrue((String)"[2] and [2,1,1,1]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{2}, (int[])new int[]{2, 1, 1, 1}));
        Assert.assertTrue((String)"[2,1] and [2,1,1,1]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{2, 1}, (int[])new int[]{2, 1, 1, 1}));
        Assert.assertTrue((String)"[2,1] and [3,1,1,2]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{2, 1}, (int[])new int[]{3, 1, 1, 2}));
        Assert.assertTrue((String)"[2,1] and [3,1,1,1]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{2, 1}, (int[])new int[]{3, 1, 1, 1}));
        Assert.assertTrue((String)"[1,2,1] and [2,1,1,1]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{1, 2, 1}, (int[])new int[]{2, 1, 1, 1}));
        Assert.assertTrue((String)"[1,2,1,3] and [2,1,1,1,3]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{1, 2, 1, 3}, (int[])new int[]{2, 1, 1, 1, 3}));
        Assert.assertTrue((String)"[2,1,1] and [1,1,2]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{2, 1, 1}, (int[])new int[]{1, 1, 2}));
        Assert.assertTrue((String)"[2,1,1] and [1,1,3]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{2, 1, 1}, (int[])new int[]{1, 1, 3}));
        Assert.assertFalse((String)"[2,1,4] and [2,1,1,3]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{2, 1, 4}, (int[])new int[]{2, 1, 1, 3}));
        Assert.assertFalse((String)"[2,1,4] and [2,1,3]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{2, 1, 4}, (int[])new int[]{2, 1, 3}));
        Assert.assertFalse((String)"[2,4] and [2,3]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{2, 4}, (int[])new int[]{2, 3}));
        Assert.assertTrue((String)"[2,1,4] and [2,1,4]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{2, 1, 4}, (int[])new int[]{2, 1, 4}));
        Assert.assertTrue((String)"[2,1,4] and [2,1,1,4]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{2, 1, 4}, (int[])new int[]{2, 1, 1, 4}));
        Assert.assertFalse((String)"[2,4] and [2,4,3]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{2, 4}, (int[])new int[]{2, 4, 3}));
        Assert.assertFalse((String)"[2,1,4] and [2,4,3]", (boolean)ShapeUtils.areShapesBroadcastCompatible((int[])new int[]{2, 1, 4}, (int[])new int[]{2, 4, 3}));
    }

    @Test
    public void testMaxMin() {
        Dataset a = DatasetFactory.createRange(DoubleDataset.class, (double)12.0);
        a.setShape(new int[]{3, 4});
        Assert.assertEquals((String)"Max", (double)11.0, (double)a.max(new boolean[0]).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((String)"Max 0", (Object)DatasetFactory.createFromObject((Object)new double[]{8.0, 9.0, 10.0, 11.0}), (Object)a.max(0, new boolean[0]));
        Assert.assertEquals((String)"Max 1", (Object)DatasetFactory.createFromObject((Object)new double[]{3.0, 7.0, 11.0}), (Object)a.max(1, new boolean[0]));
        Assert.assertEquals((String)"Max -2", (Object)DatasetFactory.createFromObject((Object)new double[]{8.0, 9.0, 10.0, 11.0}), (Object)a.max(-2, new boolean[0]));
        Assert.assertEquals((String)"Max -1", (Object)DatasetFactory.createFromObject((Object)new double[]{3.0, 7.0, 11.0}), (Object)a.max(-1, new boolean[0]));
        Assert.assertEquals((String)"Max arg", (long)11L, (long)a.argMax(new boolean[0]));
        Assert.assertEquals((String)"Max arg 0 ", (Object)DatasetFactory.createFromObject((Object)new int[]{2, 2, 2, 2}), (Object)a.argMax(0, new boolean[0]));
        Assert.assertEquals((String)"Max arg 1 ", (Object)DatasetFactory.createFromObject((Object)new int[]{3, 3, 3}), (Object)a.argMax(1, new boolean[0]));
        Assert.assertEquals((String)"Max arg -2 ", (Object)DatasetFactory.createFromObject((Object)new int[]{2, 2, 2, 2}), (Object)a.argMax(-2, new boolean[0]));
        Assert.assertEquals((String)"Max arg -1 ", (Object)DatasetFactory.createFromObject((Object)new int[]{3, 3, 3}), (Object)a.argMax(-1, new boolean[0]));
        a.set((Object)Double.NaN, 1, 0);
        System.out.println(a.toString(true));
        Assert.assertTrue((String)"Max", (boolean)Double.isNaN(a.max(new boolean[0]).doubleValue()));
        Assert.assertTrue((String)"Max", (!Double.isNaN(a.max(new boolean[]{true}).doubleValue()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Max 0", (boolean)AbstractDatasetTest.equalsWithNaNs(DatasetFactory.createFromObject((Object)new double[]{Double.NaN, 9.0, 10.0, 11.0}), a.max(0, new boolean[0])));
        Assert.assertTrue((String)"Max 1", (boolean)AbstractDatasetTest.equalsWithNaNs(DatasetFactory.createFromObject((Object)new double[]{3.0, Double.NaN, 11.0}), a.max(1, new boolean[0])));
        Assert.assertEquals((String)"Max arg", (long)4L, (long)a.argMax(new boolean[0]));
        Assert.assertEquals((String)"Max arg 0 ", (Object)DatasetFactory.createFromObject((Object)new int[]{1, 2, 2, 2}), (Object)a.argMax(0, new boolean[0]));
        int[] nArray = new int[3];
        nArray[0] = 3;
        nArray[2] = 3;
        Assert.assertEquals((String)"Max arg 1 ", (Object)DatasetFactory.createFromObject((Object)nArray), (Object)a.argMax(1, new boolean[0]));
        Assert.assertEquals((String)"Max", (double)11.0, (double)a.max(new boolean[]{true}).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((String)"Max 0", (Object)DatasetFactory.createFromObject((Object)new double[]{8.0, 9.0, 10.0, 11.0}), (Object)a.max(0, new boolean[]{true}));
        Assert.assertEquals((String)"Max 1", (Object)DatasetFactory.createFromObject((Object)new double[]{3.0, 7.0, 11.0}), (Object)a.max(1, new boolean[]{true}));
        Assert.assertEquals((String)"Max arg", (long)11L, (long)a.argMax(new boolean[]{true}));
        Assert.assertEquals((String)"Max arg 0 ", (Object)DatasetFactory.createFromObject((Object)new int[]{2, 2, 2, 2}), (Object)a.argMax(0, new boolean[]{true}));
        Assert.assertEquals((String)"Max arg 1 ", (Object)DatasetFactory.createFromObject((Object)new int[]{3, 3, 3}), (Object)a.argMax(1, new boolean[]{true}));
        a.set((Object)Double.NEGATIVE_INFINITY, 1, 1);
        System.out.println(a.toString(true));
        Assert.assertTrue((String)"Max", (boolean)Double.isNaN(a.max(new boolean[0]).doubleValue()));
        Assert.assertTrue((String)"Max", (!Double.isNaN(a.max(new boolean[]{true}).doubleValue()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Max", (boolean)Double.isNaN(a.max(new boolean[]{false, true}).doubleValue()));
        Assert.assertTrue((String)"Max", (!Double.isNaN(a.max(new boolean[]{true, false}).doubleValue()) ? 1 : 0) != 0);
        Assert.assertEquals((String)"Max", (double)11.0, (double)a.max(new boolean[]{true}).doubleValue(), (double)1.0E-6);
        Assert.assertTrue((String)"Min", (boolean)Double.isNaN(a.min(new boolean[0]).doubleValue()));
        Assert.assertTrue((String)"Min", (!Double.isNaN(a.min(new boolean[]{true}).doubleValue()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Min", (boolean)Double.isNaN(a.min(new boolean[]{false, true}).doubleValue()));
        Assert.assertTrue((String)"Min", (!Double.isNaN(a.min(new boolean[]{true, false}).doubleValue()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Min", (!Double.isInfinite(a.min(new boolean[0]).doubleValue()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Min", (!Double.isInfinite(a.min(new boolean[]{true}).doubleValue()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Min", (!Double.isInfinite(a.min(new boolean[]{false, true}).doubleValue()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Min", (boolean)Double.isInfinite(a.min(new boolean[]{true, false}).doubleValue()));
        Assert.assertEquals((String)"Min", (double)0.0, (double)a.min(new boolean[]{true}).doubleValue(), (double)1.0E-6);
        Dataset b = DatasetFactory.createRange(DoubleDataset.class, (double)12.0);
        b.setShape(new int[]{3, 4});
        b.mean(new boolean[0]);
        Assert.assertEquals((String)"Max", (double)11.0, (double)b.max(new boolean[0]).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((String)"Max arg", (long)11L, (long)b.argMax(new boolean[0]));
        b.set((Object)Double.NaN, 1, 0);
        b.mean(new boolean[0]);
        Assert.assertTrue((String)"Max", (boolean)Double.isNaN(b.max(new boolean[0]).doubleValue()));
        Assert.assertEquals((String)"Max arg", (long)4L, (long)b.argMax(new boolean[0]));
        b.mean(new boolean[]{true});
        Assert.assertEquals((String)"Max", (double)11.0, (double)b.max(new boolean[]{true}).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((String)"Max arg", (long)11L, (long)b.argMax(new boolean[]{true}));
        a = ((DoubleDataset)DatasetFactory.createRange(DoubleDataset.class, (double)12.0)).reshape(new int[]{3, 4});
        b = a.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), null), new Slice(Integer.valueOf(0), null, Integer.valueOf(2))});
        Dataset c = a.getSlice(new Slice[]{new Slice(Integer.valueOf(1), null), new Slice(Integer.valueOf(0), null, Integer.valueOf(2))});
        Assert.assertEquals((long)c.argMax(new boolean[0]), (long)b.argMax(new boolean[0]));
        Assert.assertEquals((long)c.argMin(new boolean[0]), (long)b.argMin(new boolean[0]));
    }

    @Test
    public void testGetSpeed() {
        int ITERATIONS = 1000;
        Dataset a = DatasetFactory.createRange(DoubleDataset.class, (double)1000000.0);
        long start = -System.nanoTime();
        int i = 0;
        while (i < 10) {
            a.getDouble(i);
            ++i;
        }
        start += System.nanoTime();
        start = -System.nanoTime();
        i = 0;
        while (i < 1000) {
            a.getDouble(i);
            ++i;
        }
        start += System.nanoTime();
        long startN = -System.nanoTime();
        i = 0;
        while (i < 1000) {
            a.getDouble(new int[]{i++});
        }
        startN += System.nanoTime();
        long startP = -System.nanoTime();
        int[] pos = new int[1];
        int i2 = 0;
        while (i2 < 1000) {
            pos[0] = i2++;
            a.getDouble(pos);
        }
        System.out.printf("Get 1D double took %gus (cf %gus and %gus)\n", (double)start * 0.001 / 1000.0, (double)startN * 0.001 / 1000.0, (double)(startP += System.nanoTime()) * 0.001 / 1000.0);
        a.setShape(new int[]{1000, 1000});
        start = -System.nanoTime();
        i2 = 0;
        while (i2 < 10) {
            a.getDouble(i2, i2);
            ++i2;
        }
        start += System.nanoTime();
        start = -System.nanoTime();
        i2 = 0;
        while (i2 < 1000) {
            a.getDouble(i2, i2);
            ++i2;
        }
        start += System.nanoTime();
        startN = -System.nanoTime();
        i2 = 0;
        while (i2 < 1000) {
            a.getDouble(new int[]{i2, i2++});
        }
        startN += System.nanoTime();
        startP = -System.nanoTime();
        pos = new int[2];
        i2 = 0;
        while (i2 < 1000) {
            pos[0] = i2;
            pos[1] = i2++;
            a.getDouble(pos);
        }
        System.out.printf("Get 2D double took %gus (cf %gus and %gus)\n", (double)start * 0.001 / 1000.0, (double)startN * 0.001 / 1000.0, (double)(startP += System.nanoTime()) * 0.001 / 1000.0);
    }

    @Test
    public void testHash() {
        Dataset a = DatasetFactory.createRange(DoubleDataset.class, (double)12.0);
        a.setShape(new int[]{3, 4});
        Dataset b = DatasetFactory.createRange(DoubleDataset.class, (double)12.0);
        b.setShape(new int[]{3, 4});
        b.mean(new boolean[0]);
        Assert.assertEquals((String)"Hash code", (long)a.hashCode(), (long)b.hashCode());
        a.set((Object)Double.POSITIVE_INFINITY, 1, 0);
        b.set((Object)Double.POSITIVE_INFINITY, 1, 0);
        b.mean(new boolean[0]);
        Assert.assertEquals((String)"Hash code", (long)a.hashCode(), (long)b.hashCode());
        a.set((Object)Double.NaN, 0, 1);
        b.set((Object)Double.NaN, 0, 1);
        b.mean(new boolean[0]);
        Assert.assertEquals((String)"Hash code", (long)a.hashCode(), (long)b.hashCode());
    }

    private static boolean equalsWithNaNs(Dataset a, Dataset b) {
        if (a.equals(b)) {
            return true;
        }
        IndexIterator ita = a.getIterator();
        IndexIterator itb = b.getIterator();
        while (ita.hasNext() && itb.hasNext()) {
            double av = a.getElementDoubleAbs(ita.index);
            double bv = b.getElementDoubleAbs(itb.index);
            if (!(Double.isNaN(av) ? !Double.isNaN(bv) : av != bv)) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testMaxSpeed() {
        long start;
        int ITERATIONS = 200;
        Dataset a = DatasetFactory.createRange(DoubleDataset.class, (double)1000000.0);
        int i = 0;
        while (i < 10) {
            a.set((Object)1, 0);
            start = -System.nanoTime();
            a.max(new boolean[0]);
            start += System.nanoTime();
            ++i;
        }
        long elapsed = 0L;
        i = 0;
        while (i < 200) {
            a.set((Object)1, 0);
            start = -System.nanoTime();
            a.max(new boolean[0]);
            elapsed += (start += System.nanoTime());
            ++i;
        }
        System.out.printf("Max double calculation took %g ms\n", (double)elapsed * 1.0E-6 / 200.0);
        a = DatasetFactory.createRange(ShortDataset.class, (double)1000000.0);
        elapsed = 0L;
        i = 0;
        while (i < 200) {
            a.set((Object)1, 0);
            start = -System.nanoTime();
            a.max(new boolean[0]);
            elapsed += (start += System.nanoTime());
            ++i;
        }
        System.out.printf("Max short calculation took %g ms\n", (double)elapsed * 1.0E-6 / 200.0);
    }

    @Test
    public void testSort() {
        Dataset a = DatasetFactory.createRange(DoubleDataset.class, (double)12.0);
        a.set((Object)Double.NaN, 0);
        a.setShape(new int[]{3, 4});
        a.sort(Integer.valueOf(-1));
        TestUtils.verbosePrintf((String)"%s\n", (Object[])new Object[]{a.toString()});
        Assert.assertEquals((String)"First element", (double)1.0, (double)a.getDouble(0, 0), (double)1.0E-6);
        Assert.assertTrue((String)"0,3 element", (boolean)Double.isNaN(a.getDouble(0, 3)));
        Assert.assertEquals((String)"Final element", (double)11.0, (double)a.getDouble(2, 3), (double)1.0E-6);
        a.sort(Integer.valueOf(0));
        TestUtils.verbosePrintf((String)"%s\n", (Object[])new Object[]{a.toString()});
        Assert.assertEquals((String)"First element", (double)1.0, (double)a.getDouble(0, 0), (double)1.0E-6);
        Assert.assertEquals((String)"0,3 element", (double)7.0, (double)a.getDouble(0, 3), (double)1.0E-6);
        Assert.assertTrue((String)"Final element", (boolean)Double.isNaN(a.getDouble(2, 3)));
        a.set((Object)12, 0, 0);
        a.sort(null);
        TestUtils.verbosePrintf((String)"%s\n", (Object[])new Object[]{a.toString()});
        Assert.assertEquals((String)"First element", (double)2.0, (double)a.getDouble(0, 0), (double)1.0E-6);
        Assert.assertEquals((String)"2,2 element", (double)12.0, (double)a.getDouble(2, 2), (double)1.0E-6);
        Assert.assertTrue((String)"Final element", (boolean)Double.isNaN(a.getDouble(2, 3)));
        a = DatasetFactory.createRange(DoubleDataset.class, (double)12.0);
        Dataset b = a.getSliceView(new Slice[]{new Slice(null, null, Integer.valueOf(-2))});
        b.sort(null);
        Assert.assertEquals((String)"First element", (double)1.0, (double)b.getDouble(0), (double)1.0E-6);
        Assert.assertEquals((String)"Final element", (double)11.0, (double)b.getDouble(5), (double)1.0E-6);
        Assert.assertEquals((String)"First element", (double)0.0, (double)a.getDouble(0), (double)1.0E-6);
        Assert.assertEquals((String)"Second element", (double)11.0, (double)a.getDouble(1), (double)1.0E-6);
        Assert.assertEquals((String)"Final element", (double)1.0, (double)a.getDouble(11), (double)1.0E-6);
        b = DatasetFactory.createRange(IntegerDataset.class, (double)12.0);
        a = b.getSlice(new Slice[]{new Slice(null, null, Integer.valueOf(-1))}).cast(ShortDataset.class);
        DatasetUtils.sort((Dataset)a, (Dataset[])new Dataset[]{b});
        Assert.assertEquals((String)"First element", (long)0L, (long)a.getInt(0));
        Assert.assertEquals((String)"Second element", (long)1L, (long)a.getInt(1));
        Assert.assertEquals((String)"First element", (long)11L, (long)b.getInt(0));
        Assert.assertEquals((String)"Second element", (long)10L, (long)b.getInt(1));
    }

    @Test
    public void testPut() {
        Dataset d1 = DatasetFactory.createRange(DoubleDataset.class, (double)6.0);
        DatasetUtils.put((Dataset)d1, (int[])new int[]{2, 5}, (Object)DatasetFactory.createFromObject((Object)new double[]{-2.0, -5.5}));
        TestUtils.assertDatasetEquals((Dataset)d1, (Dataset)DatasetFactory.createFromObject((Object)new double[]{0.0, 1.0, -2.0, 3.0, 4.0, -5.5}));
        int[] nArray = new int[2];
        nArray[1] = 4;
        DatasetUtils.put((Dataset)d1, (Dataset)DatasetFactory.createFromObject((Object)nArray), (Object)DatasetFactory.createFromObject((Object)new double[]{-2.0, -5.5}));
        TestUtils.assertDatasetEquals((Dataset)d1, (Dataset)DatasetFactory.createFromObject((Object)new double[]{-2.0, 1.0, -2.0, 3.0, -5.5, -5.5}));
        d1 = ((DoubleDataset)DatasetFactory.createRange(DoubleDataset.class, (double)6.0)).reshape(new int[]{2, 3});
        DatasetUtils.put((Dataset)d1, (int[])new int[]{2, 5}, (Object)DatasetFactory.createFromObject((Object)new double[]{-2.0, -5.5}));
        TestUtils.assertDatasetEquals((Dataset)d1, (Dataset)DatasetFactory.createFromObject((Object)new double[]{0.0, 1.0, -2.0, 3.0, 4.0, -5.5}).reshape(new int[]{2, 3}));
        int[] nArray2 = new int[2];
        nArray2[1] = 4;
        DatasetUtils.put((Dataset)d1, (Dataset)DatasetFactory.createFromObject((Object)nArray2), (Object)DatasetFactory.createFromObject((Object)new double[]{-2.0, -5.5}));
        TestUtils.assertDatasetEquals((Dataset)d1, (Dataset)DatasetFactory.createFromObject((Object)new double[]{-2.0, 1.0, -2.0, 3.0, -5.5, -5.5}).reshape(new int[]{2, 3}));
    }

    @Test
    public void testTake() {
        Dataset a = DatasetFactory.createRange(DoubleDataset.class, (double)12.0);
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 4;
        Dataset t = DatasetUtils.take((Dataset)a, (int[])nArray, null);
        TestUtils.verbosePrintf((String)"%s\n", (Object[])new Object[]{t.toString()});
        int[] nArray2 = new int[3];
        nArray2[1] = 2;
        nArray2[2] = 4;
        t = DatasetUtils.take((Dataset)a, (int[])nArray2, (Integer)0);
        TestUtils.verbosePrintf((String)"%s\n", (Object[])new Object[]{t.toString()});
        a.setShape(new int[]{3, 4});
        TestUtils.verbosePrintf((String)"%s\n", (Object[])new Object[]{a.toString()});
        t = DatasetUtils.take((Dataset)a, (int[])new int[1], (Integer)0);
        TestUtils.verbosePrintf((String)"%s\n", (Object[])new Object[]{t.toString()});
        t = DatasetUtils.take((Dataset)a, (int[])new int[]{1}, (Integer)0);
        TestUtils.verbosePrintf((String)"%s\n", (Object[])new Object[]{t.toString()});
        t = DatasetUtils.take((Dataset)a, (int[])new int[]{2}, (Integer)0);
        TestUtils.verbosePrintf((String)"%s\n", (Object[])new Object[]{t.toString()});
        t = DatasetUtils.take((Dataset)a, (int[])new int[1], (Integer)1);
        TestUtils.verbosePrintf((String)"%s\n", (Object[])new Object[]{t.toString()});
        t = DatasetUtils.take((Dataset)a, (int[])new int[]{1}, (Integer)1);
        TestUtils.verbosePrintf((String)"%s\n", (Object[])new Object[]{t.toString()});
        t = DatasetUtils.take((Dataset)a, (int[])new int[]{2}, (Integer)1);
        TestUtils.verbosePrintf((String)"%s\n", (Object[])new Object[]{t.toString()});
        t = DatasetUtils.take((Dataset)a, (int[])new int[]{3}, (Integer)1);
        TestUtils.verbosePrintf((String)"%s\n", (Object[])new Object[]{t.toString()});
    }

    @Test
    public void testSqueeze() {
        Dataset ds = DatasetFactory.createRange(DoubleDataset.class, (double)10.0);
        ds.setShape(new int[]{2, 1, 5});
        ds.squeeze();
        Assert.assertEquals((long)2L, (long)ds.getShapeRef().length);
        Assert.assertEquals((long)2L, (long)ds.getShapeRef()[0]);
        Assert.assertEquals((long)5L, (long)ds.getShapeRef()[1]);
        int[] os = new int[]{1, 1};
        int[] ns = ShapeUtils.squeezeShape((int[])os, (boolean)false);
        Assert.assertEquals((long)0L, (long)ns.length);
        ns = ShapeUtils.squeezeShape((int[])os, (boolean)true);
        Assert.assertEquals((long)0L, (long)ns.length);
        os = new int[]{2, 1, 5};
        ns = ShapeUtils.squeezeShape((int[])os, (boolean)false);
        Assert.assertEquals((long)2L, (long)ns.length);
        Assert.assertEquals((long)2L, (long)ns[0]);
        Assert.assertEquals((long)5L, (long)ns[1]);
        ns = ShapeUtils.squeezeShape((int[])os, (boolean)true);
        Assert.assertEquals((long)3L, (long)ns.length);
        Assert.assertEquals((long)2L, (long)ns[0]);
        Assert.assertEquals((long)1L, (long)ns[1]);
        Assert.assertEquals((long)5L, (long)ns[2]);
        os = new int[]{2, 1, 5, 1};
        ns = ShapeUtils.squeezeShape((int[])os, (boolean)false);
        Assert.assertEquals((long)2L, (long)ns.length);
        Assert.assertEquals((long)2L, (long)ns[0]);
        Assert.assertEquals((long)5L, (long)ns[1]);
        ns = ShapeUtils.squeezeShape((int[])os, (boolean)true);
        Assert.assertEquals((long)3L, (long)ns.length);
        Assert.assertEquals((long)2L, (long)ns[0]);
        Assert.assertEquals((long)1L, (long)ns[1]);
        Assert.assertEquals((long)5L, (long)ns[2]);
        os = new int[]{1, 2, 1, 5};
        ns = ShapeUtils.squeezeShape((int[])os, (boolean)false);
        Assert.assertEquals((long)2L, (long)ns.length);
        Assert.assertEquals((long)2L, (long)ns[0]);
        Assert.assertEquals((long)5L, (long)ns[1]);
        ns = ShapeUtils.squeezeShape((int[])os, (boolean)true);
        Assert.assertEquals((long)3L, (long)ns.length);
        Assert.assertEquals((long)2L, (long)ns[0]);
        Assert.assertEquals((long)1L, (long)ns[1]);
        Assert.assertEquals((long)5L, (long)ns[2]);
        os = new int[]{1, 2, 1, 5, 1};
        ns = ShapeUtils.squeezeShape((int[])os, (boolean)false);
        Assert.assertEquals((long)2L, (long)ns.length);
        Assert.assertEquals((long)2L, (long)ns[0]);
        Assert.assertEquals((long)5L, (long)ns[1]);
        ns = ShapeUtils.squeezeShape((int[])os, (boolean)true);
        Assert.assertEquals((long)3L, (long)ns.length);
        Assert.assertEquals((long)2L, (long)ns[0]);
        Assert.assertEquals((long)1L, (long)ns[1]);
        Assert.assertEquals((long)5L, (long)ns[2]);
    }

    @Test
    public void testTile() {
        Dataset ds = DatasetFactory.createRange(DoubleDataset.class, (double)3.0);
        Dataset ta = DatasetUtils.tile((IDataset)ds, (int[])new int[]{2});
        double[] xa = new double[]{0.0, 1.0, 2.0, 0.0, 1.0, 2.0};
        Assert.assertEquals((long)1L, (long)ta.getShapeRef().length);
        Assert.assertEquals((long)6L, (long)ta.getShapeRef()[0]);
        int i = 0;
        while (i < xa.length) {
            Assert.assertEquals((double)xa[i], (double)((DoubleDataset)ta).getData()[i], (double)1.0E-6);
            ++i;
        }
        Dataset tb = DatasetUtils.tile((IDataset)ds, (int[])new int[]{1, 2});
        Assert.assertEquals((long)2L, (long)tb.getShapeRef().length);
        Assert.assertEquals((long)1L, (long)tb.getShapeRef()[0]);
        Assert.assertEquals((long)6L, (long)tb.getShapeRef()[1]);
        int i2 = 0;
        while (i2 < xa.length) {
            Assert.assertEquals((double)xa[i2], (double)((DoubleDataset)tb).getData()[i2], (double)1.0E-6);
            ++i2;
        }
        Dataset tc = DatasetUtils.tile((IDataset)ds, (int[])new int[]{2, 1});
        Assert.assertEquals((long)2L, (long)tc.getShapeRef().length);
        Assert.assertEquals((long)2L, (long)tc.getShapeRef()[0]);
        Assert.assertEquals((long)3L, (long)tc.getShapeRef()[1]);
        int i3 = 0;
        while (i3 < xa.length) {
            Assert.assertEquals((double)xa[i3], (double)((DoubleDataset)tc).getData()[i3], (double)1.0E-6);
            ++i3;
        }
        ds = DatasetFactory.createRange(DoubleDataset.class, (double)6.0);
        ds.setShape(new int[]{2, 3});
        Dataset td = DatasetUtils.tile((IDataset)ds, (int[])new int[]{2});
        double[] xd = new double[]{0.0, 1.0, 2.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 3.0, 4.0, 5.0};
        Assert.assertEquals((long)2L, (long)td.getShapeRef().length);
        Assert.assertEquals((long)2L, (long)td.getShapeRef()[0]);
        Assert.assertEquals((long)6L, (long)td.getShapeRef()[1]);
        int i4 = 0;
        while (i4 < xd.length) {
            Assert.assertEquals((double)xd[i4], (double)((DoubleDataset)td).getData()[i4], (double)1.0E-6);
            ++i4;
        }
        Dataset te = DatasetUtils.tile((IDataset)ds, (int[])new int[]{1, 2});
        Assert.assertEquals((long)2L, (long)te.getShapeRef().length);
        Assert.assertEquals((long)2L, (long)te.getShapeRef()[0]);
        Assert.assertEquals((long)6L, (long)te.getShapeRef()[1]);
        int i5 = 0;
        while (i5 < xd.length) {
            Assert.assertEquals((double)xd[i5], (double)((DoubleDataset)te).getData()[i5], (double)1.0E-6);
            ++i5;
        }
        Dataset tf = DatasetUtils.tile((IDataset)ds, (int[])new int[]{2, 1});
        double[] xf = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        Assert.assertEquals((long)2L, (long)tf.getShapeRef().length);
        Assert.assertEquals((long)4L, (long)tf.getShapeRef()[0]);
        Assert.assertEquals((long)3L, (long)tf.getShapeRef()[1]);
        int i6 = 0;
        while (i6 < xf.length) {
            Assert.assertEquals((double)xf[i6], (double)((DoubleDataset)tf).getData()[i6], (double)1.0E-6);
            ++i6;
        }
    }

    @Test
    public void testTileSpeed() {
        int[][] blocks = new int[][]{{1024, 1}, {256, 4}, {64, 16}, {32, 32}, {16, 64}, {4, 256}, {1, 1024}};
        int[][] shapes = new int[][]{{1024, 2048}, {2048, 2048}, {2048, 1024}};
        int b = 0;
        while (b < blocks.length) {
            int s = 0;
            while (s < shapes.length) {
                int n = 0;
                while (n < 3) {
                    this.runTile(blocks[b][0], blocks[b][1], shapes[s][0], shapes[s][1]);
                    ++n;
                }
                ++s;
            }
            ++b;
        }
    }

    private void runTile(int srows, int scols, int rows, int cols) {
        int i;
        Dataset a = ((DoubleDataset)DatasetFactory.createRange(DoubleDataset.class, (double)(srows * scols))).reshape(new int[]{srows, scols});
        TestUtils.verbosePrintf((String)"Tile %sx%d Block %dx%d: ", (Object[])new Object[]{rows, cols, srows, scols});
        int nrows = rows / srows;
        int ncols = cols / scols;
        long start = System.currentTimeMillis();
        DoubleDataset b = (DoubleDataset)DatasetFactory.zeros(DoubleDataset.class, (int[])new int[]{rows, cols});
        double[] da = (double[])a.getBuffer();
        double[] db = b.getData();
        if (scols == 1) {
            i = 0;
            while (i < db.length) {
                db[i] = da[i / cols % srows];
                ++i;
            }
        } else if (srows == 1) {
            i = 0;
            while (i < db.length) {
                db[i] = da[i % scols];
                ++i;
            }
        } else {
            i = 0;
            while (i < db.length) {
                db[i] = da[i / cols % srows * scols + i % scols];
                ++i;
            }
        }
        long end = System.currentTimeMillis();
        long diff1 = end - start;
        TestUtils.verbosePrintf((String)"array = %d ms, ", (Object[])new Object[]{diff1});
        start = System.currentTimeMillis();
        Dataset tiled = DatasetUtils.tile((IDataset)a, (int[])new int[]{nrows, ncols});
        end = System.currentTimeMillis();
        long diff2 = end - start;
        TestUtils.verbosePrintf((String)"tile = %d ms\n", (Object[])new Object[]{diff2});
        Assert.assertEquals((long)rows, (long)tiled.getShapeRef()[0]);
        Assert.assertEquals((long)cols, (long)tiled.getShapeRef()[1]);
        Assert.assertEquals((String)"Datasets not equal", (Object)tiled, (Object)b);
        Assert.assertTrue((String)("Creation of tile took more than 50x as long as array creation of same size! (It took " + diff2 + "ms)"), (diff2 <= diff1 * 50L ? 1 : 0) != 0);
    }

    @Test
    public void testTranspose() {
        int k;
        int j;
        Dataset ds = DatasetFactory.createFromObject(DoubleDataset.class, null);
        TestUtils.assertDatasetEquals((Dataset)ds, (Dataset)ds.transpose(new int[0]));
        ds = DatasetFactory.createRange(DoubleDataset.class, (double)6.0);
        TestUtils.assertDatasetEquals((Dataset)ds, (Dataset)ds.transpose(new int[0]));
        ds.setShape(new int[]{2, 3});
        Dataset ta = DatasetUtils.transpose((IDataset)ds, (int[])new int[]{1, 0});
        double[][] xa = new double[][]{{0.0, 1.0, 2.0}, {3.0, 4.0, 5.0}};
        Assert.assertEquals((long)2L, (long)ta.getShapeRef().length);
        Assert.assertEquals((long)3L, (long)ta.getShapeRef()[0]);
        Assert.assertEquals((long)2L, (long)ta.getShapeRef()[1]);
        int i = 0;
        while (i < 2) {
            int j2 = 0;
            while (j2 < 3) {
                Assert.assertEquals((double)xa[i][j2], (double)ta.getDouble(j2, i), (double)1.0E-6);
                ++j2;
            }
            ++i;
        }
        TestUtils.assertDatasetEquals((Dataset)ta, (Dataset)ds.getTransposedView(new int[]{1, 0}).getSlice(new Slice[0]));
        ds.set((Object)-2, 1, 2);
        Assert.assertEquals((double)-2.0, (double)ds.getDouble(1, 2), (double)1.0E-6);
        Assert.assertEquals((double)5.0, (double)ta.getDouble(2, 1), (double)1.0E-6);
        ta = ds.getTransposedView(new int[0]);
        Assert.assertEquals((double)-2.0, (double)ta.getDouble(2, 1), (double)1.0E-6);
        ds = DatasetFactory.createRange(DoubleDataset.class, (double)24.0);
        ds.setShape(new int[]{2, 3, 4});
        double[][][] xb = new double[][][]{new double[][]{{0.0, 1.0, 2.0, 3.0}, {4.0, 5.0, 6.0, 7.0}, {8.0, 9.0, 10.0, 11.0}}, new double[][]{{12.0, 13.0, 14.0, 15.0}, {16.0, 17.0, 18.0, 19.0}, {20.0, 21.0, 22.0, 23.0}}};
        try {
            Dataset tb = DatasetUtils.transpose((IDataset)ds, (int[])new int[]{0});
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
        try {
            Dataset tb = DatasetUtils.transpose((IDataset)ds, (int[])new int[]{0, -1, 0});
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
        try {
            Dataset tb = DatasetUtils.transpose((IDataset)ds, (int[])new int[]{0, 1, 1});
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
        Dataset tb = DatasetUtils.transpose((IDataset)ds, (int[])new int[]{0, 1, 2});
        Assert.assertEquals((long)3L, (long)tb.getShapeRef().length);
        Assert.assertEquals((long)2L, (long)tb.getShapeRef()[0]);
        Assert.assertEquals((long)3L, (long)tb.getShapeRef()[1]);
        Assert.assertEquals((long)4L, (long)tb.getShapeRef()[2]);
        int i2 = 0;
        while (i2 < 2) {
            j = 0;
            while (j < 3) {
                k = 0;
                while (k < 4) {
                    Assert.assertEquals((double)xb[i2][j][k], (double)tb.getDouble(new int[]{i2, j, k}), (double)1.0E-6);
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        tb = DatasetUtils.transpose((IDataset)ds, (int[])new int[]{1, 0, 2});
        Assert.assertEquals((long)3L, (long)tb.getShapeRef().length);
        Assert.assertEquals((long)3L, (long)tb.getShapeRef()[0]);
        Assert.assertEquals((long)2L, (long)tb.getShapeRef()[1]);
        Assert.assertEquals((long)4L, (long)tb.getShapeRef()[2]);
        i2 = 0;
        while (i2 < 2) {
            j = 0;
            while (j < 3) {
                k = 0;
                while (k < 4) {
                    Assert.assertEquals((double)xb[i2][j][k], (double)tb.getDouble(new int[]{j, i2, k}), (double)1.0E-6);
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        tb = DatasetUtils.transpose((IDataset)ds, (int[])new int[]{2, 0, 1});
        Assert.assertEquals((long)3L, (long)tb.getShapeRef().length);
        Assert.assertEquals((long)4L, (long)tb.getShapeRef()[0]);
        Assert.assertEquals((long)2L, (long)tb.getShapeRef()[1]);
        Assert.assertEquals((long)3L, (long)tb.getShapeRef()[2]);
        i2 = 0;
        while (i2 < 2) {
            j = 0;
            while (j < 3) {
                k = 0;
                while (k < 4) {
                    Assert.assertEquals((double)xb[i2][j][k], (double)tb.getDouble(new int[]{k, i2, j}), (double)1.0E-6);
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
    }

    @Test
    public void testRepeat() {
        Dataset ds = DatasetFactory.createRange(DoubleDataset.class, (double)6.0);
        ds.setShape(new int[]{2, 3});
        double[] xa = new double[]{0.0, 0.0, 1.0, 1.0, 2.0, 2.0, 3.0, 3.0, 4.0, 4.0, 5.0, 5.0};
        DoubleDataset ta = (DoubleDataset)DatasetUtils.repeat((Dataset)ds, (int[])new int[]{2}, (int)-1);
        Assert.assertEquals((long)1L, (long)ta.getShapeRef().length);
        Assert.assertEquals((long)12L, (long)ta.getShapeRef()[0]);
        int i = 0;
        while (i < 12) {
            Assert.assertEquals((double)xa[i], (double)ta.get(i), (double)1.0E-6);
            ++i;
        }
        double[][] xb = new double[][]{{0.0, 0.0, 1.0, 1.0, 2.0, 2.0}, {3.0, 3.0, 4.0, 4.0, 5.0, 5.0}};
        DoubleDataset tb = (DoubleDataset)DatasetUtils.repeat((Dataset)ds, (int[])new int[]{2}, (int)1);
        Assert.assertEquals((long)2L, (long)tb.getShapeRef().length);
        Assert.assertEquals((long)2L, (long)tb.getShapeRef()[0]);
        Assert.assertEquals((long)6L, (long)tb.getShapeRef()[1]);
        int i2 = 0;
        while (i2 < 2) {
            int j = 0;
            while (j < 6) {
                Assert.assertEquals((double)xb[i2][j], (double)tb.get(i2, j), (double)1.0E-6);
                ++j;
            }
            ++i2;
        }
        double[][] xc = new double[][]{{0.0, 1.0, 2.0}, {0.0, 1.0, 2.0}, {3.0, 4.0, 5.0}, {3.0, 4.0, 5.0}};
        DoubleDataset tc = (DoubleDataset)DatasetUtils.repeat((Dataset)ds, (int[])new int[]{2}, (int)0);
        Assert.assertEquals((long)2L, (long)tc.getShapeRef().length);
        Assert.assertEquals((long)4L, (long)tc.getShapeRef()[0]);
        Assert.assertEquals((long)3L, (long)tc.getShapeRef()[1]);
        int i3 = 0;
        while (i3 < 4) {
            int j = 0;
            while (j < 3) {
                Assert.assertEquals((double)xc[i3][j], (double)tc.get(i3, j), (double)1.0E-6);
                ++j;
            }
            ++i3;
        }
        double[][] xd = new double[][]{{0.0, 1.0, 2.0}, {0.0, 1.0, 2.0}, {3.0, 4.0, 5.0}};
        DoubleDataset td = (DoubleDataset)DatasetUtils.repeat((Dataset)ds, (int[])new int[]{2, 1}, (int)0);
        Assert.assertEquals((long)2L, (long)td.getShapeRef().length);
        Assert.assertEquals((long)3L, (long)td.getShapeRef()[0]);
        Assert.assertEquals((long)3L, (long)td.getShapeRef()[1]);
        int i4 = 0;
        while (i4 < 3) {
            int j = 0;
            while (j < 3) {
                Assert.assertEquals((double)xd[i4][j], (double)td.get(i4, j), (double)1.0E-6);
                ++j;
            }
            ++i4;
        }
        double[][] xe = new double[][]{{0.0, 1.0, 1.0, 2.0, 2.0, 2.0}, {3.0, 4.0, 4.0, 5.0, 5.0, 5.0}};
        DoubleDataset te = (DoubleDataset)DatasetUtils.repeat((Dataset)ds, (int[])new int[]{1, 2, 3}, (int)1);
        Assert.assertEquals((long)2L, (long)te.getShapeRef().length);
        Assert.assertEquals((long)2L, (long)te.getShapeRef()[0]);
        Assert.assertEquals((long)6L, (long)te.getShapeRef()[1]);
        int i5 = 0;
        while (i5 < 2) {
            int j = 0;
            while (j < 6) {
                Assert.assertEquals((double)xe[i5][j], (double)te.get(i5, j), (double)1.0E-6);
                ++j;
            }
            ++i5;
        }
        double[] xf = new double[]{0.0, 1.0, 2.0, 2.0, 5.0, 5.0, 5.0};
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[5] = 3;
        DoubleDataset tf = (DoubleDataset)DatasetUtils.repeat((Dataset)ds, (int[])nArray, (int)-1);
        Assert.assertEquals((long)1L, (long)tf.getShapeRef().length);
        Assert.assertEquals((long)7L, (long)tf.getShapeRef()[0]);
        int i222 = 0;
        while (i222 < 7) {
            Assert.assertEquals((double)xf[i222], (double)tf.get(i222), (double)1.0E-6);
            ++i222;
        }
        try {
            tf = (DoubleDataset)DatasetUtils.repeat((Dataset)ds, (int[])new int[1], (int)3);
        }
        catch (IllegalArgumentException i222) {
        }
        catch (Exception e) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
        try {
            tf = (DoubleDataset)DatasetUtils.repeat((Dataset)ds, (int[])new int[]{2, 1}, (int)-1);
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
        try {
            tf = (DoubleDataset)DatasetUtils.repeat((Dataset)ds, (int[])new int[]{-1}, (int)-1);
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
    }

    @Test
    public void testResize() {
        int size = 6;
        Dataset ds = DatasetFactory.createRange(DoubleDataset.class, (double)size);
        Dataset tf = DatasetUtils.resize((Dataset)ds, (int[])new int[]{3});
        Assert.assertArrayEquals((int[])new int[]{3}, (int[])tf.getShapeRef());
        IndexIterator it = tf.getIterator();
        while (it.hasNext()) {
            Assert.assertEquals((double)(it.index % size), (double)tf.getElementDoubleAbs(it.index), (double)1.0E-6);
        }
        tf = DatasetUtils.resize((Dataset)ds, (int[])new int[]{8});
        Assert.assertArrayEquals((int[])new int[]{8}, (int[])tf.getShapeRef());
        it = tf.getIterator();
        while (it.hasNext()) {
            Assert.assertEquals((double)(it.index % size), (double)tf.getElementDoubleAbs(it.index), (double)1.0E-6);
        }
        tf = DatasetUtils.resize((Dataset)ds, (int[])new int[]{3, 4});
        Assert.assertArrayEquals((int[])new int[]{3, 4}, (int[])tf.getShapeRef());
        it = tf.getIterator();
        while (it.hasNext()) {
            Assert.assertEquals((double)(it.index % size), (double)tf.getElementDoubleAbs(it.index), (double)1.0E-6);
        }
        ds.setShape(new int[]{2, 3});
        tf = DatasetUtils.resize((Dataset)ds, (int[])new int[]{3});
        Assert.assertArrayEquals((int[])new int[]{3}, (int[])tf.getShapeRef());
        it = tf.getIterator();
        while (it.hasNext()) {
            Assert.assertEquals((double)(it.index % size), (double)tf.getElementDoubleAbs(it.index), (double)1.0E-6);
        }
        tf = DatasetUtils.resize((Dataset)ds, (int[])new int[]{8});
        Assert.assertArrayEquals((int[])new int[]{8}, (int[])tf.getShapeRef());
        it = tf.getIterator();
        while (it.hasNext()) {
            Assert.assertEquals((double)(it.index % size), (double)tf.getElementDoubleAbs(it.index), (double)1.0E-6);
        }
        tf = DatasetUtils.resize((Dataset)ds, (int[])new int[]{3, 4});
        Assert.assertArrayEquals((int[])new int[]{3, 4}, (int[])tf.getShapeRef());
        it = tf.getIterator();
        while (it.hasNext()) {
            Assert.assertEquals((double)(it.index % size), (double)tf.getElementDoubleAbs(it.index), (double)1.0E-6);
        }
    }

    @Test
    public void testContents() {
        double[] x = new double[]{0.0, 2.0, -12.3};
        double[] y = new double[]{2.3, Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        double[] z = new double[]{1.0E14, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        Dataset ta = DatasetFactory.createFromObject((Object)x);
        Assert.assertEquals((Object)false, (Object)ta.containsNans());
        Assert.assertEquals((Object)false, (Object)ta.containsInfs());
        Dataset tb = DatasetFactory.createFromObject((Object)y);
        Assert.assertEquals((Object)true, (Object)tb.containsNans());
        Assert.assertEquals((Object)true, (Object)tb.containsInfs());
        Assert.assertEquals((Object)true, (Object)Double.isNaN(tb.min(new boolean[0]).doubleValue()));
        Assert.assertEquals((Object)false, (Object)Double.isInfinite(tb.min(new boolean[0]).doubleValue()));
        Assert.assertEquals((Object)true, (Object)Double.isNaN(tb.max(new boolean[0]).doubleValue()));
        Assert.assertEquals((Object)false, (Object)Double.isInfinite(tb.max(new boolean[0]).doubleValue()));
        Dataset f = tb.cast(FloatDataset.class);
        Assert.assertEquals((Object)true, (Object)f.containsNans());
        Assert.assertEquals((Object)true, (Object)f.containsInfs());
        Assert.assertEquals((Object)true, (Object)Double.isNaN(f.min(new boolean[0]).doubleValue()));
        Assert.assertEquals((Object)false, (Object)Double.isInfinite(f.min(new boolean[0]).doubleValue()));
        Assert.assertEquals((Object)true, (Object)Double.isNaN(f.max(new boolean[0]).doubleValue()));
        Assert.assertEquals((Object)false, (Object)Double.isInfinite(f.max(new boolean[0]).doubleValue()));
        Dataset tc = DatasetFactory.createFromObject((Object)z);
        Assert.assertEquals((Object)true, (Object)Double.isInfinite(tc.min(new boolean[0]).doubleValue()));
        Assert.assertEquals((Object)true, (Object)Double.isInfinite(tc.max(new boolean[0]).doubleValue()));
    }

    @Test
    public void testView() {
        Dataset a = DatasetFactory.createRange(DoubleDataset.class, (double)60.0);
        Dataset b = a.getView(true);
        Assert.assertEquals((Object)true, (Object)a.equals(b));
        a.setShape(new int[]{5, 3, 4});
        b = a.getTransposedView(new int[0]);
        int i = 0;
        while (i < 5) {
            int j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 4) {
                    Assert.assertEquals((double)a.getDouble(new int[]{i, j, k}), (double)b.getDouble(new int[]{k++, j, i}), (double)1.0E-12);
                }
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void testEquals() {
        Dataset a = DatasetFactory.createRange(DoubleDataset.class, (double)20.0);
        Dataset b = DatasetFactory.createRange(DoubleDataset.class, (double)20.0);
        Dataset c = a.clone();
        Dataset d = Maths.add((Object)a, (Object)0.5);
        Dataset e = DatasetFactory.createRange(FloatDataset.class, (double)20.0);
        Assert.assertTrue((boolean)a.equals(b));
        Assert.assertFalse((a == b ? 1 : 0) != 0);
        Assert.assertTrue((boolean)a.equals(c));
        Assert.assertFalse((a == c ? 1 : 0) != 0);
        Assert.assertFalse((boolean)a.equals(d));
        Assert.assertFalse((boolean)a.equals(e));
        HashSet<Dataset> set = new HashSet<Dataset>();
        Assert.assertTrue((boolean)set.add(a));
        Assert.assertTrue((boolean)set.contains(a));
        Assert.assertTrue((boolean)set.contains(b));
        Assert.assertTrue((boolean)set.contains(c));
        Assert.assertFalse((boolean)set.contains(d));
        Assert.assertFalse((boolean)set.contains(e));
        Assert.assertFalse((boolean)set.add(b));
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertTrue((boolean)set.add(d));
        Assert.assertTrue((boolean)set.add(e));
        Assert.assertEquals((long)3L, (long)set.size());
        Assert.assertTrue((boolean)set.contains(d));
        Assert.assertTrue((boolean)set.contains(e));
        Assert.assertTrue((boolean)set.contains(Maths.subtract((Object)d, (Object)0.5)));
        Assert.assertFalse((boolean)set.contains(Maths.subtract((Object)d, (Object)0.5001)));
        Assert.assertTrue((boolean)set.contains(e.cast(DoubleDataset.class)));
        Assert.assertTrue((boolean)set.contains(b.cast(FloatDataset.class)));
    }

    @Test
    public void testPrint() {
        Dataset a = DatasetFactory.createRange(IntegerDataset.class, (double)1000000.0);
        System.out.println(a);
        System.out.println(a.reshape(new int[]{1000, 1000}));
        System.out.println(a.reshape(new int[]{100, 100, 100}));
        Dataset b = DatasetFactory.createRange(IntegerDataset.class, (double)12.0);
        System.out.println(b);
        System.out.println(b.reshape(new int[]{1, 12}));
        System.out.println(b.reshape(new int[]{4, 1, 3}));
    }

    @Test
    public void testToString() {
        Dataset a = DatasetFactory.createRange(IntegerDataset.class, (double)100.0);
        Assert.assertEquals((Object)"[0, 1, 2, 3, 4, 5, 6, 7, 8, 9]", (Object)a.getSliceView(new Slice[]{new Slice(Integer.valueOf(10))}).toString(true));
        AbstractDataset.setMaxLineLength((int)20);
        Assert.assertEquals((Object)"[0, 1, 2, ..., 97, 98, 99]", (Object)a.toString(true));
        AbstractDataset.setMaxLineLength((int)15);
        Assert.assertEquals((Object)"[10, 11, ..., 13, 14]", (Object)a.getSliceView(new Slice[]{new Slice(Integer.valueOf(10), Integer.valueOf(15))}).toString(true));
        AbstractDataset.setMaxLineLength((int)30);
        Assert.assertEquals((Object)"[0, 1, 2, 3, 4, ..., 96, 97, 98, 99]", (Object)a.toString(true));
        Assert.assertEquals((Object)"[99, 98, 97, 96, ..., 4, 3, 2, 1, 0]", (Object)a.getSliceView(new Slice[]{new Slice(null, null, Integer.valueOf(-1))}).toString(true));
        Assert.assertEquals((Object)"[]", (Object)a.getSliceView(new Slice[]{new Slice(Integer.valueOf(10), Integer.valueOf(10))}).toString(true));
    }

    @Test
    public void testSlicing() {
        Dataset a = DatasetFactory.createRange(IntegerDataset.class, (double)1000.0);
        Dataset s = a.getSlice(null, new int[]{10}, null);
        Assert.assertEquals((long)1L, (long)s.getShapeRef().length);
        Assert.assertEquals((long)10L, (long)s.getShapeRef()[0]);
        IndexIterator is = s.getIterator();
        int i = 0;
        while (is.hasNext()) {
            Assert.assertEquals((long)i, (long)s.getElementLongAbs(is.index));
            ++i;
        }
        Dataset t = a.getSlice(new Slice[]{new Slice(Integer.valueOf(10))});
        Assert.assertEquals((long)1L, (long)t.getShapeRef().length);
        Assert.assertEquals((long)10L, (long)t.getShapeRef()[0]);
        IndexIterator it = t.getIterator();
        i = 0;
        while (it.hasNext()) {
            Assert.assertEquals((long)i, (long)t.getElementLongAbs(it.index));
            ++i;
        }
        is = s.getIterator();
        it = t.getIterator();
        while (is.hasNext() && it.hasNext()) {
            Assert.assertEquals((long)s.getElementLongAbs(is.index), (long)t.getElementLongAbs(it.index));
        }
        s = a.getSlice(new int[1], new int[]{10}, null);
        Assert.assertEquals((long)1L, (long)s.getShapeRef().length);
        Assert.assertEquals((long)10L, (long)s.getShapeRef()[0]);
        s = a.getSlice(new int[]{-1000}, new int[]{10}, null);
        Assert.assertEquals((long)1L, (long)s.getShapeRef().length);
        Assert.assertEquals((long)10L, (long)s.getShapeRef()[0]);
        s = a.getSlice(new int[]{9}, null, new int[]{-1});
        Assert.assertEquals((long)1L, (long)s.getShapeRef().length);
        Assert.assertEquals((long)10L, (long)s.getShapeRef()[0]);
        is = s.getIterator();
        i = 9;
        while (is.hasNext()) {
            Assert.assertEquals((long)i, (long)s.getElementLongAbs(is.index));
            --i;
        }
        t = a.getSlice(new Slice[]{new Slice(Integer.valueOf(9), null, Integer.valueOf(-1))});
        Assert.assertEquals((long)1L, (long)t.getShapeRef().length);
        Assert.assertEquals((long)10L, (long)t.getShapeRef()[0]);
        it = t.getIterator();
        i = 9;
        while (it.hasNext()) {
            Assert.assertEquals((long)i, (long)t.getElementLongAbs(it.index));
            --i;
        }
        is = s.getIterator();
        it = t.getIterator();
        while (is.hasNext() && it.hasNext()) {
            Assert.assertEquals((long)s.getElementLongAbs(is.index), (long)t.getElementLongAbs(it.index));
        }
        s = a.getSlice(new int[]{2}, new int[]{10}, null);
        t = a.getSlice(new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(10))});
        is = s.getIterator();
        it = t.getIterator();
        while (is.hasNext() && it.hasNext()) {
            Assert.assertEquals((long)s.getElementLongAbs(is.index), (long)t.getElementLongAbs(it.index));
        }
        s = a.getSlice(new int[]{2}, new int[]{10}, new int[]{3});
        t = a.getSlice(new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(10), Integer.valueOf(3))});
        is = s.getIterator();
        it = t.getIterator();
        while (is.hasNext() && it.hasNext()) {
            Assert.assertEquals((long)s.getElementLongAbs(is.index), (long)t.getElementLongAbs(it.index));
        }
        t = a.getSlice(new Slice[]{new Slice(Integer.valueOf(2000))});
        Assert.assertArrayEquals((int[])a.getShapeRef(), (int[])t.getShapeRef());
        t = a.getSlice(new Slice[]{new Slice(Integer.valueOf(12), Integer.valueOf(10), Integer.valueOf(3))});
        Assert.assertArrayEquals((int[])new int[1], (int[])t.getShapeRef());
        t = a.getSlice(new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(10), Integer.valueOf(-3))});
        Assert.assertArrayEquals((int[])new int[1], (int[])t.getShapeRef());
        a.setShape(new int[]{10, 10, 10});
        s = a.getSlice(null, null, null);
        t = a.getSlice(new Slice[0]);
        is = s.getIterator();
        it = t.getIterator();
        while (is.hasNext() && it.hasNext()) {
            Assert.assertEquals((long)s.getElementLongAbs(is.index), (long)t.getElementLongAbs(it.index));
        }
        s = a.getSlice(null, null, null);
        Slice[] slice = null;
        t = a.getSlice(slice);
        is = s.getIterator();
        it = t.getIterator();
        while (is.hasNext() && it.hasNext()) {
            Assert.assertEquals((long)s.getElementLongAbs(is.index), (long)t.getElementLongAbs(it.index));
        }
        s = a.getSlice(null, new int[]{8, 10, 10}, null);
        t = a.getSlice(new Slice[]{new Slice(Integer.valueOf(8))});
        is = s.getIterator();
        it = t.getIterator();
        while (is.hasNext() && it.hasNext()) {
            Assert.assertEquals((long)s.getElementLongAbs(is.index), (long)t.getElementLongAbs(it.index));
        }
        s = a.getSlice(null, new int[]{8, 3, 10}, null);
        t = a.getSlice(new Slice[]{new Slice(Integer.valueOf(8)), new Slice(Integer.valueOf(3))});
        is = s.getIterator();
        it = t.getIterator();
        while (is.hasNext() && it.hasNext()) {
            Assert.assertEquals((long)s.getElementLongAbs(is.index), (long)t.getElementLongAbs(it.index));
        }
        s = a.getSlice(null, new int[]{8, 10, 3}, null);
        t = a.getSlice(new Slice[]{new Slice(Integer.valueOf(8)), null, new Slice(Integer.valueOf(3))});
        is = s.getIterator();
        it = t.getIterator();
        while (is.hasNext() && it.hasNext()) {
            Assert.assertEquals((long)s.getElementLongAbs(is.index), (long)t.getElementLongAbs(it.index));
        }
        try {
            a.getSlice(new SliceND(null));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            System.out.println("As expected: " + e);
        }
        try {
            a.getSlice(new SliceND(new int[0]));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            System.out.println("As expected: " + e);
        }
        try {
            a.getSlice(new SliceND(new int[2]));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            System.out.println("As expected: " + e);
        }
        s = a.getSlice(new SliceND(a.getShape()));
        Assert.assertEquals((String)"Full slice", (Object)a, (Object)s);
        s = a.getSlice(new SliceND(a.getShapeRef(), new Slice[]{new Slice(Integer.valueOf(5)), null, new Slice(Integer.valueOf(5))}));
        Assert.assertArrayEquals((String)"Part slice", (int[])new int[]{5, 10, 5}, (int[])s.getShapeRef());
    }

    @Test
    public void testSlicingViews() {
        Dataset a = DatasetFactory.createRange((double)32.0).reshape(new int[]{4, 8});
        int[] nArray = new int[2];
        nArray[1] = 1;
        this.checkSliceView(a, nArray, new int[]{3, 5}, new int[]{1, 2});
        this.checkSliceView(a, new int[]{1, -1}, new int[]{-1, 3}, new int[]{1, -2});
        a = DatasetFactory.createRange((double)60.0).reshape(new int[]{6, 10});
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        Dataset b = this.checkSliceView(a, nArray2, new int[]{6, 8}, new int[]{1, 2});
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        Dataset c = b.getSliceView(nArray3, new int[]{1, 4}, null);
        c.setShape(new int[]{3});
        int[] nArray4 = new int[2];
        nArray4[0] = 1;
        this.checkSliceView(b, nArray4, new int[]{5, 3}, new int[]{2, 1});
        this.checkSliceView(b, new int[]{1, -1}, new int[]{5, 2}, new int[]{2, -1});
        int[] nArray5 = new int[2];
        nArray5[1] = 1;
        c = a.getSlice(nArray5, new int[]{6, 8}, new int[]{1, 2});
        b.setShape(new int[]{2, 3, 4});
        c.setShape(new int[]{2, 3, 4});
        Assert.assertEquals((Object)c, (Object)b);
        b.setShape(new int[]{6, 4});
        b.setShape(new int[]{6, 2, 2});
        c.setShape(new int[]{6, 2, 2});
        Assert.assertEquals((Object)c, (Object)b);
        b.setShape(new int[]{6, 4});
        try {
            b.setShape(new int[]{2, 12});
            Assert.fail((String)"Should have raised an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected exception: " + e));
        }
        b = this.checkSliceView(a, new int[]{1, -1}, new int[]{-1, 2}, new int[]{1, -2});
        int[] nArray6 = new int[2];
        nArray6[0] = 1;
        this.checkSliceView(b, nArray6, new int[]{4, 3}, new int[]{2, 1});
        this.checkSliceView(b, new int[]{1, -1}, new int[]{4, 2}, new int[]{2, -1});
        int[] nArray7 = new int[2];
        nArray7[1] = 1;
        b = this.checkSliceView(a, nArray7, new int[]{1, 8}, new int[]{1, 2});
        int[] nArray8 = new int[2];
        nArray8[1] = 1;
        b = this.checkSliceView(a, nArray8, new int[]{6, 2}, new int[]{1, 2});
        a = DatasetFactory.createFromObject(DoubleDataset.class, (Object)1.0);
        b = a.getSliceView(new Slice[0]);
        b.setShape(new int[]{1});
        Assert.assertTrue((boolean)b.getIterator().hasNext());
        a = DatasetFactory.createRange((double)60.0).reshape(new int[]{6, 10});
        try {
            a.getSliceView(new SliceND(null));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            System.out.println("As expected: " + e);
        }
        try {
            a.getSliceView(new SliceND(new int[0]));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            System.out.println("As expected: " + e);
        }
        try {
            a.getSliceView(new SliceND(new int[2]));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            System.out.println("As expected: " + e);
        }
        b = a.getSliceView(new SliceND(a.getShape()));
        Assert.assertEquals((String)"Full slice", (Object)a, (Object)b);
        b = a.getSliceView(new SliceND(a.getShapeRef(), new Slice[]{new Slice(Integer.valueOf(4)), new Slice(Integer.valueOf(5))}));
        Assert.assertArrayEquals((String)"Part slice", (int[])new int[]{4, 5}, (int[])b.getShapeRef());
    }

    private Dataset checkSliceView(Dataset a, int[] start, int[] stop, int[] step) {
        Dataset s = a.getSliceView(start, stop, step).squeeze();
        Dataset t = a.getSlice(start, stop, step).squeeze();
        Assert.assertArrayEquals((int[])t.getShapeRef(), (int[])s.getShapeRef());
        Assert.assertEquals((String)t.toString(true), (Object)t, (Object)s);
        IndexIterator iter = s.getIterator(true);
        int[] pos = iter.getPos();
        while (iter.hasNext()) {
            Assert.assertEquals((long)iter.index, (long)s.get1DIndex(pos));
            int[] p = s.getNDPosition(iter.index);
            Assert.assertArrayEquals((String)(String.valueOf(Arrays.toString(pos)) + " : " + Arrays.toString(p)), (int[])pos, (int[])p);
        }
        Assert.assertArrayEquals((double[])((DoubleDataset)t.flatten()).getData(), (double[])((DoubleDataset)s.flatten()).getData(), (double)1.0E-15);
        TestUtils.assertEquals((String)"Max", (double)t.max(new boolean[0]).doubleValue(), (double)s.max(new boolean[0]).doubleValue());
        TestUtils.assertEquals((String)"Min", (double)t.min(new boolean[0]).doubleValue(), (double)s.min(new boolean[0]).doubleValue());
        return s;
    }

    @Test
    public void testSliceStrings() {
        String s = Slice.createString((int[])new int[]{3}, null, null, null);
        Assert.assertEquals((Object)":", (Object)s);
        s = Slice.createString((int[])new int[]{3}, null, null, (int[])new int[]{1});
        Assert.assertEquals((Object)":", (Object)s);
        s = Slice.createString((int[])new int[]{3}, null, (int[])new int[]{2}, (int[])new int[]{1});
        Assert.assertEquals((Object)":2", (Object)s);
        s = Slice.createString((int[])new int[]{4}, (int[])new int[]{1}, (int[])new int[]{3}, (int[])new int[]{1});
        Assert.assertEquals((Object)"1:3", (Object)s);
        s = Slice.createString((int[])new int[]{4}, (int[])new int[]{1}, (int[])new int[]{2}, (int[])new int[]{1});
        Assert.assertEquals((Object)"1", (Object)s);
        s = Slice.createString((int[])new int[]{4}, (int[])new int[]{1}, (int[])new int[]{3}, (int[])new int[]{2});
        Assert.assertEquals((Object)"1", (Object)s);
        s = Slice.createString((int[])new int[]{5}, null, null, (int[])new int[]{2});
        Assert.assertEquals((Object)"::2", (Object)s);
        s = Slice.createString((int[])new int[]{5}, (int[])new int[]{1}, (int[])new int[]{4}, (int[])new int[]{2});
        Assert.assertEquals((Object)"1:4:2", (Object)s);
        s = Slice.createString((int[])new int[]{5}, (int[])new int[]{1}, (int[])new int[]{5}, (int[])new int[]{2});
        Assert.assertEquals((Object)"1::2", (Object)s);
        s = Slice.createString((int[])new int[]{5}, (int[])new int[]{1}, (int[])new int[]{3}, (int[])new int[]{2});
        Assert.assertEquals((Object)"1", (Object)s);
        s = Slice.createString((int[])new int[]{3}, null, null, (int[])new int[]{-1});
        Assert.assertEquals((Object)"::-1", (Object)s);
        s = Slice.createString((int[])new int[]{5}, (int[])new int[]{3}, (int[])new int[]{1}, (int[])new int[]{-1});
        Assert.assertEquals((Object)"3:1:-1", (Object)s);
        s = Slice.createString((int[])new int[]{5}, (int[])new int[]{4}, (int[])new int[]{1}, (int[])new int[]{-1});
        Assert.assertEquals((Object)":1:-1", (Object)s);
        s = Slice.createString((int[])new int[]{5}, (int[])new int[]{3}, (int[])new int[1], (int[])new int[]{-1});
        Assert.assertEquals((Object)"3:0:-1", (Object)s);
        s = Slice.createString((int[])new int[]{5}, (int[])new int[]{3}, (int[])new int[]{-1}, (int[])new int[]{-1});
        Assert.assertEquals((Object)"3::-1", (Object)s);
        s = Slice.createString((int[])new int[]{5}, (int[])new int[]{3}, (int[])new int[]{2}, (int[])new int[]{-1});
        Assert.assertEquals((Object)"3", (Object)s);
        s = Slice.createString((int[])new int[]{5}, (int[])new int[]{3}, (int[])new int[]{1}, (int[])new int[]{-2});
        Assert.assertEquals((Object)"3", (Object)s);
        s = Slice.createString((int[])new int[]{3, 2}, null, null, null);
        Assert.assertEquals((Object)":,:", (Object)s);
    }

    @Test
    public void testSetSlice() {
        Dataset a = DatasetFactory.createRange((double)100.0).reshape(new int[]{20, 5});
        a.setSlice((Object)-2, new Slice[]{null, new Slice(null, null, Integer.valueOf(2))});
        Assert.assertEquals((double)-2.0, (double)a.getDouble(0, 0), (double)1.0E-15);
        Assert.assertEquals((double)1.0, (double)a.getDouble(0, 1), (double)1.0E-15);
        Assert.assertEquals((double)-2.0, (double)a.getDouble(0, 2), (double)1.0E-15);
        Assert.assertEquals((double)3.0, (double)a.getDouble(0, 3), (double)1.0E-15);
        Assert.assertEquals((double)-2.0, (double)a.getDouble(0, 4), (double)1.0E-15);
        a = DatasetFactory.createRange((double)100.0).reshape(new int[]{20, 5});
        a.setSlice((Object)DatasetFactory.createRange(ShortDataset.class, (double)3.0), new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(10)), new Slice(null, null, Integer.valueOf(2))});
        Assert.assertEquals((double)0.0, (double)a.getDouble(0, 0), (double)1.0E-15);
        Assert.assertEquals((double)1.0, (double)a.getDouble(0, 1), (double)1.0E-15);
        Assert.assertEquals((double)2.0, (double)a.getDouble(0, 2), (double)1.0E-15);
        Assert.assertEquals((double)3.0, (double)a.getDouble(0, 3), (double)1.0E-15);
        Assert.assertEquals((double)4.0, (double)a.getDouble(0, 4), (double)1.0E-15);
        Assert.assertEquals((double)5.0, (double)a.getDouble(1, 0), (double)1.0E-15);
        Assert.assertEquals((double)6.0, (double)a.getDouble(1, 1), (double)1.0E-15);
        Assert.assertEquals((double)7.0, (double)a.getDouble(1, 2), (double)1.0E-15);
        Assert.assertEquals((double)8.0, (double)a.getDouble(1, 3), (double)1.0E-15);
        Assert.assertEquals((double)9.0, (double)a.getDouble(1, 4), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)a.getDouble(2, 0), (double)1.0E-15);
        Assert.assertEquals((double)11.0, (double)a.getDouble(2, 1), (double)1.0E-15);
        Assert.assertEquals((double)1.0, (double)a.getDouble(2, 2), (double)1.0E-15);
        Assert.assertEquals((double)13.0, (double)a.getDouble(2, 3), (double)1.0E-15);
        Assert.assertEquals((double)2.0, (double)a.getDouble(2, 4), (double)1.0E-15);
        try {
            a.setSlice((Object)DatasetFactory.createRange(ShortDataset.class, (double)3.0), new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(7), Integer.valueOf(2)), new Slice(Integer.valueOf(2), Integer.valueOf(3))});
            Assert.fail((String)"Should have thrown an IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        CompoundDataset c = ((CompoundDoubleDataset)DatasetFactory.createRange((int)3, CompoundDoubleDataset.class, (double)100.0)).reshape(new int[]{20, 5});
        c.setSlice((Object)DatasetFactory.createRange(ShortDataset.class, (double)3.0), new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(10)), new Slice(null, null, Integer.valueOf(2))});
    }

    @Test
    public void testFillDataset() {
        DoubleDataset other = DatasetFactory.zeros((int[])new int[]{10});
        Dataset a = DatasetFactory.createRange((double)100.0).reshape(new int[]{20, 5});
        Assert.assertEquals((double)0.0, (double)other.max(new boolean[0]).doubleValue(), (double)1.0E-14);
        a.fillDataset((Dataset)other, a.getSliceIterator(null, new int[]{10, 1}, null));
        Assert.assertEquals((double)45.0, (double)other.max(new boolean[0]).doubleValue(), (double)1.0E-14);
        CompoundDataset c = ((CompoundDoubleDataset)DatasetFactory.createRange((int)3, CompoundDoubleDataset.class, (double)100.0)).reshape(new int[]{20, 5});
        CompoundDataset cOther = DatasetFactory.compoundZeros((int)3, CompoundDoubleDataset.class, (int[])new int[]{10});
        Assert.assertArrayEquals((double[])new double[]{0.0, 0.0, 0.0}, (double[])cOther.maxItem(), (double)1.0E-14);
        c.fillDataset((Dataset)cOther, c.getSliceIterator(null, new int[]{10, 1}, null));
        Assert.assertArrayEquals((double[])new double[]{45.0, 0.0, 0.0}, (double[])cOther.maxItem(), (double)1.0E-14);
    }

    @Test
    public void test1DErrors() {
        Dataset a = DatasetFactory.createRange(IntegerDataset.class, (double)100.0);
        a.setErrors((Serializable)Integer.valueOf(5));
        Assert.assertEquals((double)5.0, (double)a.getError(0), (double)0.001);
        Assert.assertEquals((double)5.0, (double)a.getError(50), (double)0.001);
        Assert.assertEquals((double)5.0, (double)a.getError(99), (double)0.001);
        Assert.assertTrue((boolean)a.hasErrors());
        Dataset error = a.getErrors();
        try {
            ShapeUtils.checkCompatibility((ILazyDataset)a, (ILazyDataset)error);
        }
        catch (Exception e) {
            Assert.fail((String)"Error shape is not the same as input datasets");
        }
        Assert.assertEquals((double)5.0, (double)error.getDouble(0), (double)0.001);
        Assert.assertEquals((double)5.0, (double)error.getDouble(50), (double)0.001);
        Assert.assertEquals((double)5.0, (double)error.getDouble(99), (double)0.001);
        a.setErrors((Serializable)Maths.multiply((Object)error, (Object)2));
        Assert.assertEquals((double)10.0, (double)a.getError(0), (double)0.001);
        Assert.assertEquals((double)10.0, (double)a.getError(50), (double)0.001);
        Assert.assertEquals((double)10.0, (double)a.getError(99), (double)0.001);
        Dataset error2 = a.getErrors();
        try {
            ShapeUtils.checkCompatibility((ILazyDataset)a, (ILazyDataset)error2);
        }
        catch (Exception e) {
            Assert.fail((String)"Error shape is not the same as input datasets");
        }
        Assert.assertEquals((double)10.0, (double)error2.getDouble(0), (double)0.001);
        Assert.assertEquals((double)10.0, (double)error2.getDouble(50), (double)0.001);
        Assert.assertEquals((double)10.0, (double)error2.getDouble(99), (double)0.001);
    }

    @Test
    public void test2DErrors() {
        Dataset a = DatasetFactory.zeros(IntegerDataset.class, (int[])new int[]{100, 100});
        a.setErrors((Serializable)Integer.valueOf(5));
        Assert.assertEquals((double)5.0, (double)a.getError(0, 0), (double)0.001);
        Assert.assertEquals((double)5.0, (double)a.getError(50, 50), (double)0.001);
        Assert.assertEquals((double)5.0, (double)a.getError(99, 99), (double)0.001);
        Assert.assertTrue((boolean)a.hasErrors());
        Dataset error = a.getErrors();
        try {
            ShapeUtils.checkCompatibility((ILazyDataset)a, (ILazyDataset)error);
        }
        catch (Exception e) {
            Assert.fail((String)"Error shape is not the same as input datasets");
        }
        Assert.assertEquals((double)5.0, (double)error.getDouble(0, 0), (double)0.001);
        Assert.assertEquals((double)5.0, (double)error.getDouble(50, 50), (double)0.001);
        Assert.assertEquals((double)5.0, (double)error.getDouble(99, 99), (double)0.001);
        a.setErrors((Serializable)Maths.multiply((Object)error, (Object)2));
        Assert.assertEquals((double)10.0, (double)a.getError(0, 0), (double)0.001);
        Assert.assertEquals((double)10.0, (double)a.getError(50, 50), (double)0.001);
        Assert.assertEquals((double)10.0, (double)a.getError(99, 99), (double)0.001);
        Dataset error2 = a.getErrors();
        try {
            ShapeUtils.checkCompatibility((ILazyDataset)a, (ILazyDataset)error2);
        }
        catch (Exception e) {
            Assert.fail((String)"Error shape is not the same as input datasets");
        }
        Assert.assertEquals((double)10.0, (double)error2.getDouble(0, 0), (double)0.001);
        Assert.assertEquals((double)10.0, (double)error2.getDouble(50, 50), (double)0.001);
        Assert.assertEquals((double)10.0, (double)error2.getDouble(99, 99), (double)0.001);
    }

    @Test
    public void testErrors() {
        Dataset a = ((IntegerDataset)DatasetFactory.createRange(IntegerDataset.class, (double)12.0)).reshape(new int[]{4, 3});
        Dataset e = ((DoubleDataset)DatasetFactory.createRange(DoubleDataset.class, (double)12.0)).reshape(new int[]{4, 3});
        a.setErrors((Serializable)e);
        Dataset b = a.reshape(new int[]{2, 2, 3});
        Dataset f = b.getErrors();
        Assert.assertArrayEquals((int[])b.getShapeRef(), (int[])f.getShapeRef());
        Dataset c = b.getSlice(new Slice[]{new Slice(Integer.valueOf(1))});
        Assert.assertArrayEquals((int[])c.getShapeRef(), (int[])c.getErrors().getShapeRef());
        Dataset d = b.getSliceView(new Slice[]{new Slice(Integer.valueOf(1))});
        Assert.assertArrayEquals((int[])d.getShapeRef(), (int[])d.getErrors().getShapeRef());
    }

    @Test
    public void testSetErrorBuffer() {
        Dataset a = DatasetFactory.zeros(IntegerDataset.class, (int[])new int[]{100, 100});
        Dataset err = DatasetFactory.createLinearSpace(DoubleDataset.class, (double)0.0, (double)(a.getSize() - 1), (int)a.getSize());
        err.setShape(a.getShapeRef());
        a.setErrorBuffer(null);
        Assert.assertFalse((boolean)a.hasErrors());
        a.setErrorBuffer((Serializable)Double.valueOf(25.0));
        Assert.assertEquals((double)5.0, (double)a.getError(0, 0), (double)0.001);
        Assert.assertEquals((double)5.0, (double)a.getError(50, 50), (double)0.001);
        Assert.assertEquals((double)5.0, (double)a.getError(99, 99), (double)0.001);
        Assert.assertTrue((boolean)a.hasErrors());
        Dataset error = a.getErrors();
        try {
            ShapeUtils.checkCompatibility((ILazyDataset)a, (ILazyDataset)error);
        }
        catch (Exception e) {
            Assert.fail((String)"Error shape is not the same as input datasets");
        }
        a.setErrorBuffer((Serializable)err);
        Assert.assertEquals((double)0.0, (double)a.getError(0, 0), (double)0.001);
        Assert.assertEquals((double)Math.sqrt(5050.0), (double)a.getError(50, 50), (double)0.001);
        Assert.assertEquals((double)Math.sqrt(9999.0), (double)a.getError(99, 99), (double)0.001);
        Assert.assertTrue((boolean)a.hasErrors());
        error = a.getErrors();
        try {
            ShapeUtils.checkCompatibility((ILazyDataset)a, (ILazyDataset)error);
        }
        catch (Exception e) {
            Assert.fail((String)"Error shape is not the same as input datasets");
        }
        a.setErrorBuffer(err.getBuffer());
        Assert.assertEquals((double)0.0, (double)a.getError(0, 0), (double)0.001);
        Assert.assertEquals((double)Math.sqrt(2535.0), (double)a.getError(25, 35), (double)0.001);
        Assert.assertEquals((double)Math.sqrt(9999.0), (double)a.getError(99, 99), (double)0.001);
        Assert.assertTrue((boolean)a.hasErrors());
        error = a.getErrors();
        try {
            ShapeUtils.checkCompatibility((ILazyDataset)a, (ILazyDataset)error);
        }
        catch (Exception e) {
            Assert.fail((String)"Error shape is not the same as input datasets");
        }
    }

    @Test
    public void testInternalErrors() {
        Dataset a = DatasetFactory.createRange(IntegerDataset.class, (double)100.0);
        a.setErrors((Serializable)Integer.valueOf(5));
        Number ne = (Number)a.getErrorBuffer().getObjectAbs(0);
        Assert.assertEquals((double)25.0, (double)ne.doubleValue(), (double)0.001);
        Dataset error = a.getErrors();
        a.setErrors((Serializable)Maths.multiply((Object)error, (Object)2));
        Dataset ae = a.getErrorBuffer();
        Assert.assertEquals((double)100.0, (double)ae.getDouble(0), (double)0.001);
        Assert.assertEquals((double)100.0, (double)ae.getDouble(50), (double)0.001);
        Assert.assertEquals((double)100.0, (double)ae.getDouble(99), (double)0.001);
    }

    @Test
    public void testZeroRankDatasets() {
        DoubleDataset a = DatasetFactory.ones((int[])new int[0]);
        Assert.assertEquals((String)"Rank", (long)0L, (long)a.getRank());
        Assert.assertEquals((String)"Shape", (long)0L, (long)a.getShapeRef().length);
        Assert.assertEquals((String)"Value", (Object)1.0, (Object)a.getObject());
        Assert.assertEquals((String)"Max", (Object)1.0, (Object)a.max(new boolean[0]));
        Assert.assertEquals((String)"Min", (Object)1.0, (Object)a.min(new boolean[0]));
        Assert.assertEquals((String)"MaxPos", (long)0L, (long)a.maxPos(new boolean[0]).length);
        Assert.assertEquals((String)"MinPos", (long)0L, (long)a.minPos(new boolean[0]).length);
        Assert.assertEquals((String)"ArgMax", (long)0L, (long)a.argMax(new boolean[0]));
        Assert.assertEquals((String)"ArgMin", (long)0L, (long)a.argMin(new boolean[0]));
        Assert.assertTrue((String)"Value", (boolean)a.equals(1.0));
        a = DatasetFactory.zeros(ShortDataset.class, (int[])new int[0]);
        Assert.assertEquals((String)"Rank", (long)0L, (long)a.getRank());
        Assert.assertEquals((String)"Shape", (long)0L, (long)a.getShapeRef().length);
        Assert.assertEquals((String)"Value", (Object)0, (Object)a.getObject());
        a = DatasetFactory.createFromObject((Object)new Complex(1.0, -0.5));
        Assert.assertEquals((String)"Rank", (long)0L, (long)a.getRank());
        Assert.assertEquals((String)"Shape", (long)0L, (long)a.getShapeRef().length);
        Assert.assertEquals((String)"Value", (Object)new Complex(1.0, -0.5), (Object)a.getObject());
        Assert.assertEquals((String)"Real view value", (Object)1.0, (Object)a.getRealView().getObject());
        Assert.assertEquals((String)"Imaginary view value", (Object)-0.5, (Object)((ComplexDoubleDataset)a).getImaginaryView().getObject());
        a = DatasetFactory.createFromObject((Object)Float.valueOf(1.0f));
        Assert.assertEquals((String)"Rank", (long)0L, (long)a.getRank());
        Assert.assertEquals((String)"Shape", (long)0L, (long)a.getShapeRef().length);
        Assert.assertEquals((String)"Value", (Object)Float.valueOf(1.0f), (Object)a.getObject());
        a = DatasetFactory.ones((int[])new int[]{1});
        a.squeeze();
        Assert.assertEquals((String)"Rank", (long)0L, (long)a.getRank());
        Assert.assertEquals((String)"Shape", (long)0L, (long)a.getShapeRef().length);
        a = DatasetFactory.createFromObject((Object)Float.valueOf(1.0f));
        Assert.assertEquals((String)"Equals", (Object)a, (Object)DatasetFactory.createFromObject((Object)Float.valueOf(1.0f)));
        Assert.assertFalse((String)"Differs", (boolean)a.equals(DatasetFactory.createFromObject((Object)Float.valueOf(2.0f))));
    }

    @Test
    public void testConcatenate() {
        DoubleDataset a = DatasetFactory.createRange((double)6.0);
        DoubleDataset b = DatasetFactory.createRange((double)6.0, (double)8.0, (double)1.0);
        Dataset c = DatasetUtils.concatenate((IDataset[])new IDataset[]{a, b}, (int)0);
        DoubleDataset d = DatasetFactory.createRange((double)8.0);
        Assert.assertEquals((String)"Rank", (long)1L, (long)c.getRank());
        Assert.assertTrue((String)"Dataset", (boolean)c.equals(d));
        a = DatasetFactory.createRange((double)6.0).reshape(new int[]{3, 2});
        b = DatasetFactory.createRange((double)6.0, (double)8.0, (double)1.0).reshape(new int[]{1, 2});
        c = DatasetUtils.concatenate((IDataset[])new IDataset[]{a, b}, (int)0);
        d = DatasetFactory.createRange((double)8.0).reshape(new int[]{4, 2});
        Assert.assertEquals((String)"Rank", (long)2L, (long)c.getRank());
        Assert.assertTrue((String)"Dataset", (boolean)c.equals(d));
        a.setShape(new int[]{2, 3});
        b = DatasetFactory.createRange((double)6.0, (double)9.0, (double)1.0).reshape(new int[]{1, 3});
        c = DatasetUtils.concatenate((IDataset[])new IDataset[]{a, b}, (int)0);
        d = DatasetFactory.createRange((double)9.0).reshape(new int[]{3, 3});
        Assert.assertEquals((String)"Rank", (long)2L, (long)c.getRank());
        Assert.assertTrue((String)"Dataset", (boolean)c.equals(d));
        a = DatasetFactory.createRange((double)2.0).reshape(new int[]{1, 2});
        b = DatasetFactory.createRange((double)3.0, (double)5.0, (double)1.0).reshape(new int[]{1, 2});
        a = DatasetUtils.concatenate((IDataset[])new IDataset[]{a, b}, (int)0);
        b = DatasetFactory.createRange((double)2.0, (double)6.0, (double)3.0).reshape(new int[]{2, 1});
        c = DatasetUtils.concatenate((IDataset[])new IDataset[]{a, b}, (int)1);
        d = DatasetFactory.createRange((double)6.0).reshape(new int[]{2, 3});
        Assert.assertEquals((String)"Rank", (long)2L, (long)c.getRank());
        Assert.assertTrue((String)"Dataset", (boolean)c.equals(d));
    }

    @Test
    public void testSum() {
        Dataset a = DatasetFactory.createRange(IntegerDataset.class, (double)1048576.0);
        Assert.assertEquals((String)"Sum", (Object)-524288, (Object)a.sum(new boolean[0]));
        a = a.cast(DoubleDataset.class);
        Assert.assertEquals((String)"Sum", (double)5.497552896E11, (double)((Number)a.sum(new boolean[0])).doubleValue(), (double)1.0E-6);
        a = DatasetFactory.createRange(DoubleDataset.class, (double)12.0);
        a.setShape(new int[]{3, 4});
        Assert.assertEquals((String)"Sum", (double)66.0, (double)((Number)a.sum(new boolean[0])).doubleValue(), (double)1.0E-6);
        a.set((Object)Double.NaN, 0, 0);
        Assert.assertTrue((String)"Sum", (boolean)Double.isNaN(((Number)a.sum(new boolean[0])).doubleValue()));
        Assert.assertEquals((String)"Sum", (double)66.0, (double)((Number)a.sum(new boolean[]{true})).doubleValue(), (double)1.0E-6);
    }

    @Test
    public void testMakeFinite() {
        Dataset a = DatasetFactory.createFromObject((Object)new double[]{0.0, Double.POSITIVE_INFINITY, Double.NaN, Double.NEGATIVE_INFINITY});
        DatasetUtils.makeFinite((Dataset)a);
        Assert.assertTrue((String)"Make finite", (boolean)DatasetFactory.createFromObject((Object)new double[]{0.0, Double.MAX_VALUE, 0.0, -1.7976931348623157E308}).equals(a));
    }

    @Test
    public void testCast() {
        LongDataset d = new LongDataset();
        Dataset c = DatasetUtils.cast(DoubleDataset.class, (IDataset)d);
        long[] lArray = new long[14];
        lArray[1] = 1L;
        lArray[2] = 127L;
        lArray[3] = 128L;
        lArray[4] = 255L;
        lArray[5] = 256L;
        lArray[6] = 32767L;
        lArray[7] = 32768L;
        lArray[8] = 65535L;
        lArray[9] = 65536L;
        lArray[10] = Integer.MAX_VALUE;
        lArray[11] = 0x80000000L;
        lArray[12] = 0xFFFFFFFFL;
        lArray[13] = 0x100000000L;
        long[] udata = lArray;
        d = new LongDataset(udata, new int[0]);
        c = DatasetUtils.cast(IntegerDataset.class, (IDataset)d);
        Assert.assertTrue((c.max(new boolean[0]).doubleValue() < d.max(new boolean[0]).doubleValue() ? 1 : 0) != 0);
        Dataset a = DatasetFactory.createFromObject((boolean)true, (Object)c);
        Assert.assertEquals((String)"Cast", (long)0L, (long)a.getLong(13));
        int i = 0;
        while (i < 13) {
            Assert.assertEquals((String)"Cast", (long)udata[i], (long)a.getLong(i));
            ++i;
        }
        c = DatasetUtils.cast(ShortDataset.class, (IDataset)d);
        Assert.assertTrue((c.max(new boolean[0]).doubleValue() < d.max(new boolean[0]).doubleValue() ? 1 : 0) != 0);
        a = DatasetFactory.createFromObject((boolean)true, (Object)c);
        Assert.assertEquals((String)"Cast", (long)0L, (long)a.getLong(9));
        i = 0;
        while (i < 9) {
            Assert.assertEquals((String)"Cast", (long)udata[i], (long)a.getLong(i));
            ++i;
        }
        c = DatasetUtils.cast(ByteDataset.class, (IDataset)d);
        Assert.assertTrue((c.max(new boolean[0]).doubleValue() < d.max(new boolean[0]).doubleValue() ? 1 : 0) != 0);
        a = DatasetFactory.createFromObject((boolean)true, (Object)c);
        Assert.assertEquals((String)"Cast", (long)0L, (long)a.getLong(5));
        i = 0;
        while (i < 5) {
            Assert.assertEquals((String)"Cast", (long)udata[i], (long)a.getLong(i));
            ++i;
        }
        long[] lArray2 = new long[2];
        lArray2[1] = 0x4000000000000000L;
        c = DatasetFactory.createFromObject((Object)lArray2);
        Assert.assertTrue((c == (a = DatasetFactory.createFromObject((boolean)true, (Object)c)) ? 1 : 0) != 0);
        int[] nArray = new int[2];
        nArray[1] = 0x40000000;
        c = DatasetFactory.createFromObject((Object)nArray);
        a = DatasetFactory.createFromObject((boolean)true, (Object)c);
        Assert.assertTrue((c == a ? 1 : 0) != 0);
        short[] sArray = new short[2];
        sArray[1] = 16384;
        c = DatasetFactory.createFromObject((Object)sArray);
        a = DatasetFactory.createFromObject((boolean)true, (Object)c);
        Assert.assertTrue((c == a ? 1 : 0) != 0);
        byte[] byArray = new byte[2];
        byArray[1] = 64;
        c = DatasetFactory.createFromObject((Object)byArray);
        a = DatasetFactory.createFromObject((boolean)true, (Object)c);
        Assert.assertTrue((c == a ? 1 : 0) != 0);
    }

    @Test
    public void testCopy() {
        int[] idata = new int[]{1, -2, 3};
        IntegerDataset d = new IntegerDataset(idata, null);
        Dataset c = d.copy(IntegerDataset.class);
        Assert.assertTrue((c != d ? 1 : 0) != 0);
        TestUtils.assertDatasetEquals((Dataset)c, (Dataset)d);
        c = d.copy(FloatDataset.class);
        TestUtils.assertDatasetEquals((Dataset)c, (Dataset)d, (boolean)false);
    }

    @Test
    public void testRoll() {
        Dataset a = DatasetFactory.createRange(IntegerDataset.class, (double)10.0);
        Dataset r = DatasetUtils.roll((Dataset)a, (int)2, null);
        TestUtils.assertDatasetEquals((Dataset)r, (Dataset)Maths.add((Object)a, (Object)8).iremainder((Object)10), (double)1.0E-6, (double)1.0E-6);
        r = DatasetUtils.roll((Dataset)a, (int)-2, null);
        TestUtils.assertDatasetEquals((Dataset)r, (Dataset)Maths.add((Object)a, (Object)12).iremainder((Object)10), (double)1.0E-6, (double)1.0E-6);
        a.setShape(new int[]{2, 5});
        r = DatasetUtils.roll((Dataset)a, (int)1, null);
        TestUtils.assertDatasetEquals((Dataset)r, (Dataset)Maths.add((Object)a, (Object)9).iremainder((Object)10).reshape(new int[]{2, 5}), (double)1.0E-6, (double)1.0E-6);
        r = DatasetUtils.roll((Dataset)a, (int)1, (Integer)0);
        TestUtils.assertDatasetEquals((Dataset)r, (Dataset)Maths.add((Object)a, (Object)5).iremainder((Object)10).reshape(new int[]{2, 5}), (double)1.0E-6, (double)1.0E-6);
        r = DatasetUtils.roll((Dataset)a, (int)1, (Integer)1);
        int[] nArray = new int[10];
        nArray[0] = 4;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[5] = 9;
        nArray[6] = 5;
        nArray[7] = 6;
        nArray[8] = 7;
        nArray[9] = 8;
        TestUtils.assertDatasetEquals((Dataset)r, (Dataset)DatasetFactory.createFromObject((Object)nArray, (int[])new int[]{2, 5}), (double)1.0E-6, (double)1.0E-6);
        r = DatasetUtils.roll((Dataset)a, (int)1, (Integer)-2);
        TestUtils.assertDatasetEquals((Dataset)r, (Dataset)Maths.add((Object)a, (Object)5).iremainder((Object)10).reshape(new int[]{2, 5}), (double)1.0E-6, (double)1.0E-6);
        r = DatasetUtils.roll((Dataset)a, (int)1, (Integer)-1);
        int[] nArray2 = new int[10];
        nArray2[0] = 4;
        nArray2[2] = 1;
        nArray2[3] = 2;
        nArray2[4] = 3;
        nArray2[5] = 9;
        nArray2[6] = 5;
        nArray2[7] = 6;
        nArray2[8] = 7;
        nArray2[9] = 8;
        TestUtils.assertDatasetEquals((Dataset)r, (Dataset)DatasetFactory.createFromObject((Object)nArray2, (int[])new int[]{2, 5}), (double)1.0E-6, (double)1.0E-6);
    }

    @Test
    public void testRollAxis() {
        Dataset a = DatasetFactory.ones(ByteDataset.class, (int[])new int[]{3, 4, 5, 6});
        Assert.assertArrayEquals((int[])new int[]{3, 6, 4, 5}, (int[])DatasetUtils.rollAxis((Dataset)a, (int)3, (int)1).getShapeRef());
        Assert.assertArrayEquals((int[])new int[]{5, 3, 4, 6}, (int[])DatasetUtils.rollAxis((Dataset)a, (int)2, (int)0).getShapeRef());
        Assert.assertArrayEquals((int[])new int[]{3, 5, 6, 4}, (int[])DatasetUtils.rollAxis((Dataset)a, (int)1, (int)4).getShapeRef());
        Assert.assertArrayEquals((int[])new int[]{3, 6, 4, 5}, (int[])DatasetUtils.rollAxis((Dataset)a, (int)-1, (int)1).getShapeRef());
    }

    @Test
    public void testFindOccurrences() {
        Dataset a = DatasetFactory.createFromObject((Object)new double[]{0.0, 0.0, 3.0, 7.0, -4.0, 2.0, 1.0});
        Dataset v = DatasetFactory.createRange(DoubleDataset.class, (double)-3.0, (double)3.0, (double)1.0);
        IntegerDataset indexes = DatasetUtils.findFirstOccurrences((Dataset)a, (Dataset)v);
        int[] nArray = new int[6];
        nArray[0] = -1;
        nArray[1] = -1;
        nArray[2] = -1;
        nArray[4] = 6;
        nArray[5] = 5;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)nArray, null), (Dataset)indexes, (boolean)true, (double)1.0, (double)1.0);
    }

    @Test
    public void testFindIndexes() {
        Dataset a = DatasetFactory.createFromObject((Object)new double[]{0.0, 0.0, 3.0, 7.0, -4.0, 2.0, 1.0});
        Dataset v = DatasetFactory.createRange(DoubleDataset.class, (double)-3.0, (double)3.0, (double)1.0);
        IntegerDataset indexes = DatasetUtils.findIndexesForValues((Dataset)a, (Dataset)v);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new int[]{3, 3, -1, -1, -1, 5, 4}, null), (Dataset)indexes, (boolean)true, (double)1.0, (double)1.0);
        v = DatasetFactory.createFromObject((Object)new double[]{-4.0, 0.0, 1.0, 2.0, 3.0, 7.0});
        indexes = DatasetUtils.findIndexesForValues((Dataset)a, (Dataset)v);
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)v.getBy1DIndex(indexes), (boolean)true, (double)1.0E-6, (double)1.0E-6);
    }

    @Test
    public void testAppend() {
        int j;
        double[] x = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        Dataset d1 = DatasetFactory.createRange(DoubleDataset.class, (double)3.0);
        Dataset d2 = DatasetFactory.createRange(DoubleDataset.class, (double)3.0, (double)6.0, (double)1.0);
        Dataset d3 = DatasetUtils.append((IDataset)d1, (IDataset)d2, (int)0);
        int i = 0;
        while (i < x.length) {
            Assert.assertEquals((String)"Append 1", (double)x[i], (double)d3.getDouble(i), (double)1.0E-8);
            ++i;
        }
        d1.setShape(new int[]{1, 3});
        d2.setShape(new int[]{1, 3});
        d3 = DatasetUtils.append((IDataset)d1, (IDataset)d2, (int)0);
        Dataset d4 = DatasetFactory.createFromObject((Object)x);
        d4.setShape(new int[]{2, 3});
        int i2 = 0;
        while (i2 < 2) {
            j = 0;
            while (j < 3) {
                Assert.assertEquals((String)"Append 2", (double)d4.getDouble(i2, j), (double)d3.getDouble(i2, j), (double)1.0E-8);
                ++j;
            }
            ++i2;
        }
        d3 = DatasetUtils.append((IDataset)d1, (IDataset)d2, (int)1);
        d4 = DatasetFactory.createFromObject((Object)x);
        d4.setShape(new int[]{1, 6});
        i2 = 0;
        while (i2 < 1) {
            j = 0;
            while (j < 6) {
                Assert.assertEquals((String)"Append 3", (double)d4.getDouble(i2, j), (double)d3.getDouble(i2, j), (double)1.0E-8);
                ++j;
            }
            ++i2;
        }
        d3 = DatasetUtils.append((IDataset)d1, (IDataset)d2, (int)-1);
        TestUtils.assertDatasetEquals((Dataset)d4, (Dataset)d3);
    }

    @Test
    public void testSelect() {
        Dataset a = DatasetFactory.createFromObject((Object)new double[]{0.0, 1.0, 3.0, 5.0, -7.0, -9.0});
        Dataset b = DatasetFactory.createFromObject((Object)new double[]{0.01, 1.2, 2.9, 5.0, -7.1, -9.0});
        Dataset c = a.clone().reshape(new int[]{2, 3});
        boolean[] blArray = new boolean[6];
        blArray[1] = true;
        blArray[4] = true;
        BooleanDataset d = (BooleanDataset)DatasetFactory.createFromObject(BooleanDataset.class, (Object)blArray, (int[])new int[]{2, 3});
        Dataset e = DatasetUtils.select((BooleanDataset[])new BooleanDataset[]{d}, (Object[])new Object[]{c}, (Object)-2);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{-2.0, 1.0, -2.0, -2.0, -7.0, -2.0}, (int[])new int[]{2, 3}), (Dataset)e);
        Dataset f = b.clone().reshape(new int[]{2, 3});
        boolean[] blArray2 = new boolean[6];
        blArray2[1] = true;
        blArray2[2] = true;
        BooleanDataset g = (BooleanDataset)DatasetFactory.createFromObject(BooleanDataset.class, (Object)blArray2, (int[])new int[]{2, 3});
        e = DatasetUtils.select((BooleanDataset[])new BooleanDataset[]{d, g}, (Object[])new Dataset[]{c, f}, (Object)-2.5);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{-2.5, 1.0, 2.9, -2.5, -7.0, -2.5}, (int[])new int[]{2, 3}), (Dataset)e);
        e = DatasetUtils.select((BooleanDataset)d, (Object)c, (Object)-2);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{-2.0, 1.0, -2.0, -2.0, -7.0, -2.0}, (int[])new int[]{2, 3}), (Dataset)e);
    }

    @Test
    public void testChoose() {
        Dataset a = DatasetFactory.createFromObject((Object)new double[]{0.0, 1.0, 3.0, 5.0, -7.0, -9.0});
        Dataset b = DatasetFactory.createFromObject((Object)new double[]{0.01, 1.2, 2.9, 5.0, -7.1, -9.0});
        Dataset c = a.clone().reshape(new int[]{2, 3});
        int[] nArray = new int[6];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[5] = 1;
        IntegerDataset d = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)nArray, (int[])new int[]{2, 3});
        Dataset e = DatasetUtils.choose((IntegerDataset)d, (Object[])new Object[]{c, -2}, (boolean)true, (boolean)false);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{0.0, 1.0, -2.0, -2.0, -7.0, -2.0}, (int[])new int[]{2, 3}), (Dataset)e);
        int[] nArray2 = new int[6];
        nArray2[0] = -2;
        nArray2[2] = 3;
        nArray2[3] = 1;
        nArray2[5] = 2;
        d = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)nArray2, (int[])new int[]{2, 3});
        try {
            e = DatasetUtils.choose((IntegerDataset)d, (Object[])new Object[]{c, -2}, (boolean)true, (boolean)false);
            Assert.fail((String)"Should have thrown an array index OOB exception");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        e = DatasetUtils.choose((IntegerDataset)d, (Object[])new Object[]{c, -2}, (boolean)false, (boolean)false);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{0.0, 1.0, -2.0, -2.0, -7.0, -9.0}, (int[])new int[]{2, 3}), (Dataset)e);
        e = DatasetUtils.choose((IntegerDataset)d, (Object[])new Object[]{c, -2}, (boolean)false, (boolean)true);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{0.0, 1.0, -2.0, -2.0, -7.0, -2.0}, (int[])new int[]{2, 3}), (Dataset)e);
        Dataset f = b.clone().reshape(new int[]{2, 3});
        int[] nArray3 = new int[6];
        nArray3[0] = 1;
        nArray3[2] = 1;
        nArray3[3] = 1;
        nArray3[4] = 2;
        nArray3[5] = 2;
        IntegerDataset g = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)nArray3, (int[])new int[]{2, 3});
        e = DatasetUtils.choose((IntegerDataset)g, (Object[])new Object[]{c, f, -2}, (boolean)true, (boolean)false);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{0.01, 1.0, 2.9, 5.0, -2.0, -2.0}, (int[])new int[]{2, 3}), (Dataset)e);
        g = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)new int[]{-1, 3, 1, 1, 2, 2}, (int[])new int[]{2, 3});
        try {
            e = DatasetUtils.choose((IntegerDataset)d, (Object[])new Object[]{c, f, -2}, (boolean)true, (boolean)false);
            Assert.fail((String)"Should have thrown an array index OOB exception");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        e = DatasetUtils.choose((IntegerDataset)g, (Object[])new Object[]{c, f, -2}, (boolean)false, (boolean)false);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{-2.0, 1.0, 2.9, 5.0, -2.0, -2.0}, (int[])new int[]{2, 3}), (Dataset)e);
        e = DatasetUtils.choose((IntegerDataset)g, (Object[])new Object[]{c, f, -2}, (boolean)false, (boolean)true);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{0.0, -2.0, 2.9, 5.0, -2.0, -2.0}, (int[])new int[]{2, 3}), (Dataset)e);
    }

    @Test
    public void testSize() {
        int[] zero = new int[1];
        int[] one = new int[]{};
        int[] small = new int[]{2};
        int[] medium = new int[]{1024, 1024};
        int[] large = new int[]{1024, 1024, 1024};
        int[] xxxlarge = new int[]{1024, 1024, 1024, 1024};
        int[] bad = new int[]{1024, -1, 1024};
        Assert.assertEquals((long)0L, (long)ShapeUtils.calcLongSize((int[])zero));
        Assert.assertEquals((long)0L, (long)ShapeUtils.calcSize((int[])zero));
        Assert.assertEquals((long)1L, (long)ShapeUtils.calcLongSize((int[])one));
        Assert.assertEquals((long)1L, (long)ShapeUtils.calcSize((int[])one));
        Assert.assertEquals((long)2L, (long)ShapeUtils.calcLongSize((int[])small));
        Assert.assertEquals((long)2L, (long)ShapeUtils.calcSize((int[])small));
        Assert.assertEquals((long)0x100000L, (long)ShapeUtils.calcLongSize((int[])medium));
        Assert.assertEquals((long)0x100000L, (long)ShapeUtils.calcSize((int[])medium));
        Assert.assertEquals((long)0x40000000L, (long)ShapeUtils.calcLongSize((int[])large));
        Assert.assertEquals((long)0x40000000L, (long)ShapeUtils.calcSize((int[])large));
        Assert.assertEquals((long)0x10000000000L, (long)ShapeUtils.calcLongSize((int[])xxxlarge));
        try {
            ShapeUtils.calcSize((int[])xxxlarge);
            Assert.fail((String)"Should have thrown an illegal argument exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable t) {
            Assert.fail((String)"Should have thrown an illegal argument exception");
        }
        try {
            ShapeUtils.calcLongSize((int[])bad);
            Assert.fail((String)"Should have thrown an illegal argument exception");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            Assert.fail((String)"Should have thrown an illegal argument exception");
        }
        try {
            ShapeUtils.calcSize((int[])bad);
            Assert.fail((String)"Should have thrown an illegal argument exception");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            Assert.fail((String)"Should have thrown an illegal argument exception");
        }
    }

    @Test
    public void testFill() {
        Dataset a = DatasetFactory.createRange(DoubleDataset.class, (double)12.0);
        Dataset b = DatasetFactory.zeros((Dataset)a);
        a.fill((Object)0);
        TestUtils.assertDatasetEquals((Dataset)b, (Dataset)a, (double)1.0E-15, (double)1.0E-20);
        a.fill((Object)0.0);
        TestUtils.assertDatasetEquals((Dataset)b, (Dataset)a, (double)1.0E-15, (double)1.0E-20);
        a.fill((Object)0L);
        TestUtils.assertDatasetEquals((Dataset)b, (Dataset)a, (double)1.0E-15, (double)1.0E-20);
        a.fill((Object)new Complex(0.0));
        TestUtils.assertDatasetEquals((Dataset)b, (Dataset)a, (double)1.0E-15, (double)1.0E-20);
        a.fill((Object)DatasetFactory.createFromObject((Object)0));
        TestUtils.assertDatasetEquals((Dataset)b, (Dataset)a, (double)1.0E-15, (double)1.0E-20);
        a.fill((Object)DatasetFactory.createFromObject((Object)new int[1]));
        TestUtils.assertDatasetEquals((Dataset)b, (Dataset)a, (double)1.0E-15, (double)1.0E-20);
        try {
            int[] nArray = new int[2];
            nArray[1] = 1;
            a.fill((Object)DatasetFactory.createFromObject((Object)nArray));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPositions() {
        int[] shape = new int[]{23, 34, 2};
        int[] indexes = new int[]{1, 10, 70, 171};
        List list = DatasetUtils.calcPositionsFromIndexes((Dataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)indexes, (int[])new int[]{2, 2}), (int[])shape);
        Assert.assertEquals((long)shape.length, (long)list.size());
        IntegerDataset l = (IntegerDataset)list.get(0);
        Assert.assertEquals((long)2L, (long)l.getRank());
        Assert.assertEquals((long)2L, (long)l.getShapeRef()[0]);
        Assert.assertEquals((long)2L, (long)l.getShapeRef()[1]);
        int[] nArray = new int[3];
        nArray[2] = 1;
        this.checkPositions(list, nArray, 0, 0);
        int[] nArray2 = new int[3];
        nArray2[1] = 5;
        this.checkPositions(list, nArray2, 0, 1);
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArray3[1] = 1;
        this.checkPositions(list, nArray3, 1, 0);
        this.checkPositions(list, new int[]{2, 17, 1}, 1, 1);
    }

    private void checkPositions(List<IntegerDataset> list, int[] expected, int ... position) {
        int j = 0;
        int[] nArray = expected;
        int n = expected.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            IntegerDataset l = list.get(j++);
            Assert.assertEquals((long)i, (long)l.getInt(position));
            ++n2;
        }
    }

    @Test
    public void testIndexes() {
        ArrayList<IntegerDataset> list = new ArrayList<IntegerDataset>();
        int[] shape = new int[]{23, 34, 2};
        int[] nArray = new int[4];
        nArray[2] = 1;
        nArray[3] = 2;
        list.add((IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)nArray, (int[])new int[]{2, 2}));
        int[] nArray2 = new int[4];
        nArray2[1] = 5;
        nArray2[2] = 1;
        nArray2[3] = 17;
        list.add((IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)nArray2, (int[])new int[]{2, 2}));
        int[] nArray3 = new int[4];
        nArray3[0] = 1;
        nArray3[3] = 1;
        list.add((IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)nArray3, (int[])new int[]{2, 2}));
        IntegerDataset indexes = DatasetUtils.calcIndexesFromPositions(list, (int[])shape, null);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new int[]{1, 10, 70, 171}, (int[])new int[]{2, 2}), (Dataset)indexes);
        int[] nArray4 = new int[4];
        nArray4[1] = -5;
        nArray4[2] = 1;
        nArray4[3] = 17;
        list.set(1, (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)nArray4, (int[])new int[]{2, 2}));
        try {
            indexes = DatasetUtils.calcIndexesFromPositions(list, (int[])shape, null);
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int[] nArray5 = new int[4];
        nArray5[1] = 34;
        nArray5[2] = 1;
        nArray5[3] = 17;
        list.set(1, (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)nArray5, (int[])new int[]{2, 2}));
        try {
            indexes = DatasetUtils.calcIndexesFromPositions(list, (int[])shape, null);
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int[] nArray6 = new int[4];
        nArray6[1] = 39;
        nArray6[2] = 1;
        nArray6[3] = 17;
        list.set(1, (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)nArray6, (int[])new int[]{2, 2}));
        indexes = DatasetUtils.calcIndexesFromPositions(list, (int[])shape, (int[])new int[]{1});
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new int[]{1, 10, 70, 171}, (int[])new int[]{2, 2}), (Dataset)indexes);
        int[] nArray7 = new int[4];
        nArray7[1] = -29;
        nArray7[2] = 1;
        nArray7[3] = 17;
        list.set(1, (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)nArray7, (int[])new int[]{2, 2}));
        indexes = DatasetUtils.calcIndexesFromPositions(list, (int[])shape, (int[])new int[]{1});
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new int[]{1, 10, 70, 171}, (int[])new int[]{2, 2}), (Dataset)indexes);
        list.set(1, (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)new int[]{-2, 5, 1, 17}, (int[])new int[]{2, 2}));
        indexes = DatasetUtils.calcIndexesFromPositions(list, (int[])shape, (int[])new int[]{2});
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new int[]{1, 10, 70, 171}, (int[])new int[]{2, 2}), (Dataset)indexes);
        list.set(1, (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)new int[]{34, 5, 1, 17}, (int[])new int[]{2, 2}));
        indexes = DatasetUtils.calcIndexesFromPositions(list, (int[])shape, (int[])new int[]{2});
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new int[]{67, 10, 70, 171}, (int[])new int[]{2, 2}), (Dataset)indexes);
    }

    @Test
    public void testSetByBoolean() {
        Dataset a = DatasetFactory.createRange(IntegerDataset.class, (double)10.0);
        a.max(new boolean[0]);
        a.setByBoolean((Object)0, (Dataset)Comparisons.greaterThan((Object)a, (Object)5));
        Assert.assertEquals((long)a.max(new boolean[0]).longValue(), (long)5L);
    }

    @Test
    public void testExtract() {
        Dataset a = ((IntegerDataset)DatasetFactory.createRange(IntegerDataset.class, (double)20.0)).reshape(new int[]{4, 5});
        boolean[] blArray = new boolean[5];
        blArray[0] = true;
        blArray[2] = true;
        Dataset b = DatasetFactory.createFromObject((Object)blArray);
        int[] nArray = new int[8];
        nArray[1] = 2;
        nArray[2] = 5;
        nArray[3] = 7;
        nArray[4] = 10;
        nArray[5] = 12;
        nArray[6] = 15;
        nArray[7] = 17;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)nArray), (Dataset)DatasetUtils.extract((IDataset)a, (IDataset)b));
    }

    @Test
    public void testSetBy1DIndex() {
        Dataset a = DatasetFactory.createRange(IntegerDataset.class, (double)10.0);
        a.max(new boolean[0]);
        a.setBy1DIndex((Object)0, (Dataset)Comparisons.nonZero((Dataset)Comparisons.greaterThan((Object)a, (Object)5)).get(0));
        Assert.assertEquals((long)5L, (long)a.max(new boolean[0]).longValue());
    }

    @Test
    public void testSetByPosition() {
        Dataset a = DatasetFactory.createRange(IntegerDataset.class, (double)10.0);
        Assert.assertEquals((long)9L, (long)a.max(new boolean[0]).longValue());
        List list = Comparisons.nonZero((Dataset)Comparisons.greaterThan((Object)a, (Object)5));
        a.setByIndexes((Object)0, new Object[]{list.get(0)});
        Assert.assertEquals((long)5L, (long)a.max(new boolean[0]).longValue());
        a = ((IntegerDataset)DatasetFactory.createRange(IntegerDataset.class, (double)10.0)).reshape(new int[]{2, 5});
        Assert.assertEquals((long)9L, (long)a.max(new boolean[0]).longValue());
        list = Comparisons.nonZero((Dataset)Comparisons.greaterThan((Object)a, (Object)5));
        a.setByIndexes((Object)0, new Object[]{list.get(0), list.get(1)});
        Assert.assertEquals((long)5L, (long)a.max(new boolean[0]).longValue());
    }

    @Test
    public void testSetByNegativePositions() {
        Dataset a = DatasetFactory.createRange(IntegerDataset.class, (double)10.0);
        a.setByIndexes((Object)0, new Object[]{DatasetFactory.createFromObject((Object)new int[]{1, 5, -8})});
        Assert.assertEquals((long)0L, (long)a.getInt(1));
        Assert.assertEquals((long)0L, (long)a.getInt(5));
        Assert.assertEquals((long)0L, (long)a.getInt(-8));
        a = ((IntegerDataset)DatasetFactory.createRange(IntegerDataset.class, (double)10.0)).reshape(new int[]{2, 5});
        Object[] objectArray = new Object[2];
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = -1;
        objectArray[0] = DatasetFactory.createFromObject((Object)nArray);
        int[] nArray2 = new int[3];
        nArray2[1] = 2;
        nArray2[2] = -4;
        objectArray[1] = DatasetFactory.createFromObject((Object)nArray2);
        a.setByIndexes((Object)-2, objectArray);
        Assert.assertEquals((long)-2L, (long)a.getInt(1, 0));
        Assert.assertEquals((long)-2L, (long)a.getInt(-1, 2));
        Assert.assertEquals((long)-2L, (long)a.getInt(0, -4));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetByInvalidPositivePositions() {
        Dataset a = ((IntegerDataset)DatasetFactory.createRange(IntegerDataset.class, (double)10.0)).reshape(new int[]{2, 5});
        Object[] objectArray = new Object[2];
        objectArray[0] = DatasetFactory.createFromObject((Object)new int[]{1, -1, 2});
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = -4;
        objectArray[1] = DatasetFactory.createFromObject((Object)nArray);
        a.setByIndexes((Object)-2, objectArray);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetByInvalidPositivePositions2() {
        Dataset a = ((IntegerDataset)DatasetFactory.createRange(IntegerDataset.class, (double)10.0)).reshape(new int[]{2, 5});
        Object[] objectArray = new Object[2];
        objectArray[0] = DatasetFactory.createFromObject((Object)new int[]{1, -1, 3});
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = -4;
        objectArray[1] = DatasetFactory.createFromObject((Object)nArray);
        a.setByIndexes((Object)-2, objectArray);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetByInvalidNegativePositions() {
        Dataset a = ((IntegerDataset)DatasetFactory.createRange(IntegerDataset.class, (double)10.0)).reshape(new int[]{2, 5});
        Object[] objectArray = new Object[2];
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = -1;
        objectArray[0] = DatasetFactory.createFromObject((Object)nArray);
        int[] nArray2 = new int[3];
        nArray2[1] = 2;
        nArray2[2] = -6;
        objectArray[1] = DatasetFactory.createFromObject((Object)nArray2);
        a.setByIndexes((Object)-2, objectArray);
    }

    @Test
    public void testReshape() {
        Dataset a = DatasetFactory.createRange(IntegerDataset.class, (double)60.0);
        Dataset b = a.getSliceView(new int[]{1}, null, new int[]{2});
        Dataset c = a.getSlice(new int[]{1}, null, new int[]{2});
        TestUtils.assertDatasetEquals((Dataset)c, (Dataset)b);
        b.setShape(new int[]{6, 5});
        c.setShape(new int[]{6, 5});
        TestUtils.assertDatasetEquals((Dataset)c, (Dataset)b);
        b.setShape(new int[]{1, 6, 5});
        c.setShape(new int[]{1, 6, 5});
        TestUtils.assertDatasetEquals((Dataset)c, (Dataset)b);
        b.setShape(new int[]{1, 6, 1, 5});
        c.setShape(new int[]{1, 6, 1, 5});
        TestUtils.assertDatasetEquals((Dataset)c, (Dataset)b);
        b.setShape(new int[]{30});
        c.setShape(new int[]{30});
        TestUtils.assertDatasetEquals((Dataset)c, (Dataset)b);
        b.setShape(new int[]{6, 5});
        try {
            Dataset d = b.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(6), Integer.valueOf(2))});
            d.setShape(new int[]{15});
            Assert.fail((String)"Should have thrown an illegal argument exception");
        }
        catch (IllegalArgumentException d) {
        }
        catch (Exception e) {
            Assert.fail((String)"Should have thrown an illegal argument exception");
        }
    }

    @Test
    public void testDatasetVariance() {
        Random.seed((int)12345);
        Dataset image = Maths.multiply((Object)Random.rand((int[])new int[]{10, 10}), (Object)1);
        double mean = ((Number)image.mean(new boolean[0])).doubleValue();
        Dataset square = Maths.square((Object)Maths.subtract((Object)image, (Object)mean));
        double var = ((Number)square.mean(new boolean[0])).doubleValue();
        Assert.assertEquals((double)var, (double)image.variance(true, new boolean[0]), (double)(var * 1.0E-15));
    }

    @Test
    public void testBroadcast() {
        Dataset a = DatasetFactory.createRange(IntegerDataset.class, (double)3.0);
        Dataset b = this.checkBroadcast2D(a, false, 2, 3);
        Assert.assertEquals((long)1L, (long)b.getInt(0, 1));
        Assert.assertEquals((long)1L, (long)b.getInt(1, 1));
        a.setShape(new int[]{3, 1});
        b = this.checkBroadcast2D(a, true, 3, 4);
        Assert.assertEquals((long)1L, (long)b.getInt(1, 0));
        Assert.assertEquals((long)1L, (long)b.getInt(1, 1));
    }

    private Dataset checkBroadcast2D(Dataset a, boolean broadcastFirstDim, int ... broadcastShape) {
        Dataset b = a.getBroadcastView(broadcastShape);
        Assert.assertArrayEquals((int[])broadcastShape, (int[])b.getShapeRef());
        int size = ShapeUtils.calcSize((int[])broadcastShape);
        Assert.assertEquals((long)size, (long)b.getSize());
        IndexIterator it = b.getIterator(true);
        int[] pos = it.getPos();
        int i = 0;
        while (it.hasNext()) {
            ++i;
            if (broadcastFirstDim) {
                Assert.assertEquals((long)a.getInt(pos[0], 0), (long)b.getInt(pos));
                Assert.assertEquals((long)a.getInt(pos[0], 0), (long)b.getElementLongAbs(it.index));
                continue;
            }
            Assert.assertEquals((long)a.getInt(pos[1]), (long)b.getInt(pos));
            Assert.assertEquals((long)a.getInt(pos[1]), (long)b.getElementLongAbs(it.index));
        }
        Assert.assertEquals((long)size, (long)i);
        return b;
    }

    @Test
    public void testBroadcastSliceView() {
        Dataset a = DatasetFactory.createRange(IntegerDataset.class, (double)12.0);
        Dataset b = a.getSliceView(new Slice[]{new Slice(Integer.valueOf(5), Integer.valueOf(8))}).getBroadcastView(new int[]{2, 3});
        Dataset r = ((IntegerDataset)DatasetFactory.createRange(IntegerDataset.class, (double)5.0, (double)8.0, (double)1.0)).reshape(new int[]{1, 3});
        Dataset c = DatasetUtils.concatenate((IDataset[])new Dataset[]{r, r}, (int)0);
        TestUtils.assertDatasetEquals((Dataset)c, (Dataset)b);
        b = a.getSliceView(new Slice[]{new Slice(Integer.valueOf(5), Integer.valueOf(6))}).getBroadcastView(new int[]{3, 3});
        c = ((IntegerDataset)DatasetFactory.zeros(IntegerDataset.class, (int[])new int[]{3, 3})).fill((Object)5);
        TestUtils.assertDatasetEquals((Dataset)c, (Dataset)b);
    }

    @Test
    public void testFlips() {
        DoubleDataset a = Random.rand((int[])new int[]{3, 5});
        TestUtils.assertDatasetEquals((Dataset)a.getSlice(new Slice[]{new Slice(null, null, Integer.valueOf(-1))}), (Dataset)DatasetUtils.flipUpDown((Dataset)a));
        TestUtils.assertDatasetEquals((Dataset)a.getSlice(new Slice[]{null, new Slice(null, null, Integer.valueOf(-1))}), (Dataset)DatasetUtils.flipLeftRight((Dataset)a));
        Dataset b = DatasetUtils.rotate90((Dataset)a, (int)1);
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)DatasetUtils.rotate90((Dataset)a, (int)0));
        TestUtils.assertDatasetEquals((Dataset)b, (Dataset)DatasetUtils.rotate90((Dataset)a, (int)1));
        TestUtils.assertDatasetEquals((Dataset)DatasetUtils.rotate90((Dataset)b, (int)1), (Dataset)DatasetUtils.rotate90((Dataset)a, (int)2));
        TestUtils.assertDatasetEquals((Dataset)DatasetUtils.rotate90((Dataset)b, (int)2), (Dataset)DatasetUtils.rotate90((Dataset)a, (int)3));
        TestUtils.assertDatasetEquals((Dataset)DatasetUtils.rotate90((Dataset)a, (int)-1), (Dataset)DatasetUtils.rotate90((Dataset)a, (int)3));
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)DatasetUtils.rotate90((Dataset)a, (int)4));
    }

    @Test
    public void testSerializable() throws IOException, ClassNotFoundException {
        DoubleDataset a = DatasetFactory.createRange((double)12.0);
        a.setShape(new int[]{3, 4});
        Assert.assertEquals((String)"Max", (double)11.0, (double)a.max(new boolean[0]).doubleValue(), (double)1.0E-6);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream ostream = new ObjectOutputStream(out);
        ostream.writeObject(a);
        ostream.close();
        byte[] bytes = out.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ObjectInputStream istream = new ObjectInputStream(in);
        Dataset b = (Dataset)Dataset.class.cast(istream.readObject());
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)b);
        StatisticsMetadata am = (StatisticsMetadata)a.getFirstMetadata(StatisticsMetadata.class);
        StatisticsMetadata bm = (StatisticsMetadata)b.getFirstMetadata(StatisticsMetadata.class);
        Assert.assertEquals((Object)am.getMinimum(new boolean[0]), (Object)bm.getMinimum(new boolean[0]));
        Assert.assertEquals((Object)am.getMaximum(new boolean[0]), (Object)bm.getMaximum(new boolean[0]));
    }
}

