/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.math3.complex.Complex;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.BinaryOperation;
import org.eclipse.january.dataset.Operations;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BinaryOperationTest {
    private static double C_M = Math.exp(0.5 * Math.log(2.0) - 0.7853981633974483);
    private static double C_A = 0.5 * Math.log(2.0) + 0.7853981633974483;
    private BinaryOperation operation;
    private Object[] expected;
    private Object[][] operands;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        Object[][] objectArrayArray = new Object[15][];
        Object[] objectArray = new Object[3];
        objectArray[0] = Operations.Addition.class;
        objectArray[2] = new Object[][]{{false, 0L, 0L}, {true, 1L, 0L}, {true, 0L, 1L}, {true, 1L, 1L}, {0L, 0L, 0L}, {1L, 1L, 0L}, {1L, 0L, 1L}, {2L, 1L, 1L}, {0.0, 0.0, 0.0}, {1.0, 1.0, 0.0}, {1.0, 0.0, 1.0}, {2.0, 1.0, 1.0}, {new Complex(0.0), 0.0, 0.0, 0.0, 0.0}, {new Complex(1.0), 1.0, 0.0, 0.0, 0.0}, {new Complex(1.0), 0.0, 0.0, 1.0, 0.0}, {new Complex(2.0), 1.0, 0.0, 1.0, 0.0}, {new Complex(0.0, 0.0), 0.0, 0.0, 0.0, 0.0}, {new Complex(1.0, 1.0), 1.0, 1.0, 0.0, 0.0}, {new Complex(1.0, 1.0), 0.0, 1.0, 1.0, 0.0}, {new Complex(2.0, 2.0), 1.0, 1.0, 1.0, 1.0}};
        objectArrayArray[0] = objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = Operations.Subtraction.class;
        objectArray2[2] = new Object[][]{{true, 0L, 0L}, {true, 1L, 0L}, {false, 0L, 1L}, {true, 1L, 1L}, {0L, 0L, 0L}, {1L, 1L, 0L}, {-1L, 0L, 1L}, {0L, 1L, 1L}, {0.0, 0.0, 0.0}, {1.0, 1.0, 0.0}, {-1.0, 0.0, 1.0}, {0.0, 1.0, 1.0}, {new Complex(0.0), 0.0, 0.0, 0.0, 0.0}, {new Complex(1.0), 1.0, 0.0, 0.0, 0.0}, {new Complex(-1.0), 0.0, 0.0, 1.0, 0.0}, {new Complex(0.0), 1.0, 0.0, 1.0, 0.0}, {new Complex(0.0, 0.0), 0.0, 0.0, 0.0, 0.0}, {new Complex(1.0, 1.0), 1.0, 1.0, 0.0, 0.0}, {new Complex(-1.0, 1.0), 0.0, 1.0, 1.0, 0.0}, {new Complex(0.0, 0.0), 1.0, 1.0, 1.0, 1.0}};
        objectArrayArray[1] = objectArray2;
        Object[] objectArray3 = new Object[3];
        objectArray3[0] = Operations.Multiplication.class;
        objectArray3[2] = new Object[][]{{false, 0L, 0L}, {false, 1L, 0L}, {false, 0L, 1L}, {true, 1L, 1L}, {0L, 0L, 0L}, {0L, 1L, 0L}, {0L, 0L, 1L}, {2L, 2L, 1L}, {0.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {2.0, 2.0, 1.0}, {new Complex(0.0), 0.0, 0.0, 0.0, 0.0}, {new Complex(0.0), 1.0, 0.0, 0.0, 0.0}, {new Complex(0.0), 0.0, 0.0, 1.0, 0.0}, {new Complex(1.0), 1.0, 0.0, 1.0, 0.0}, {new Complex(0.0, 0.0), 0.0, 0.0, 0.0, 0.0}, {new Complex(0.0), 1.0, 1.0, 0.0, 0.0}, {new Complex(0.0, 1.0), 0.0, 1.0, 1.0, 0.0}, {new Complex(0.0, 2.0), 1.0, 1.0, 1.0, 1.0}};
        objectArrayArray[2] = objectArray3;
        Object[] objectArray4 = new Object[3];
        objectArray4[0] = Operations.Division.class;
        objectArray4[2] = new Object[][]{{false, 0L, 0L}, {true, 1L, 0L}, {false, 0L, 1L}, {false, 1L, 1L}, {0L, 0L, 0L}, {0L, 1L, 0L}, {0L, 0L, 1L}, {2L, 2L, 1L}, {-2L, -5L, 2L}, {-1L, -5L, 3L}, {-2L, 5L, -2L}, {-1L, 5L, -3L}, {2L, -5L, -2L}, {1L, -5L, -3L}, {Double.NaN, 0.0, 0.0}, {Double.POSITIVE_INFINITY, 1.0, 0.0}, {0.0, 0.0, 1.0}, {2.0, 2.0, 1.0}, {new Complex(Double.NaN, Double.NaN), 0.0, 0.0, 0.0, 0.0}, {new Complex(Double.POSITIVE_INFINITY, Double.NaN), 1.0, 0.0, 0.0, 0.0}, {new Complex(0.0), 0.0, 0.0, 1.0, 0.0}, {new Complex(1.0), 1.0, 0.0, 1.0, 0.0}, {new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY), 1.0, 1.0, 0.0, 0.0}, {new Complex(0.0, 1.0), 0.0, 1.0, 1.0, 0.0}, {new Complex(1.0, 0.0), 1.0, 1.0, 1.0, 1.0}};
        objectArrayArray[3] = objectArray4;
        Object[] objectArray5 = new Object[3];
        objectArray5[0] = Operations.DivisionWithZero.class;
        objectArray5[2] = new Object[][]{{false, 0L, 0L}, {true, 1L, 0L}, {false, 0L, 1L}, {false, 1L, 1L}, {0L, 0L, 0L}, {0L, 1L, 0L}, {0L, 0L, 1L}, {2L, 2L, 1L}, {new Complex(0.0), 0.0, 0.0, 0.0, 0.0}, {new Complex(0.0), 1.0, 0.0, 0.0, 0.0}, {new Complex(0.0), 0.0, 0.0, 1.0, 0.0}, {new Complex(1.0), 1.0, 0.0, 1.0, 0.0}, {new Complex(0.0), 1.0, 1.0, 0.0, 0.0}, {new Complex(0.0, 1.0), 0.0, 1.0, 1.0, 0.0}, {new Complex(1.0, 0.0), 1.0, 1.0, 1.0, 1.0}};
        objectArrayArray[4] = objectArray5;
        Object[] objectArray6 = new Object[3];
        objectArray6[0] = Operations.DivisionTowardsFloor.class;
        objectArray6[2] = new Object[][]{{false, 0L, 0L}, {true, 1L, 0L}, {false, 0L, 1L}, {false, 1L, 1L}, {0L, 0L, 0L}, {0L, 1L, 0L}, {0L, 0L, 1L}, {2L, 2L, 1L}, {-3L, -5L, 2L}, {-2L, -5L, 3L}, {-3L, 5L, -2L}, {-2L, 5L, -3L}, {2L, -5L, -2L}, {1L, -5L, -3L}, {Double.NaN, 0.0, 0.0}, {Double.POSITIVE_INFINITY, 1.0, 0.0}, {0.0, 0.0, 1.0}, {2.0, 2.0, 1.0}, {Complex.NaN, 0.0, 0.0, 0.0, 0.0}, {new Complex(Double.POSITIVE_INFINITY, Double.NaN), 1.0, 0.0, 0.0, 0.0}, {new Complex(0.0), 0.0, 0.0, 1.0, 0.0}, {new Complex(1.0), 1.0, 0.0, 1.0, 0.0}, {Complex.INF, 1.0, 1.0, 0.0, 0.0}, {new Complex(0.0, 1.0), 0.0, 1.0, 1.0, 0.0}, {new Complex(1.0, 0.0), 1.0, 1.0, 1.0, 1.0}};
        objectArrayArray[5] = objectArray6;
        Object[] objectArray7 = new Object[3];
        objectArray7[0] = Operations.Remainder.class;
        objectArray7[2] = new Object[][]{{0L, 0L, 0L}, {0L, 1L, 0L}, {0L, 0L, 1L}, {0L, 2L, 1L}, {-1L, -5L, 2L}, {-2L, -5L, 3L}, {1L, 5L, -2L}, {2L, 5L, -3L}, {-1L, -5L, -2L}, {-2L, -5L, -3L}, {Double.NaN, 0.0, 0.0}, {Double.NaN, 1.0, 0.0}, {0.0, 0.0, 1.0}, {0.0, 2.0, 1.0}};
        objectArrayArray[6] = objectArray7;
        Object[] objectArray8 = new Object[3];
        objectArray8[0] = Operations.Exponentiation.class;
        objectArray8[2] = new Object[][]{{true, 0L, 0L}, {true, 1L, 0L}, {false, 0L, 1L}, {true, 1L, 1L}, {1L, 0L, 0L}, {1L, 1L, 0L}, {0L, 0L, 1L}, {2L, 2L, 1L}, {1.0, 0.0, 0.0}, {1.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {2.0, 2.0, 1.0}, {Complex.NaN, 0.0, 0.0, 0.0, 0.0}, {new Complex(1.0), 1.0, 0.0, 0.0, 0.0}, {Complex.NaN, 0.0, 0.0, 1.0, 0.0}, {new Complex(1.0), 1.0, 0.0, 1.0, 0.0}, {Complex.NaN, 0.0, 0.0, 0.0, 0.0}, {new Complex(1.0), 1.0, 1.0, 0.0, 0.0}, {new Complex(0.0, 1.0), 0.0, 1.0, 1.0, 0.0}, {new Complex(C_M * Math.cos(C_A), C_M * Math.sin(C_A)), 1.0, 1.0, 1.0, 1.0}};
        objectArrayArray[7] = objectArray8;
        Object[] objectArray9 = new Object[3];
        objectArray9[0] = Operations.Maximum.class;
        objectArray9[2] = new Object[][]{{false, 0L, 0L}, {true, 1L, 0L}, {true, 0L, 1L}, {true, 1L, 1L}, {0L, 0L, 0L}, {1L, 1L, 0L}, {1L, 0L, 1L}, {2L, 2L, 1L}, {2L, -5L, 2L}, {3L, -5L, 3L}, {5L, 5L, -2L}, {5L, 5L, -3L}, {-2L, -5L, -2L}, {-3L, -5L, -3L}, {0.0, 0.0, 0.0}, {1.0, 1.0, 0.0}, {1.0, 0.0, 1.0}, {2.0, 2.0, 1.0}};
        objectArrayArray[8] = objectArray9;
        Object[] objectArray10 = new Object[3];
        objectArray10[0] = Operations.Minimum.class;
        objectArray10[2] = new Object[][]{{false, 0L, 0L}, {false, 1L, 0L}, {false, 0L, 1L}, {true, 1L, 1L}, {0L, 0L, 0L}, {0L, 1L, 0L}, {0L, 0L, 1L}, {1L, 2L, 1L}, {-5L, -5L, 2L}, {-5L, -5L, 3L}, {-2L, 5L, -2L}, {-3L, 5L, -3L}, {-5L, -5L, -2L}, {-5L, -5L, -3L}, {0.0, 0.0, 0.0}, {10, 1.0, 0.0}, {0.0, 0.0, 1.0}, {1.0, 2.0, 1.0}};
        objectArrayArray[9] = objectArray10;
        objectArrayArray[10] = new Object[]{Operations.UseIfGreaterThan.class, -2.5, new Object[][]{{false, 0L, 0L}, {true, 1L, 0L}, {false, 0L, 1L}, {true, 1L, 1L}, {0L, 0L, 0L}, {-2L, 1L, 0L}, {0L, 0L, 1L}, {-2L, 2L, 1L}, {-5L, -5L, 2L}, {-5L, -5L, 3L}, {-2L, 5L, -2L}, {-2L, 5L, -3L}, {-5L, -5L, -2L}, {-5L, -5L, -3L}, {0.0, 0.0, 0.0}, {-2.5, 1.0, 0.0}, {0.0, 0.0, 1.0}, {-2.5, 2.0, 1.0}}};
        objectArrayArray[11] = new Object[]{Operations.UseIfGreaterThanOrEqualTo.class, -2.5, new Object[][]{{true, 0L, 0L}, {true, 1L, 0L}, {false, 0L, 1L}, {true, 1L, 1L}, {-2L, 0L, 0L}, {-2L, 1L, 0L}, {0L, 0L, 1L}, {-2L, 2L, 1L}, {-5L, -5L, 2L}, {-5L, -5L, 3L}, {-2L, 5L, -2L}, {-2L, 5L, -3L}, {-5L, -5L, -2L}, {-5L, -5L, -3L}, {-2.5, 0.0, 0.0}, {-2.5, 1.0, 0.0}, {0.0, 0.0, 1.0}, {-2.5, 2.0, 1.0}}};
        objectArrayArray[12] = new Object[]{Operations.UseIfLessThan.class, -2.5, new Object[][]{{false, 0L, 0L}, {true, 1L, 0L}, {true, 0L, 1L}, {true, 1L, 1L}, {0L, 0L, 0L}, {1L, 1L, 0L}, {-2L, 0L, 1L}, {2L, 2L, 1L}, {-2L, -5L, 2L}, {-2L, -5L, 3L}, {5L, 5L, -2L}, {5L, 5L, -3L}, {-2L, -5L, -2L}, {-2L, -5L, -3L}, {0.0, 0.0, 0.0}, {1.0, 1.0, 0.0}, {-2.5, 0.0, 1.0}, {2.0, 2.0, 1.0}}};
        objectArrayArray[13] = new Object[]{Operations.UseIfLessThanOrEqualTo.class, -2.5, new Object[][]{{true, 0L, 0L}, {true, 1L, 0L}, {true, 0L, 1L}, {true, 1L, 1L}, {-2L, 0L, 0L}, {1L, 1L, 0L}, {-2L, 0L, 1L}, {2L, 2L, 1L}, {-2L, -5L, 2L}, {-2L, -5L, 3L}, {5L, 5L, -2L}, {5L, 5L, -3L}, {-2L, -5L, -2L}, {-2L, -5L, -3L}, {-2.5, 0.0, 0.0}, {1.0, 1.0, 0.0}, {-2.5, 0.0, 1.0}, {2.0, 2.0, 1.0}}};
        objectArrayArray[14] = new Object[]{Operations.UseIfEqualTo.class, -2.5, new Object[][]{{true, 0L, 0L}, {true, 1L, 0L}, {false, 0L, 1L}, {true, 1L, 1L}, {-2L, 0L, 0L}, {1L, 1L, 0L}, {0L, 0L, 1L}, {2L, 2L, 1L}, {-5L, -5L, 2L}, {-5L, -5L, 3L}, {5L, 5L, -2L}, {5L, 5L, -3L}, {-5L, -5L, -2L}, {-5L, -5L, -3L}, {-2.5, 0.0, 0.0}, {1.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {2.0, 2.0, 1.0}}};
        return Arrays.asList(objectArrayArray);
    }

    public BinaryOperationTest(Class<BinaryOperation> opClass, Object parameter, Object[][] values) throws Exception {
        if (parameter == null) {
            this.operation = opClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else if (parameter instanceof Number) {
            Constructor<BinaryOperation> c = opClass.getConstructor(Number.class);
            this.operation = c.newInstance(parameter);
        } else {
            throw new IllegalArgumentException("Parameter type is not supported");
        }
        int l = values.length;
        this.expected = new Object[l];
        this.operands = new Object[l][2];
        int i = 0;
        while (i < l) {
            Object[] o = values[i];
            this.expected[i] = o[0];
            this.operands[i] = Arrays.copyOfRange(o, 1, o.length);
            ++i;
        }
    }

    @Test
    public void testOp() {
        int i = 0;
        int imax = this.operands.length;
        while (i < imax) {
            Object[] vs = this.operands[i];
            Object ex = this.expected[i];
            String s = String.valueOf(this.toString()) + Arrays.toString(vs);
            if (ex instanceof Boolean) {
                Assert.assertEquals((String)s, (Object)ex, (Object)this.operation.booleanOperate(((Long)vs[0]).longValue(), ((Long)vs[1]).longValue()));
            } else if (ex instanceof Long) {
                Assert.assertEquals((String)s, (Object)ex, (Object)this.operation.longOperate(((Long)vs[0]).longValue(), ((Long)vs[1]).longValue()));
            } else if (ex instanceof Double) {
                TestUtils.assertEquals((String)s, (double)((Double)ex), (double)this.operation.doubleOperate(((Double)vs[0]).doubleValue(), ((Double)vs[1]).doubleValue()));
            } else if (ex instanceof Complex) {
                Complex cz = (Complex)ex;
                double[] cpx = new double[2];
                this.operation.complexOperate(cpx, ((Double)vs[0]).doubleValue(), ((Double)vs[1]).doubleValue(), ((Double)vs[2]).doubleValue(), ((Double)vs[3]).doubleValue());
                TestUtils.assertEquals((String)(String.valueOf(s) + ": real"), (double)cz.getReal(), (double)cpx[0], (double)1.0E-14, (double)7.0E-17);
                TestUtils.assertEquals((String)(String.valueOf(s) + ": imag"), (double)cz.getImaginary(), (double)cpx[1]);
            }
            ++i;
        }
    }

    public String toString() {
        return "Test of operation (" + this.operation + ") failed with " + Arrays.deepToString((Object[])this.operands);
    }
}

